%define debug 0

Name: linuxdcpp
Version: 1.0.3
Release: alt1.1.qa2
Summary: Linux Direct Connect Client
License: GPL
Group: Networking/File transfer
Url: http://linuxdcpp.berlios.de

Packager: Vladimir V Kamarzin <vvk@altlinux.ru>

Source: %name-%version.tar

BuildRequires: bzlib-devel glib2-devel libglade2-devel libgtk+2-devel scons zlib-devel libssl-devel
BuildRequires: gcc-c++ >= 3.4
BuildRequires: desktop-file-utils

%description
A client for Direct Connect ++ file sharing network.

%prep
%setup

%build
%if %debug
scons release=1 debug=1 PREFIX="/usr" FAKE_ROOT="%buildroot"
%else
scons release=1 debug=0 PREFIX="/usr" FAKE_ROOT="%buildroot"
%endif

%install
scons install

# icon for menu file
mkdir -p %buildroot%_datadir/icons/hicolor
cp -rp linuxdcpp-icons/* %buildroot%_datadir/icons/hicolor/

# menu file
mkdir -p %buildroot%_desktopdir
install -pm644 linuxdcpp.desktop %buildroot%_desktopdir/linuxdcpp.desktop

# move to more generic place
mv %buildroot%_docdir/%name %buildroot%_docdir/%name-%version

%if %debug
%add_strip_skiplist %_bindir/linuxdcpp
%endif
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=FileTransfer \
	--add-category=P2P \
	%buildroot%_desktopdir/linuxdcpp.desktop

%files
%_bindir/%name
%_datadir/%name
%_desktopdir/linuxdcpp.desktop
%_iconsdir/hicolor/*/apps/%name.png
%_docdir/%name-%version

%changelog
