Name: lirc
Version: 0.9.0
Release: alt3

Summary: The Linux Infrared Remote Control package
License: GPL
Group: System/Base
URL: http://www.lirc.org

Source: %name-%version.tar
Source1: lircd
Source2: lircd.sysconfig
Source3: lircd.service
Source4: liblircclient0.pc

Patch1: %name-0.8.1-alt-configure.patch
Patch2: %name-0.8.0pre4-hiddev_fix.patch
Patch3: %name-alt-font-fix.patch
Patch4: %name-0.8.6-devpath.patch
Patch5: %name-0.8.6-fdiformat.patch

BuildRequires: libX11-devel libalsa-devel libftdi-devel

Requires: liblirc = %version-%release

%description
LIRC is a package that allows you to decode and send infra-red signals
of many (but not all) commonly used remote controls.

%package -n liblirc
Summary: Client library for LIRC
Group: System/Libraries

%description -n liblirc
Libraries needed by programs, which uses LIRC

%package -n liblirc-devel
Summary: Development for LIRC
Group: Development/C
Requires: lib%name = %version-%release

%description -n liblirc-devel
Development library for LIRC

%package remotes
Summary: LIRC remote definitions
Group: System/Base
BuildArch: noarch

%description remotes
LIRC is a package that allows you to decode and send infra-red and
other signals of many (but not all) commonly used remote controls.
Included applications include daemons which decode the received
signals as well as user space applications which allow controlling a
computer with a remote control.  This package contains a collection
of remote control configuration files.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p2
%patch5 -p2

for f in remotes/chronos/lircd.conf.chronos \
    remotes/creative/lircd.conf.livedrive remotes/atiusb/lircd.conf.atiusb \
    NEWS ChangeLog AUTHORS contrib/lircrc ; do
    iconv -f iso-8859-1 -t utf-8 $f > $f.utf8 ; mv $f.utf8 $f
done

%build
%add_optflags -I%_includedir/libftdi
%autoreconf
%configure  --disable-static --localstatedir=%_var \
	    --with-x --with-syslog --with-driver=userspace \
	    --with-port=0x3f8 --with-irq=4
make

%install
%makeinstall varrundir=%buildroot/%_runtimedir
%makeinstall -C doc/man
install -pm755 -D %SOURCE1 %buildroot%_initdir/lircd
install -pm644 -D %SOURCE2 %buildroot%_sysconfdir/sysconfig/lircd
install -pm644 -D %SOURCE3 %buildroot%systemd_unitdir/lircd.service
install -pm644 -D %SOURCE4 %buildroot%_datadir/pkgconfig/liblircclient0.pc
install -pm600 contrib/lircd.conf contrib/lircmd.conf %buildroot%_sysconfdir
mkdir -p %buildroot/%_runtimedir/lirc %buildroot%_tmpfilesdir
echo 'd /var/run/lirc 0755 root root' > %buildroot%_tmpfilesdir/lirc.conf
# relocate to docdir to avoid python deps
rm -f %buildroot%_bindir/pronto2lirc
# Put remote definitions in place
cp -ar remotes %buildroot%_datadir/lirc-remotes

%pre
/usr/sbin/groupadd -r -f %name &> /dev/null ||:

%post
%post_service lircd

%preun
%preun_service lircd

%files
%doc NEWS TODO doc/lirc.css doc/irxevent.keys doc/html doc/images
%doc tools/pronto2lirc.py
%config(noreplace) %_sysconfdir/sysconfig/lircd
%config(noreplace) %_sysconfdir/lircd.conf
%config(noreplace) %_sysconfdir/lircmd.conf
%systemd_unitdir/lircd.service
%_initdir/*
%_bindir/*
%attr(2711,root,%name) %_sbindir/lircd
%_sbindir/lircmd
%_man1dir/*.1*
%_man8dir/*.8*
%_tmpfilesdir/lirc.conf
%_runtimedir/lirc

%files -n liblirc
%_libdir/liblirc_client.so.*

%files -n liblirc-devel
%_libdir/liblirc_client.so
%_includedir/*
%_datadir/pkgconfig/*

%files remotes
%dir %_datadir/lirc-remotes
%_datadir/lirc-remotes/*

%changelog
