Name: live555
Version: 20120913
Release: alt1

Summary: Live555.com Streaming Media Library Utilities
License: LGPL
Group: System/Libraries
Url: http://www.live555.com/liveMedia/

Source: %name-%version-%release.tar

Requires: lib%name = %version-%release
# renamed...
Provides: live = %version-%release
Obsoletes: live < %version-%release

BuildRequires: gcc-c++

%description
This code forms a set of C++ libraries for multimedia streaming, using
open standard protocols (RTP/RTCP, RTSP, SIP). These libraries - which
can be compiled for Unix (including Linux and Mac OS X), Windows, and
QNX (and other POSIX-compliant systems) - can be used to build
streaming applications.

This package contains the example apps of live555.com.

%package -n lib%name
Summary: Live555.com Streaming Media Library
Group: System/Libraries
Provides: liblive555-0 = %version-%release
Obsoletes: liblive555-0

%package -n lib%name-devel
Summary: Development files of the Live555.com Streaming Media Library
Group: Development/C++
Requires: lib%name = %version-%release
Provides: liblive-devel = %version-%release
Obsoletes: liblive-devel < %version-%release

%description -n lib%name
This code forms a set of C++ libraries for multimedia streaming, using
open standard protocols (RTP/RTCP, RTSP, SIP). These libraries - which
can be compiled for Unix (including Linux and Mac OS X), Windows, and
QNX (and other POSIX-compliant systems) - can be used to build
streaming applications.

This package contains live555 libraries.

%description -n lib%name-devel
This code forms a set of C++ libraries for multimedia streaming, using
open standard protocols (RTP/RTCP, RTSP, SIP). These libraries - which
can be compiled for Unix (including Linux and Mac OS X), Windows, and
QNX (and other POSIX-compliant systems) - can be used to build
streaming applications.

This package contains all needed files to build programs based on live555.com.

%prep
%setup

%build
./genMakefiles linux
make CFLAGS="%optflags %optflags_shared"

%install
install -pm0644 -D liveMedia/libliveMedia.so %buildroot%_libdir/libliveMedia.so.%version
ln -sf libliveMedia.so.%version %buildroot%_libdir/libliveMedia.so

for i in BasicUsageEnvironment groupsock liveMedia UsageEnvironment ; do
  install -dm0755 %buildroot%_includedir/$i
  install -pm0644 $i/include/*.h* %buildroot%_includedir/$i/
done

for f in BasicUsageEnvironment UsageEnvironment groupsock; do
echo 'INPUT(AS_NEEDED(%_libdir/libliveMedia.so.0))' >%buildroot%_libdir/lib$f.so
done

mkdir -p %buildroot%_bindir
for testprog in `find testProgs -type f -perm 755`; do
  install -p $testprog %buildroot%_bindir
done
%files
%doc COPYING README
%_bindir/*

%files -n lib%name
%_libdir/libliveMedia.so.*

%files -n lib%name-devel
%_libdir/lib*.so
%_includedir/BasicUsageEnvironment
%_includedir/UsageEnvironment
%_includedir/groupsock
%_includedir/liveMedia

%changelog
