Name: livecd-webkiosk
Version: 0.4.3
Release: alt3

Summary: start the browser for a suitable webkiosk environment
License: Public domain
Group: System/X11

Url: http://en.altlinux.org/starterkits
Packager: Michael Shigorin <mike@altlinux.org>

Requires: ratpoison xinit
BuildArch: noarch

%define skeldir %_sysconfdir/skel
%define ifacedir %_sysconfdir/net/ifaces/eth0
%define xsfile %skeldir/.xsession
%define wrapper %_bindir/webkiosk-browser

%description
%summary
(livecd specific; also employs some ratpoison)

%package seamonkey
Summary: seamonkey webkiosk setup
Group: System/X11
Requires: %name = %version-%release
Requires: seamonkey

%description seamonkey
%summary
(the browser == seamonkey)

%package firefox
Summary: firefox webkiosk setup
Group: System/X11
Requires: %name = %version-%release
Requires: livecd-firefox firefox-r-kiosk

%description firefox
%summary
(the browser == firefox)

#ifarch x86_64
%package chromium
Summary: chromium webkiosk setup
Group: System/X11
Requires: %name = %version-%release
Requires: chromium

%description chromium
%summary
(the browser == chromium)
#endif

%package qupzilla
Summary: qupzilla webkiosk setup
Group: System/X11
Requires: %name = %version-%release
Requires: qupzilla >= 1.8.0

%description qupzilla
%summary
(the browser == qupzilla)

%prep

%build

%install
mkdir -p %buildroot{%skeldir,%ifacedir}

cat > %buildroot%xsfile << _EOF_
#!/bin/sh
ratpoison &
[ -f /image/index.html ] && url=/image/index.html
while :; do
	xset s off; xset -dpms
	webkiosk-browser \$url
done
_EOF_
chmod +x %buildroot%xsfile

cat > %buildroot%skeldir/.ratpoisonrc << _EOF_
startup_message off
set border 0
set padding 0 0 0 0
set barpadding 0 0
escape F25
banish
_EOF_

cat > %buildroot%ifacedir/options << _EOF_
BOOTPROTO=dhcp
_EOF_

%post seamonkey
cat > %wrapper << _EOF_
#!/bin/sh
exec seamonkey -chrome "\$@"
_EOF_
chmod +x %wrapper

%post firefox
cat > %wrapper << _EOF_
#!/bin/sh
exec firefox "\$@"
_EOF_
chmod +x %wrapper

#ifarch x86_64
%post chromium
cat > %wrapper << _EOF_
#!/bin/sh
exec chromium --kiosk --start-maximized --disable-translate --no-first-run "\$@"
_EOF_
chmod +x %wrapper
#endif

%post qupzilla
cat > %wrapper << _EOF_
#!/bin/sh
exec qupzilla --fullscreen "\$@"
_EOF_
chmod +x %wrapper

%files
%skeldir/.ratpoisonrc
%ifacedir/options
%xsfile

%files seamonkey

%files firefox

#ifarch x86_64
%files chromium
#endif

%files qupzilla

%changelog
