%def_disable doxygen
%def_with ocaml

%define gccbootstrap 0

Name: llvm
Version: 3.3
Release: alt2
Summary: The Low Level Virtual Machine
Group: Development/C
License: NCSA
Url: http://llvm.org/

Source0: http://llvm.org/releases/%version/llvm-%version.src.tar.gz
Source1: http://llvm.org/releases/%version/cfe-%version.src.tar.gz
Source2: http://llvm.org/releases/%version/compiler-rt-%version.src.tar.gz
Source3: http://llvm.org/releases/%version/clang-tools-extra-%version.src.tar.gz

Patch1: llvm+clang-3.3-alt-add-alt-triplet.patch

BuildPreReq: /proc

%if %gccbootstrap
BuildRequires: gcc-c++
%else
BuildRequires: clang
%endif

# Automatically added by buildreq on Thu Aug 29 2013 (-ba)
# optimized out: elfutils gnu-config groff-base libstdc++-devel llvm ocaml ocaml-runtime perl-Encode perl-Pod-Escapes perl-Pod-Simple perl-Term-ANSIColor perl-podlators python-base python-modules rpm-build-ocaml tcl
BuildRequires: chrpath dejagnu libstdc++-devel groff-extra groff-ps libffi-devel perl-Pod-Parser perl-devel python-modules-compiler python-modules-unittest zip

%if_with ocaml
BuildRequires: ocamldoc ocaml
%endif

%if_enabled doxygen
BuildRequires: doxygen graphviz fonts-ttf-dejavu
%endif

%description
LLVM is a compiler infrastructure designed for compile-time,
link-time, runtime, and idle-time optimization of programs from
arbitrary programming languages.  The compiler infrastructure includes
mirror sets of programming tools as well as libraries with equivalent
functionality.

%package devel
Summary: Libraries and header files for LLVM
Group: Development/C
Requires: %name = %version-%release

%description devel
This package contains library and header files needed to develop new
native programs that use the LLVM infrastructure.

%package devel-static
Summary: Static libraries for LLVM
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package contains static libraries needed to develop new
native programs that use the LLVM infrastructure.

%package doc
Summary: Documentation for LLVM
Group: Documentation
BuildArch: noarch
Requires: %name = %version-%release

%description doc
Documentation for the LLVM compiler infrastructure.

%package -n clang
Summary: A C language family frontend for LLVM
License: NCSA
Group: Development/C
Requires: gcc = %__gcc_version

%description -n clang
clang: noun
    1. A loud, resonant, metallic sound.
    2. The strident call of a crane or goose.
    3. C-language family front-end toolkit.

The goal of the Clang project is to create a new C, C++, Objective C
and Objective C++ front-end for the LLVM compiler. Its tools are built
as libraries and designed to be loosely-coupled and extendable.

%package -n clang-devel
Summary: Header files for clang
Group: Development/C
Requires: clang = %version-%release

%description -n clang-devel
This package contains header files for the Clang compiler.

%package -n clang-analyzer
Summary: A source code analysis framework
License: NCSA
Group: Development/C
Requires: clang = %version-%release

%description -n clang-analyzer
The Clang Static Analyzer consists of both a source code analysis
framework and a standalone tool that finds bugs in C and Objective-C
programs. The standalone tool is invoked from the command-line, and is
intended to run in tandem with a build of a project or code base.

%package -n clang-doc
Summary: Documentation for Clang
Group: Documentation
BuildArch: noarch
Requires: %name = %version-%release

%description -n clang-doc
Documentation for the Clang compiler front-end.

%package apidoc
Summary: API documentation for LLVM
Group: Development/C
BuildArch: noarch
Requires: %name-docs = %version-%release

%description apidoc
API documentation for the LLVM compiler infrastructure.

%package -n clang-apidoc
Summary: API documentation for Clang
Group: Development/Languages
BuildArch: noarch
Requires: clang-doc = %version-%release

%description -n clang-apidoc
API documentation for the Clang compiler.

%package ocaml
Summary: OCaml binding for LLVM
Group: Development/Functional
Requires: %name = %version-%release
Requires: ocaml-runtime

%description ocaml
OCaml binding for LLVM.

%package ocaml-devel
Summary: Development files for %name-ocaml
Group: Development/Functional
Requires: %name-devel = %version-%release
Requires: %name-ocaml = %version-%release
Requires: ocaml

%description ocaml-devel
The %name-ocaml-devel package contains libraries and signature files
for developing applications that use %name-ocaml.

%package ocaml-doc
Summary: Documentation for LLVM's OCaml binding
Group: Documentation
BuildArch: noarch
Requires: %name-ocaml = %version-%release

%description ocaml-doc
HTML documentation for LLVM's OCaml binding.

%add_python_req_skip AppKit

%prep
%setup -n llvm-%version.src -a1 -a2 -a3
mv cfe-%version.src tools/clang
mv clang-tools-extra-%version.src tools/clang/tools/extra
mv compiler-rt-%version.src projects/compiler-rt

%patch1 -p1
sed -i "s|%{version}svn|%version|g" configure
sed -i 's|/lib /usr/lib $lt_ld_extra|%_libdir $lt_ld_extra|' configure

# build sets DOT_PATH = /usr/bin/dot, but _PATH_ is /usr/bin
find -name doxygen.cfg.in | xargs sed -i 's,\(^DOT_PATH[[:blank:]]*=\).*,\1,'
#sed -i 's/\(OmitFramePointer := \).*/\1/' Makefile.rules

# some strange failing tests
rm tools/clang/test/Driver/{android-standalone,linux-header-search,mips-cs-header-search}.cpp

%build
mkdir build
cd build

%if %gccbootstrap == 0
CC=clang
CXX=clang++
export CC CXX
%endif

%define  _configure_script ../configure
%configure \
        --enable-cxx11 \
        --enable-optimized \
        --disable-assertions \
        --enable-targets=x86,x86_64,arm,aarch64,cpp,nvptx \
        --enable-experimental-targets=R600 \
        --enable-jit \
        --enable-shared \
        --enable-libffi \
	%{subst_enable doxygen} \
        --with-c-include-dirs=%_includedir:%_libdir/gcc/%_arch-%_vendor-%_os/%__gcc_version/include

# FIXME file this
# configure does not properly specify libdir
sed -i 's|(PROJ_prefix)/lib|(PROJ_prefix)/%_lib|g' Makefile.config
# llvm-config.cpp hardcodes lib in it
sed -i 's|ActiveLibDir = ActivePrefix + "/lib"|ActiveLibDir = ActivePrefix + "/%_lib"|g' ../tools/llvm-config/llvm-config.cpp

%make_build REQUIRES_RTTI=1 KEEP_SYMBOLS=1 OPTIMIZE_OPTION="%optflags" VERBOSE=1

%if_enabled doxygen
# hack to build docs during %%build, not %%install
for docdir in docs/ tools/clang/docs/; do
	sed -i "\,^doxygen: ,s,regendoc ,," $docdir/Makefile
	make VERBOSE=1 regendoc -C $docdir
	make VERBOSE=1 doxygen -C $docdir
done
%endif

%check
cd build
make check 2>&1 | tee llvm-testlog.txt

pushd tools/clang
make test 2>&1 | tee clang-testlog.txt
popd

%install
cd build

%makeinstall_std KEEP_SYMBOLS=1 VERBOSE=1 PROJ_docsdir=/moredocs

# Static analyzer not installed by default:
# http://clang-analyzer.llvm.org/installation#OtherPlatforms
mkdir -p %buildroot%_libdir/clang-analyzer
# create launchers
for f in scan-{build,view}; do
  ln -s %_libdir/clang-analyzer/$f/$f %buildroot%_bindir/$f
done

pushd ../tools/clang/tools
cp -pr scan-{build,view} %buildroot%_libdir/clang-analyzer/
popd

# Move documentation back to build directory
rm -rf moredocs
mv %buildroot/moredocs .
rm -f moredocs/*.tar.gz
rm -f moredocs/ocamldoc/html/*.tar.gz

# and separate the apidoc
%if_enabled doxygen
cp -al moredocs/html/doxygen apidoc
cp -al tools/clang/docs/doxygen/html clang-apidoc
%endif

# And prepare Clang documentation
rm -rf clang-docs
mkdir clang-docs
for f in LICENSE.TXT NOTES.txt README.txt; do
  ln ../tools/clang/$f clang-docs/
done
rm -rf ../tools/clang/docs/{doxygen*,Makefile*,*.graffle,tools}
subst 's|^\(DIRS.*\) docs\(.*\)|\1\2|' ../tools/clang/Makefile

# Get rid of erroneously installed example files.
rm -f %buildroot%_libdir/*LLVMHello.*
rm -f %buildroot%_libdir/*BugpointPasses.*

file %buildroot%_bindir/* | awk -F: '$2~/ELF/{print $1}' | xargs -r chrpath -d
file %buildroot%_libdir/*.so | awk -F: '$2~/ELF/{print $1}' | xargs -r chrpath -d

# remove documentation makefiles:
# they require the build directory to work
find examples -name 'Makefile' -delete

# need for build cmake projects
mkdir -p %buildroot%_datadir/CMake/Modules
install -p -m644 ../cmake/modules/*.cmake %buildroot%_datadir/CMake/Modules
ln -s LLVM-Config.cmake %buildroot%_datadir/CMake/Modules/LLVMConfig.cmake

%files
%doc CREDITS.TXT LICENSE.TXT README.txt build/llvm-testlog.txt
%_bindir/bugpoint
%_bindir/llc
%_bindir/lli
%exclude %_bindir/llvm-config
%_bindir/llvm*
%_bindir/opt
%_bindir/macho-dump
%_libdir/*.so
%exclude %_libdir/libclang.so
%_mandir/man1/*.1.*
%exclude %_mandir/man1/clang.1.*

%files devel
%_bindir/llvm-config
%_includedir/llvm
%_includedir/llvm-c
%_datadir/CMake/Modules

%files devel-static
%_libdir/*.a

%files -n clang
%doc build/clang-docs/* build/tools/clang/clang-testlog.txt
%_bindir/clang*
%_bindir/cpp11-migrate
%_bindir/c-index-test
%prefix/lib/clang
%_libdir/libclang.so
%_mandir/man1/clang.1.*

%files -n clang-devel
%_includedir/clang
%_includedir/clang-c

%files -n clang-analyzer
%_bindir/scan-build
%_bindir/scan-view
%_libdir/clang-analyzer

%if_with ocaml
%files ocaml
%_libdir/ocaml/*.cma
%_libdir/ocaml/*.cmi

%files ocaml-devel
%_libdir/ocaml/META.llvm
%_libdir/ocaml/*.a
%_libdir/ocaml/*.cmx*
%_libdir/ocaml/*.mli

%files ocaml-doc
%doc build/moredocs/ocamldoc/html/*
%endif

%if_enabled doxygen
%files -n clang-doc
%doc tools/clang/docs

%files doc
%doc examples build/moredocs/html

%files apidoc
%doc build/apidoc

%files -n clang-apidoc
%doc build/clang-apidoc
%endif

%changelog
