Name: logrotate
Version: 3.7.9
Release: alt3

Summary: Rotates, compresses, and mails system logs
License: GPLv2+
Group: File tools
Url: https://fedorahosted.org/logrotate/

# https://fedorahosted.org/releases/l/o/logrotate/%name-%version.tar.gz
Source: logrotate-%version.tar
Source1: logrotate.cron

Patch1: logrotate-3.7.9-alt-config.patch
Patch2: logrotate-3.7.9-alt-taboo.patch
Patch3: logrotate-3.7.9-alt-messages.patch
Patch4: logrotate-3.7.9-alt-open-fchmod-race.patch

Provides: /etc/logrotate.d

%def_with selinux

BuildRequires: libpopt-devel
%{?_with_selinux:BuildPreReq: libselinux-devel}

%description
The logrotate utility is designed to simplify the administration of log
files on a system which generates a lot of log files.  logrotate allows
for the automatic rotation, compression, removal and mailing of log files.
logrotate can be set to handle a log file daily, weekly, monthly or
when the log file gets to a certain size.  Normally, logrotate runs as
a daily cron job.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

%build
%make_build %{?_with_selinux:WITH_SELINUX=yes}

%install
%makeinstall_std \
	PREFIX=%buildroot \
	BINDIR=%_sbindir \
	MANDIR=%_mandir
mkdir -p %buildroot/etc/logrotate.d

install -pD -m640 examples/logrotate-default %buildroot/etc/logrotate.conf
install -pD -m755 %_sourcedir/logrotate.cron %buildroot/etc/cron.daily/logrotate
install -pD -m644 /dev/null %buildroot%_localstatedir/logrotate/status

%check
make test

%post
if [ ! -s %_localstatedir/logrotate/status -a -s %_localstatedir/logrotate.status ]; then
	mv -f %_localstatedir/logrotate.status %_localstatedir/logrotate/status
fi

%files
%_sbindir/*
%config(noreplace) /etc/cron.daily/logrotate
%config(noreplace) /etc/logrotate.conf
%_mandir/man?/*
%attr(750,root,root) %dir /etc/logrotate.d
%attr(700,root,root) %dir %_localstatedir/logrotate
%attr(644,root,root) %verify(not size md5 mtime) %config(noreplace) %_localstatedir/logrotate/status
%doc CHANGES

%changelog
