%def_disable static
%def_disable debug
%def_disable gtk_doc

Name: loudmouth
Version: 1.4.3
Release: alt4.1

Summary: Jabber library for C
Group: System/Libraries
License: LGPLv2.1+
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

# does't exists
#URL: http://www.loudmouth-project.org/
URL: https://launchpad.net/loudmouth
# or http://groups.google.com/group/loudmouth-dev/

Source: http://ftp.imendio.com/pub/imendio/%name/src/%name-%version.tar.bz2

Patch0: %name-1.4.3-gnutls-2.8.patch
Patch1: %name-1.4.3-alt-certs_location.patch

# Debian patches, from upstream 
# Fix sasl md5 digest-uri when using SRV lookups, which prevented 
# loudmouth from logging into recent versions of ejabberd 
Patch101: %name-1.4.3-fix-sasl-md5-digest-uri.patch
# Fix sync resolving, patch from upstream git. (fixes assertion 
# when trying to log in to some XMPP servers) 
Patch102: %name-1.4.3-async_assertion.patch
# Drop stanzas that can't be parsed instead of blocking the 
# parser. Patch from upstream bug tracker. 
Patch103: %name-1.4.3-drop-stanzas-on-fail.patch

Patch104: %name-1.4.3-alt-glib2.patch

BuildRequires: glib2-devel gtk-doc libcheck-devel libgnutls-devel libidn-devel

%description
Loudmouth is a lightweight and easy-to-use C library for programming
with the Jabber protocol. It is designed to be easy to get started with
and yet extensible to let you do anything the Jabber protocol allows.

%package -n lib%name
Summary: Jabber library for C
Group: System/Libraries

%description -n lib%name
Loudmouth is a lightweight and easy-to-use C library for programming
with the Jabber protocol. It is designed to be easy to get started with
and yet extensible to let you do anything the Jabber protocol allows.

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C
Requires: lib%name = %version-%release


%description -n lib%name-devel
This package contains files needed to develop applications using Loudmouth.
Loudmouth is a lightweight and easy-to-use C library for programming
with the Jabber protocol. It's designed to be easy to get started with
and yet extensible to let you do anything the Jabber protocol allows.

%package -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/C
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for Loudmouth.
Loudmouth is a lightweight and easy-to-use C library for programming
with the Jabber protocol. It's designed to be easy to get started with
and yet extensible to let you do anything the Jabber protocol allows.

%if_enabled static
%package -n lib%name-devel-static
Summary: Static library for %name
Group: Development/C
Requires: %name-devel = %version-%release

%description -n lib%name-devel-static
This package contains a statically-linked variant of Loudmouth.
Loudmouth is a lightweight and easy-to-use C library for programming
with the Jabber protocol. It's designed to be easy to get started with
and yet extensible to let you do anything the Jabber protocol allows.
%endif	# enabled static

%prep
%setup -q
%patch0 -p0
%patch1 -p1
%patch101 -p1
%patch102 -p1
%patch103 -p1
%patch104 -p2

%build
%autoreconf
%configure \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	--with-ssl=gnutls \
	--with-asyncns=yes \
	%{subst_enable debug} \
	%{subst_enable static}

%make_build

%check
%make check

%install
%make_install DESTDIR=%buildroot install

%files -n lib%name
%doc AUTHORS COPYING ChangeLog NEWS README
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_pkgconfigdir/*
%_includedir/*

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif # enabled static

%changelog
