%def_with jetpipe
%def_with ldminfod

%define rev 847

%define Codename ALTLinux

%define Name ALTSP
Name: ltsp
Version: 5.1.21
Release: alt0.14
Summary: %Name is ALT Linux blend of LTSP5 and LTSP4.2
License: %gpl2only
Group: Networking/Remote access
URL: http://www.altlinux.org/LTSP
%ifdef rev
# bzr branch http://bazaar.launchpad.net/~ltsp-upstream/ltsp/ltsp-trunk ltsp
# bzr update ltsp
Source0: %name-r%rev.tar
%else
Source0: %name-%version.tar
%endif
Source13: %name-rdp.sh
Source14: %name-rdpx.sh
Source15: lts-parameters.alt
Source21: ltsconf.tcl
Source22: conffile.tcl
#Patch0: %name-5.1.21-alt.patch
#Patch1: ltsp-5.1.21-alt-initscripts.patch
#Patch2: ltsp-5.1.21-alt-kserial.patch
#Patch3: ltsp-5.1.21-alt-typo.patch
#Patch4: ltsp-5.1.21-alt-compcache.patch
#Patch5: ltsp-5.1.21-alt-HOSTNAME.patch
#Patch6: ltsp-5.1.21-alt-fastboot.patch
#Patch7: ltsp-5.1.21-alt-tmpfs-options.patch
#Patch8: ltsp-5.1.21-alt-lbc.patch
#ExclusiveArch: %ix86 %arm
#ExclusiveOS: linux
Provides: %{name}5 = %version-%release
Obsoletes: %{name}5

# Automatically added by buildreq on Fri Mar 14 2008
BuildRequires: flex libX11-devel libpopt-devel

BuildRequires: gettext-tools
BuildRequires: rpm-build-licenses

%description
%url

%package server
Summary: %Name server
Group: Networking/Remote access
BuildArch: noarch
AutoReq: yes, noshell
Conflicts: %name-client %{name}5-client
Requires: /usr/bin/rpmvercmp
Requires: gettext
Requires: xmessage
Requires: setarch
Provides: %{name}5-server = %version-%release
Obsoletes: %{name}5-server

%description server
%Name server (to be installer onto the host system)


%package client
Summary: %Name client
Group: Networking/Remote access
Requires: service
Requires: mkinitrd-initramfs >= 3.0.4
Requires: e2fsprogs
Requires: mkinitrd
Provides: %_sysconfdir/%{name}_chroot
AutoReq: yes, noshell
Conflicts: %name-server %{name}5-server
Conflicts: alterator-backend-x11 < 0.13.1
Provides: %{name}5-client = %version-%release
Obsoletes: %{name}5-client


%description client
%Name client (to be installed into LTSP chroot)


%if_with jetpipe
%package -n jetpipe
Summary: Minimal print-server
Group: System/Servers
BuildArch: noarch

%description -n jetpipe
jetpipe will bind a printer device to a given portnumber so the printer
can be accessed through the JetDirect protocol from a remote client.
%endif


%if_with ldminfod
%package -n ldminfod
Summary: Service for output login sessions and available locales
Group: System/Servers
BuildArch: noarch

%description -n ldminfod
ldminfod is a service for output login sessions and available locales.
ldminfod will output the login sessions and locales available. It is
usually run from an inetd or xinetd instance. it is used by ldm to
remotely determine available login and locale settings.
%endif


%prep
%ifdef rev
%setup -n %name-r%rev
%else
%setup -n %name-%version
%endif
#patch0 -p1
#patch1 -p1
#patch2 -p1
#patch3 -p1
#patch4 -p1
#patch5 -p1
#patch6 -p1
#patch7 -p1
#patch8 -p1
iconv -f cp1251 -t utf-8 %SOURCE15 > client/lts-parameters.alt
%define make_alsa_conf [ -f %_datadir/alsa/alsa.conf ] && \
for n in null pulse xaudio; do \
    [ -f %_sysconfdir/%name/asound-$n.conf ] && \
    sed -e 's|"/etc/asound\.conf"|"%_sysconfdir/%name/asound-'$n'.conf"|g' \\\
	-e '/asoundrc/d' %_datadir/alsa/alsa.conf > %_datadir/%name/alsa-$n.conf ||: \
done ||:

%build
%{!?autoreconf:%define autoreconf autoreconf -fisv}
%define _optlevel s
%make_build -C client/getltscfg CFLAGS="%optflags"
%make_build -C po
pushd client/xrexecd
%autoreconf
%configure
%make_build
popd
for l in ru uk; do
    msgfmt -c -o server/configs/ALTLinux/po/ltsp-login.$l.{gm,p}o
done

sed -e 's|@LIBDIR@|%_libdir|g' \
    server/configs/%Codename/ltsp-profile.sh.in \
    > server/configs/%Codename/ltsp-profile.sh
sed -e 's/@ARCH@/%_target_cpu/g' server/configs/%Codename/dhcpd.conf.in \
    > server/configs/%Codename/dhcpd.conf
sed -e 's/@ARCH@/%_target_cpu/g' \
    server/configs/%Codename/%name-build-client.conf.in \
    > server/configs/%Codename/%name-build-client.conf
sed -e 's|@XORGEXTDIR@|%_libdir/X11/modules/extensions|g' client/initscripts/%Codename/ltsp-client.init.in > \
    client/initscripts/%Codename/ltsp-client.init


%install
# common
install -d -m 0755 %buildroot{%_sbindir,%_sysconfdir/{%name,sysconfig},%_x11sysconfdir,%_datadir/%name,%_man8dir}
install -m 0644 {client/initscripts/%Codename/%name-vendor,%name-common}-functions %buildroot%_datadir/%name/

# Server
install -d -m 0755 %buildroot{%_sysconfdir/{net,profile.d,xinetd.d},%_x11sysconfdir/profile.d,%_datadir/%name/{plugins/%name-build-client/{%Codename,common},scripts},%_localstatedir/{%name-client-setup,tftpboot/%name}}
for n in pulse null; do
    install -m 0644 /dev/null %buildroot%_datadir/%name/alsa-$n.conf
done
install -m 0755 server/configs/%Codename/%name-profile.sh %buildroot%_x11sysconfdir/profile.d/%name.sh
install -m 0644 server/configs/%Codename/dhcpd.conf %buildroot%_sysconfdir/%name/
install -m 0644 server/configs/%Codename/nbd-server.config %buildroot%_sysconfdir/%name/
install -m 0755 server/scripts/%Codename/mkswapfile %buildroot%_datadir/%name/scripts/
install -m 0755 server/%name-keys %buildroot%_sysconfdir/net/
install -m 0755 server/scripts/%Codename/%name-mkbootiso %buildroot%_sbindir/
install -m 0755 server/{%name-{keys,update-*},nbd*} %buildroot%_sbindir/
install -m 0644 server/xinetd.d/* %buildroot%_sysconfdir/xinetd.d/
install -m 0644 server/doc/{%name-,nbd}*.8 %buildroot%_man8dir/
install -m 0644 server/configs/%Codename/%name-update-kernels.conf %buildroot%_sysconfdir/%name/
install -m 0755 server/configs/%Codename/%name-login.sh %buildroot%_x11sysconfdir/profile.d/
echo "VENDORDEF=%Codename" > %buildroot%_sysconfdir/sysconfig/%{name}dist
for l in ru uk; do
    install -D -m 0644 server/configs/%Codename/po/%name-login.$l.gmo \
	%buildroot%_datadir/locale/$l/LC_MESSAGES/%name-login.mo
done
install -m 0644 server/configs/%Codename/asound-*.conf %buildroot%_sysconfdir/%name/
%make_install -C po DESTDIR=%buildroot install
install -m 0755 server/%name-build-client %buildroot%_sbindir/
install -m 0644 server/plugins/functions %buildroot%_datadir/%name/plugins/
install -m 0644 server/plugins/%name-build-client/common/* %buildroot%_datadir/%name/plugins/%name-build-client/common/
install -m 0644 server/plugins/%name-build-client/%Codename/* %buildroot%_datadir/%name/plugins/%name-build-client/%Codename/
install -m 0644 server/configs/%Codename/%name-build-client.conf %buildroot%_sysconfdir/%name/

%find_lang %name
%find_lang --append --output=%name.lang %name-login

# Client
%make_install -C client/xrexecd DESTDIR=%buildroot install
install -d -m 0755 %buildroot{%_bindir,%_initdir,%_datadir/%name/screen.d,%_man1dir,%_sysconfdir/{default,rc.d/scripts},%_var/cache/%{name}conf}
install -m 0755 client/{screen_session,update-kernels} %buildroot%_datadir/%name/
install -m 0644 client/screen-x-common %buildroot%_datadir/%name/
install -m 0755 client/initscripts/%Codename/start_* %buildroot%_datadir/%name/
install -m 0755 client/screen.d/{shell,xdmcp,telnet} %buildroot%_datadir/%name/screen.d/
ln -sf xdmcp %buildroot%_datadir/%name/screen.d/startx
install -m 0755 %SOURCE13 %buildroot%_datadir/%name/screen.d/rdp
install -m 0755 %SOURCE14 %buildroot%_datadir/%name/screen.d/rdpx
install -m 0644 client/%{name}_config %buildroot%_datadir/%name/
install -m 0644 client/initscripts/%Codename/%name-client-eth-modules.list %buildroot%_sysconfdir/%name/
install -m 0644 client/initscripts/%Codename/sysconfig-installkernel %buildroot%_sysconfdir/sysconfig/installkernel1
install -m 0755 client/getltscfg/getltscfg %buildroot%_bindir/
install -m 0644 client/getltscfg/getltscfg.1 %buildroot%_man1dir/
#install -m 0755 client/initramfs/init-bottom/unionfs_cow %buildroot%_datadir/%name/
install -m 0644 client/initscripts/%Codename/%name-client-setup.default %buildroot%_sysconfdir/default/%name-client-setup
install -m 0755 client/initscripts/%Codename/%name-client-bind-mounts.init %buildroot%_sysconfdir/rc.d/scripts/%name-client-bind-mounts
install -m 0755 client/initscripts/%Codename/%name-client.init %buildroot%_initdir/%name-client
install -m 0755 client/initscripts/%Codename/%name-client-setup.init %buildroot%_initdir/%name-client-setup
install -m 0755 client/initscripts/%Codename/%name-client-swap.init %buildroot%_initdir/%name-client-swap
install -m 0644 client/initscripts/%Codename/lts.conf.default %buildroot%_sysconfdir/lts.conf
install -m 0644 client/initscripts/%Codename/update-kernels.conf %buildroot%_sysconfdir/%name/
install -m 0644 client/initscripts/%Codename/%name.pa %buildroot%_sysconfdir/%name/
install -m 0755 %SOURCE21 %buildroot%_sbindir/ltsconf
install -m 0644 %SOURCE22 %buildroot%_datadir/%name/conffile.tcl
install -m 0755 client/initscripts/%Codename/%name-client-mkinitrd %buildroot%_datadir/%name/

# jetpipe
%if_with jetpipe
install -m 0755 client/jetpipe/jetpipe %buildroot%_sbindir/
install -m 0644 client/jetpipe/jetpipe.8 %buildroot%_man8dir/
%endif


# ldminfod
%if_with ldminfod
install -m 0755 server/ldminfod %buildroot%_sbindir/
install -m 0644 server/doc/ldminfod.8 %buildroot%_man8dir/
%endif


%post server
%make_alsa_conf


%post client
%post_service %name-client-setup
%post_service %name-client-swap
%post_service %name-client


%preun client
%preun_service %name-client
%preun_service %name-client-swap
%preun_service %name-client-setup


%triggerin server -- libalsa
%make_alsa_conf


%files server -f %name.lang
%doc server/doc/{examples,FAQ,plugins,workstation}
%doc server/doc/lts-parameters.* client/getltscfg/lts.conf
%_sbindir/%name-*
%_sbindir/nbd*
%_man8dir/%name-*
%_man8dir/nbd*
%dir %_datadir/%name
%_datadir/%name/plugins
%_datadir/%name/scripts
# the following file required for client and server
%_datadir/%name/%name-*-functions
%exclude %_datadir/%name/alsa-*.conf
%ghost %_datadir/%name/alsa-*.conf
%config(noreplace) %_sysconfdir/%name/dhcpd.conf
%config(noreplace) %_sysconfdir/%name/%name-update-kernels.conf
%config(noreplace) %_sysconfdir/%name/update-kernels.conf
%config(noreplace) %_sysconfdir/%name/%name-build-client.conf
%config(noreplace) %_sysconfdir/xinetd.d/*
%_sysconfdir/%name/asound-*.conf
%_sysconfdir/%name/nbd-server.config
%_sysconfdir/net/%name-keys
%_sysconfdir/sysconfig/%{name}dist
%dir %_localstatedir/tftpboot/%name
%_x11sysconfdir/profile.d/*


%files client
%_bindir/*
%_man1dir/*
%dir %_datadir/%name
%dir %_datadir/%name/screen.d
%_datadir/%name/screen.d/*
# the following file required for client and server
%_datadir/%name/%name-*-functions
%_datadir/%name/screen-x-common
%_datadir/%name/screen_session
%_datadir/%name/start_*
%_datadir/%name/%{name}_config
%_datadir/%name/update-kernels
%_datadir/%name/%name-client-mkinitrd
%_datadir/%name/conffile.tcl
%config(noreplace) %_sysconfdir/default/*
%config(noreplace) %_sysconfdir/lts.conf
%_initdir/%name-client*
%_sysconfdir/rc.d/scripts/*
%_sysconfdir/sysconfig/installkernel1
%dir %_var/cache/%{name}conf
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/%name.pa
%config(noreplace) %_sysconfdir/%name/%name-client-eth-modules.list
%_sbindir/ltsconf
%dir %_localstatedir/%name-client-setup


%if_with jetpipe
%files -n jetpipe
%_sbindir/jetpipe
%_man8dir/jetpipe.*
%endif


%if_with ldminfod
%files -n ldminfod
%_sbindir/ldminfod
%_man8dir/ldminfod.*
%endif


%changelog
