Name: lua5
Version: 5.1.4
Release: alt5

Summary: Embeddable programming language
License: MIT
Group: Development/Other

URL: http://www.lua.org
Source: lua-%version.tar
Patch: %name-%version-%release.patch

Requires: liblua5.1 = %version-%release
Provides: lua = %version
Conflicts: lua4

# Automatically added by buildreq on Mon Sep 28 2009
BuildRequires: libreadline-devel

%package -n liblua5.1
Summary: Embeddable programming language
Group: System/Libraries
Provides: %_libdir/lua5
Provides: %_datadir/lua5

%package -n liblua5-devel
Summary: Embeddable programming language
Group: Development/Other
Requires: liblua5.1 = %version-%release
Conflicts: liblua4-devel

%package -n liblua5-devel-static
Summary: Embeddable programming language
Group: Development/Other
Requires: liblua5-devel = %version-%release
Conflicts: liblua4-devel-static

%package doc
Summary: Embeddable programming language
Group: Development/Documentation
Conflicts: lua5 < 5.1.1-alt2
BuildArch: noarch

%description
Lua is a powerful, light-weight programming language designed for extending
applications.  The language engine is accessible as a library, having a C
API which allows the application to exchange data with Lua programs and also
to extend Lua with C functions.  Lua is also used as a general-purpose,
stand-alone language through the simple command line interpreter provided.

%description -n liblua5.1
Lua is a powerful, light-weight programming language designed for extending
applications.  The language engine is accessible as a library, having a C
API which allows the application to exchange data with Lua programs and also
to extend Lua with C functions.  Lua is also used as a general-purpose,
stand-alone language through the simple command line interpreter provided.

%description -n liblua5-devel
Lua is a powerful, light-weight programming language designed for extending
applications.  The language engine is accessible as a library, having a C
API which allows the application to exchange data with Lua programs and also
to extend Lua with C functions.  Lua is also used as a general-purpose,
stand-alone language through the simple command line interpreter provided.

%description -n liblua5-devel-static
Lua is a powerful, light-weight programming language designed for extending
applications.  The language engine is accessible as a library, having a C
API which allows the application to exchange data with Lua programs and also
to extend Lua with C functions.  Lua is also used as a general-purpose,
stand-alone language through the simple command line interpreter provided.

%description doc
Lua is a powerful, light-weight programming language designed for extending
applications.  The language engine is accessible as a library, having a C
API which allows the application to exchange data with Lua programs and also
to extend Lua with C functions.  Lua is also used as a general-purpose,
stand-alone language through the simple command line interpreter provided.

%prep
%setup -n lua-%version
%patch -p1

%build
%def_enable Werror

cd ./src
# from Makefile
core='lapi lcode ldebug ldo ldump lfunc lgc llex lmem lobject lopcodes lparser lstate lstring ltable ltm lundump lvm lzio'
lib='lauxlib lbaselib ldblib liolib lmathlib loslib ltablib lstrlib loadlib linit'

for f in $core $lib; do gcc %optflags -c $f.c; done
ar rcu liblua.a *.o
ranlib liblua.a

%define soffix -5.1.so.0
for f in $core $lib; do gcc %optflags %optflags_shared -c $f.c; done
gcc -shared -o liblua%soffix -Wl,-soname=liblua%soffix -Wl,--version-script=liblua.map -Wl,-z,defs *.o -lm -ldl

gcc -o lua %optflags lua.c ./liblua%soffix -lreadline
gcc -o luac %optflags luac.c print.c ./liblua%soffix

LD_LIBRARY_PATH=$PWD ./lua ../test/hello.lua 

%install
%define pkgdocdir %_docdir/lua-5.1
mkdir -p %buildroot{%_libdir,%_bindir,%_includedir,%_man1dir,%pkgdocdir/html}

cd ./src
cp -p liblua.a liblua%soffix %buildroot%_libdir/
ln -s liblua%soffix %buildroot%_libdir/liblua.so
cp -p lua %buildroot%_bindir/lua5.1
cp -p luac %buildroot%_bindir/luac5.1
ln -s lua5.1 %buildroot%_bindir/lua
ln -s luac5.1 %buildroot%_bindir/luac
cp -p lua.h luaconf.h lualib.h lauxlib.h ../etc/lua.hpp %buildroot%_includedir/
install -pD -m644 ../etc/lua.pc %buildroot%_pkgconfigdir/lua.pc

# Fix paths in lua.pc:
sed -i 's|/usr/lib|%_libdir|g;s|/usr/share|%_datadir|g' %buildroot%_pkgconfigdir/lua.pc

cd ..
cp -av COPYRIGHT HISTORY README etc test %buildroot%pkgdocdir/
cd ./doc
cp -p lua.1 %buildroot%_man1dir/lua5.1.1
cp -p luac.1 %buildroot%_man1dir/luac5.1.1
ln -s lua5.1.1 %buildroot%_man1dir/lua.1
ln -s luac5.1.1 %buildroot%_man1dir/luac.1
cp -p *.html *.css *.gif *.png %buildroot%pkgdocdir/html/
mv %buildroot%pkgdocdir/html/{readme,index}.html

mkdir -p %buildroot{%_libdir,%_datadir}/lua5

%files
%_bindir/lua*
%_man1dir/lua*

%files -n liblua5.1
%_libdir/liblua%soffix
%dir %_libdir/lua5
%dir %_datadir/lua5
%dir %pkgdocdir
%pkgdocdir/COPYRIGHT
%pkgdocdir/HISTORY
%pkgdocdir/README

%files -n liblua5-devel
%_includedir/*.*
%_libdir/liblua.so
%_pkgconfigdir/lua.pc

%files -n liblua5-devel-static
%_libdir/liblua.a

%files doc
%dir %pkgdocdir
%pkgdocdir/html
%pkgdocdir/etc
%pkgdocdir/test

%changelog
