%define lvm2version 2.02.98
%define dmversion 1.02.77

%def_disable cluster
%def_enable selinux
%def_enable lvmetad

Summary: Userland logical volume management tools
Name: lvm2
Version: %lvm2version
Release: alt1
License: GPL

Group: System/Base
Url: http://sources.redhat.com/lvm2
Source: %name-%version.tar

Source1: dmcontrol_update
Source3: lvm2-monitor.init
Source4: lvm2-lvmetad.init
Source5: blk-availability.init

Patch: %name-%version-%release.patch

Conflicts: liblvm

Requires: dmsetup  >= %{dmversion}-%{release}
Requires: dmeventd >= %{dmversion}-%{release}
Requires: liblvm2  = %{lvm2version}-%{release}

%define _sbindir /sbin
%def_enable static

BuildRequires: libreadline-devel, libtinfo-devel libudev-devel CUnit-devel
%{?_enable_static:BuildRequires: libreadline-devel-static libtinfo-devel-static}
%{?_enable_cluster:BuildRequires: libcman-devel libdlm-devel}
%{?_enable_selinux:BuildRequires: libselinux-devel}

%description
LVM2 includes all of the support for handling read/write operations
on physical volumes (hard disks, RAID-Systems, magneto optical, etc.,
multiple devices (MD), see mdadd(8) or even loop devices, see losetup(8)),
creating volume groups (kind of virtual disks) from one or more physical
volumes and creating one or more logical volumes (kind of logical
partitions) in volume groups.

%package static
Summary: Statically linked userland logical volume management tool
Group: System/Base
Requires: %name = %lvm2version-%release

%description static
This package contains statically linked LVM2 tool.

%package -n clvm
Summary: Cluster LVM daemon for LVM2
Group: System/Base
Requires: %name = %lvm2version-%release

%description -n clvm
Extensions to LVM2 to support clusters.

### liblvm* subpackages go here.

%package -n liblvm2
Summary: LVM2 shared libraries
License: LGPLv2
Group: System/Libraries
Requires: libdevmapper = %dmversion-%release
Requires: libdevmapper-event = %dmversion-%release

%description -n liblvm2
This package contains shred lvm2 libraries for applications.

%package -n liblvm2-devel
Summary: LVM2 development libraries and headers
Group: System/Libraries
License: LGPLv2
Requires: lvm2 = %lvm2version-%release
Requires: liblvm2 = %lvm2version-%release
Requires: libdevmapper-devel = %dmversion-%release

%description -n liblvm2-devel
This package contains files needed to develop applications that use
the lvm2 libraries.

### device-mapper subpackages go here.

%package -n libdevmapper
Version: %dmversion
Summary: Library of routines for device-mapper management
Group: System/Libraries

%package -n libdevmapper-devel
Version: %dmversion
Summary: Header file for libdevmapper
Group: System/Libraries
Requires: libdevmapper = %dmversion-%release

%package -n libdevmapper-devel-static
Version: %dmversion
Summary: Static version of libdevmapper
Group: System/Libraries
Requires: libdevmapper-devel = %dmversion-%release

%package -n dmsetup
Version: %dmversion
Summary: Utilities for low level logical volume management
Group: System/Kernel and hardware
Requires: libdevmapper = %dmversion-%release
Requires: udev >= 150-alt4

%package -n dmeventd
Version: %dmversion
Summary: Device-mapper event daemon
Group: System/Base
Requires: dmsetup = %dmversion-%release
Requires: libdevmapper-event = %dmversion-%release

%package -n libdevmapper-event
Summary: Device-mapper event daemon shared library
Version: %dmversion
License: LGPLv2
Group: System/Libraries
Requires: liblvm2  = %{lvm2version}-%{release}
Requires: libdevmapper = %dmversion-%release

%package -n libdevmapper-event-devel
Summary: Development libraries and headers for the device-mapper event daemon
Version: %dmversion
License: LGPLv2
Group: System/Libraries
Requires: libdevmapper-event = %dmversion-%release
Requires: libdevmapper-devel = %dmversion-%release

%description
This package contains the library and set of utilites for creating and
managing of device-mapper logical volumes.

%description -n libdevmapper
Library of routines for device-mapper management.

%description -n libdevmapper-devel
Header files for libdevmapper.

%description -n libdevmapper-devel-static
Static version of libdevmapper.

%description -n dmsetup
Utilities for low level logical volume management.

%description -n dmeventd
This package contains the dmeventd daemon for monitoring the state
of device-mapper devices.

%description -n libdevmapper-event
This package contains the device-mapper event daemon shared library,
libdevmapper-event.

%description -n libdevmapper-event-devel
This package contains files needed to develop applications that use
the device-mapper event library.

%prep
%setup

%patch -p1

%build
%autoreconf
export ac_cv_path_MODPROBE_CMD=/sbin/modprobe

%if_enabled static
%configure \
	--disable-readline \
	--disable-selinux \
	--disable-nls \
	--enable-lvm1_fallback \
	--enable-static_link \
	ac_cv_lib_dl_dlopen=no \
	--with-optimisation="%optflags -Os" \
	--with-group= \
	--with-staticdir=/sbin \
	--with-user= \
	--disable-pkgconfig \
	--with-device-uid=0 \
	--with-device-gid=6 \
	--with-device-mode=0660 \
	--with-dmeventd-path="/sbin/dmeventd"
	#
%__make libdm
%__make lib
%__make -C tools lvm.static
mv tools/lvm.static .
mv libdm/ioctl/libdevmapper.a .
%__make clean
%endif # static

# dynamic

%configure \
	%{subst_enable selinux} \
	%{subst_enable lvmetad} \
	--disable-static_link \
	--enable-lvm1_fallback \
	--enable-readline \
	--with-group= \
	--with-user= \
	--enable-pkgconfig \
	--with-device-uid=0 \
	--with-device-gid=6 \
	--with-device-mode=0660 \
	--enable-write_install \
%if_enabled cluster
	--with-clvmd=cman \
%endif
	--enable-applib \
	--enable-cmdlib \
	--with-usrlibdir=%_libdir \
	--enable-dmeventd \
	--with-udevdir=/lib/udev/rules.d \
	--enable-udev_sync \
	--with-dmeventd-path="/sbin/dmeventd" \
	--with-systemdsystemunitdir=%_unitdir \
	--with-tmpfilesdir=/lib/tmpfiles.d
	#
%__make

%install
%make_install install DESTDIR=%buildroot
chmod -R u+rwX %buildroot
%{?_enable_static:install -pm755 lvm.static %buildroot/sbin/}

mkdir -p %buildroot/%_lib
mkdir -p %buildroot/etc/lvm/{archive,backup}
mkdir -p %buildroot/var/lock/lvm
install -m700 /dev/null %buildroot/etc/lvm/.cache

### device-mapper part

install -pm755 %_sourcedir/dmcontrol_update %buildroot%_sbindir/

%{?_enable_static:install -pm755 libdevmapper.a %buildroot%_libdir/}

# Relocate shared library from %_libdir/ to /%_lib/.
for f in `ls %buildroot%_libdir/libdevmapper.so`; do
	t=`objdump -p "$f" |awk '/SONAME/ {print $2}'`
	[ -n "$t" ]
	ln -sf ../../%_lib/"$t" "$f"
done

mv %buildroot%_libdir/libdevmapper.so.1.00 %buildroot/%_lib/
mv %buildroot%_libdir/libdevmapper-event.so.1.00 %buildroot/%_lib/
mv %buildroot%_libdir/liblvm2app.so.2.2 %buildroot/%_lib/

pushd %buildroot%_libdir
rm -f libdevmapper-event.so liblvm2app.so
ln -sf ../../%_lib/libdevmapper-event.so.1.00 ./libdevmapper-event.so
ln -sf ../../%_lib/liblvm2app.so.2.2 ./liblvm2app.so
popd

# Fix pkgconfig file.
%__subst '/^Version:/ s/"\([^[:space:]]\+\)[^"]*"/\1/' %buildroot%_pkgconfigdir/*

# provide a symlink for devmapper.pc
ln -sf devmapper.pc %buildroot%_pkgconfigdir/libdevmapper.pc

### cluster stuff
%if_enabled cluster
install -pm755 scripts/lvmconf.sh %buildroot/sbin/lvmconf
%endif

### lvm2-monitor init script

mkdir -p %buildroot%_initdir
install -m 0755 %SOURCE3 %buildroot%_initdir/lvm2-monitor
install -m 0755 %SOURCE4 %buildroot%_initdir/lvm2-lvmetad
install -m 0755 %SOURCE5 %buildroot%_initdir/blk-availability

%make install_systemd_generators DESTDIR=%buildroot
%make install_systemd_units DESTDIR=%buildroot
%make install_tmpfiles_configuration DESTDIR=%buildroot

%post
%post_service lvm2-monitor
%if_enabled lvmetad
%post_service lvm2-lvmetad
%endif
%post_service blk-availability

%preun
%preun_service lvm2-monitor
%if_enabled lvmetad
%preun_service lvm2-lvmetad
%endif
%preun_service blk-availability

%files
%doc README WHATS_NEW udev/12-dm-permissions.rules
/sbin/*
%exclude /sbin/dmsetup
%exclude /sbin/dmcontrol_update
%if_enabled cluster
%exclude /sbin/lvmconf
%endif
%exclude /sbin/dmeventd
%{?_enable_static:%exclude /sbin/*.static}
%_mandir/man?/*
%exclude %_mandir/man8/dmsetup*
%if_enabled cluster
%exclude %_mandir/man8/clvm*
%endif
%config(noreplace) /etc/lvm/lvm.conf
%_initdir/lvm2-monitor
%_unitdir/lvm2-monitor.service
%_initdir/blk-availability
%_unitdir/blk-availability.service
%if_enabled lvmetad
%_initdir/lvm2-lvmetad
%_unitdir/lvm2-lvmetad.service
%_unitdir/lvm2-lvmetad.socket
/lib/udev/rules.d/69-dm-lvm-metad.rules
%endif
/lib/systemd/system-generators/lvm2-activation-generator
/lib/tmpfiles.d/%name.conf
%dir /etc/lvm/
%defattr(600,root,root,700)
/etc/lvm/backup/
/etc/lvm/archive/
/var/lock/lvm/
%ghost %verify(not md5 size mtime) %config(missingok,noreplace) /etc/lvm/.cache

%if_enabled static
%files static
/sbin/*.static
%endif # static

%if_enabled cluster
%files -n clvm
/usr/sbin/clvmd
#%_initdir/clvmd
%_man8dir/clvmd*
%_sbindir/lvmconf
%endif

%files -n liblvm2
/%_lib/liblvm2app.so.*
%_libdir/liblvm2cmd.so.*

%files -n liblvm2-devel
%_libdir/liblvm2app.so
%_libdir/liblvm2cmd.so

%_includedir/lvm2app.h
%_includedir/lvm2cmd.h
%_pkgconfigdir/lvm2app.pc

%files -n libdevmapper
/%_lib/libdevmapper.so.*

%files -n libdevmapper-devel
%_libdir/libdevmapper.so
%_includedir/libdevmapper.h
%_pkgconfigdir/*devmapper.*

%files -n libdevmapper-devel-static
%_libdir/libdevmapper.a

%files -n dmsetup
%doc WHATS_NEW_DM
%_man8dir/dmsetup*
%_sbindir/dmsetup
%_sbindir/dmcontrol_update
/lib/udev/rules.d/*
%if_enabled lvmetad
%exclude /lib/udev/rules.d/69-dm-lvm-metad.rules
%endif

%files -n dmeventd
%_sbindir/dmeventd
%_unitdir/dm-event.service
%_unitdir/dm-event.socket

%files -n libdevmapper-event
/%_lib/libdevmapper-event.so.*
%_libdir/libdevmapper-event-lvm2.so*
%_libdir/libdevmapper-event-lvm2mirror.so
%_libdir/libdevmapper-event-lvm2raid.so
%_libdir/libdevmapper-event-lvm2snapshot.so
%_libdir/device-mapper/libdevmapper-event-lvm2mirror.so*
%_libdir/device-mapper/libdevmapper-event-lvm2raid.so*
%_libdir/device-mapper/libdevmapper-event-lvm2snapshot.so*

%files -n libdevmapper-event-devel
%_libdir/libdevmapper-event.so
%_includedir/libdevmapper-event.h
%_pkgconfigdir/devmapper-event.pc

%changelog
