#
# lxc: linux Container library
#
# (C) Copyright IBM Corp. 2007, 2008
#
# Authors:
# Daniel Lezcano <dlezcano at fr.ibm.com>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# Spec file adapted for ALT Linux.

Name: lxc
Version: 0.9.0
Release: alt1.alpha3
Packager: Denis Pynkin <dans@altlinux.org>

URL: http://lxc.sourceforge.net
Source: http://dl.sourceforge.net/sourceforge/%name/%name-%{version}.tar
#Patch: %name-%version-%release.patch

Summary: %name : Linux Container
Group: System/Configuration/Other
License: LGPL
Requires: libcap gzip-utils
BuildRequires: libcap-devel docbook-utils glibc-kernheaders
BuildRequires: docbook2X xsltproc
#TODO  python3 libpython3 

# Needed to disable auto requirements from distro templates
%add_findreq_skiplist %_datadir/%name/templates/*

%description

The package "%name" provides the command lines to create and manage
containers.  It contains a full featured container with the isolation
/ virtualization of the pids, the ipc, the utsname, the mount points,
/proc, /sys, the network and it takes into account the control groups.
It is very light, flexible, and provides a set of tools around the
container like the monitoring with asynchronous events notification,
or the freeze of the container. This package is useful to create
Virtual Private Server, or to run isolated applications like bash or
sshd.

%package devel
Summary: development library for %name
Group: Development/Other

%description devel
The %name-devel package contains header files and library needed for
development of the linux containers.

%prep
%setup
#%patch -p1

%build
CFLAGS+=-I%_includedir/linux-default/include/
%autoreconf
%configure -disable-rpath \
    --localstatedir=%_var \
    --with-config-path=%_var/lib/lxc
#TODO    --enable-python
%make_build

%install
%make_install DESTDIR=%buildroot install
mkdir -p %buildroot%_localstatedir/%name
mkdir -p %buildroot%_cachedir/%name

#find %buildroot -type f -name '*.la' -exec rm -f {} ';'

#post

%files
%defattr(-,root,root)
%dir %_sysconfdir/%name
%_sysconfdir/%name/*
%_bindir/*
%_libdir/*.so.*
%dir %_libexecdir/%name
%attr(4711,root,root) %_libexecdir/%name/lxc-init
%dir %_libdir/%name
%dir %_libdir/%name/rootfs
%_libdir/%name/rootfs/*
%dir %_datadir/%name
%_datadir/%name/*
%_man1dir/*
%_man5dir/*
%_man7dir/*
%_docdir/%name/*
%dir %_localstatedir/%name
%dir %_cachedir/%name

%files devel
%defattr(-,root,root)
%dir %_includedir/%name
%_includedir/%name/*
%_libdir/pkgconfig/*
%_libdir/*.so

%changelog
