%define _unpackaged_files_terminate_build 1
%define theme_virt_dir lxde

%define theme_name upstream
#define theme_version 0.1

%define theme_fullname lxde-settings-%theme_name
%define gtkver 2
Name: lxde-common
Version: 0.99.1
Release: alt3
BuildArch: noarch

Summary: Basic infrastructure for LXDE.
License: %gpl2plus
Group: Graphical desktop/Other
Url: http://lxde.sf.net
#Url: git://git.lxde.org/lxde/lxde-common.git
BuildArch: noarch

Source: %name-%version.tar
Source1: lxde.wm
Source2: panel

AutoReq: yes,nosymlinks

Requires: lxde-settings
Requires: wm-common-freedesktop
# Automatically added by buildreq on Sat May 21 2016
# optimized out: perl perl-Encode perl-XML-Parser python-base python-modules xml-common xml-utils
BuildRequires: docbook-dtds xsltproc

BuildPreReq: rpm-build-licenses intltool libgtk+%gtkver-devel

%description
Pprovides infrastructure for LXDE components

%package -n %theme_fullname
#Version: theme_version
Summary: provides unmodified LXDE configuration from upstream
Group: Graphical desktop/Other
Provides: lxde-settings

### GRRRR!!! for appliance-desktop-lxde
Provides: lxde-default-theme

%description -n %theme_fullname
Default graphics theme for LXDE.

This package contains unmodified configuration from upstream.

%prep
%setup 

%build
sed -i 's,lxde.conf,LXDE.conf,' Makefile.am
sed -i 's,XDG_CONFIG_HOME/pcmanfm,XDG_CONFIG_HOME/pcmanfm/LXDE,;s,pcmanfm/LXDE.conf,pcmanfm/lxde.conf,;s,default/LXDE.conf,pcmanfm.conf,;' startlxde.in
sed -i '/XDG_MENU/ a\\n# Since shared-mime-info-0.90-alt3 XDG_DATA_DIRS not exported. We need to define\n# the set of base directories explicitly.\nexport XDG_DATA_DIRS="/usr/share/lxde:/usr/share:/usr/local/share"' startlxde.in

%autoreconf
%configure --enable-man

%make_build

%install
%makeinstall_std

install -m644 -D %SOURCE1 %buildroot%_x11sysconfdir/wmsession.d/09LXDE

mv %buildroot%_datadir/lxde %buildroot%_datadir/%theme_fullname
mkdir -p %buildroot%_datadir/%theme_fullname/pcmanfm
mv %buildroot%_sysconfdir/xdg/pcmanfm/LXDE/pcmanfm.conf %buildroot%_datadir/%theme_fullname/pcmanfm/lxde.conf
mv %buildroot%_sysconfdir/xdg/lxsession/LXDE/desktop.conf %buildroot%_datadir/%theme_fullname
mkdir -p %buildroot%_datadir/%theme_fullname/openbox
mv %buildroot%_sysconfdir/xdg/openbox/LXDE/* %buildroot%_datadir/%theme_fullname/openbox
rm -fR %buildroot%_sysconfdir/xdg/openbox/LXDE
mkdir -p %buildroot%_datadir/%theme_fullname/lxpanel
mv %buildroot%_sysconfdir/xdg/lxpanel/LXDE/* %buildroot%_datadir/%theme_fullname/lxpanel
rm -fR %buildroot%_sysconfdir/xdg/lxpanel/LXDE
ln -s %_datadir/%theme_virt_dir/desktop.conf %buildroot%_sysconfdir/xdg/lxsession/LXDE/desktop.conf
ln -s %_datadir/%theme_virt_dir/pcmanfm/lxde.conf %buildroot%_sysconfdir/xdg/pcmanfm/LXDE/pcmanfm.conf
ln -s %_datadir/%theme_virt_dir/pcmanfm/lxde.conf %buildroot%_sysconfdir/xdg/pcmanfm/LXDE/lxde.conf
ln -s %_datadir/%theme_virt_dir/lxpanel/ %buildroot%_sysconfdir/xdg/lxpanel/LXDE
ln -s %_datadir/%theme_virt_dir/openbox %buildroot%_sysconfdir/xdg/openbox/LXDE

mkdir -p %buildroot/etc/alternatives/packages.d/
cat > %buildroot/etc/alternatives/packages.d/%theme_fullname << __EOF__
%_datadir/%theme_virt_dir %_datadir/%theme_fullname 1
__EOF__

# Install desktop files
mkdir -p %buildroot%_desktopdir/
cp -v debian/*.desktop %buildroot%_desktopdir/

#Install panel config
install -m644 %SOURCE2 %buildroot%_datadir/%theme_fullname/lxpanel/panels/

%find_lang %name

%pre
if [ -d %_datadir/lxpanel/profile/LXDE ] && [ ! -L %_datadir/lxpanel/profile/LXDE ] ; then
 rm -fR %_datadir/lxpanel/profile/LXDE
fi

rm -fR %_sysconfdir/xdg/lxsession/LXDE/desktop.conf \
       %_sysconfdir/xdg/pcmanfm/LXDE \
       %_sysconfdir/xdg/lxpanel/LXDE \
       %_sysconfdir/xdg/openbox/LXDE    

%files -f %name.lang
%doc ChangeLog INSTALL README
%_bindir/*
%_x11sysconfdir/wmsession.d/*
%_sysconfdir/xdg/*
%dir %_datadir/xsessions
%_datadir/xsessions/*.desktop
%_man1dir/*

%_desktopdir/*.desktop

%files -n %theme_fullname
%_sysconfdir/alternatives/packages.d/%theme_fullname
%_datadir/%theme_fullname

#_iconsdir/nuoveXT2

%changelog
