%set_automake_version 1.11

%define upstreamname lxdm
%define theme_name Industrial

Name: lxde-%upstreamname
Version: 0.3.0
Release: alt3

Summary: Lightweight X11 Display Manager
License: GPL
Group: Graphical desktop/Other
Url: http://lxde.sf.net

Packager: LXDE Development Team <lxde@packages.altlinux.org>

Source: %upstreamname-%version.tar.gz
Patch3: lxdm-alt-session-name.patch
Patch4: lxdm-nonolisten.patch
Patch5: lxdm-buildfix_syswait.patch
Patch6: lxdm-0.4.1-old-plymouth.patch
Patch7: lxdm-alt-cpuhog.patch

Source1: alt.lxdm.pam
Source2: alt.lxdm.conf
Source3: alt.Xsession

# Automatically added by buildreq on Mon Jan 11 2010 (-bb)
BuildRequires: imake intltool libConsoleKit-devel libXmu-devel libgtk+2-devel libpam-devel xinitrc xorg-cf-files

%add_findreq_skiplist %_sbindir/%upstreamname

%description
LXDM is the future display manager of LXDE, the Lightweight X11 Desktop
environment. It is designed as a lightweight alternative to replace GDM or
KDM in LXDE distros. It's still in very early stage of development.

%prep
%setup -n %upstreamname-%version
%patch3 -p2
%patch4 -p2
%patch5 -p2
%patch6 -p1
%patch7 -p2

%build
autoreconf -fisv
%configure
touch -r po/Makefile po/stamp-it
%make_build

%install
%makeinstall_std
%find_lang %upstreamname

touch %{buildroot}%{_sysconfdir}/%{upstreamname}/xinitrc

mkdir -p %buildroot/%_altdir
cat > %buildroot/%_altdir/lxdm-theme-%theme_name << __EOF__
%_datadir/%upstreamname/themes/default %_datadir/%upstreamname/themes/%theme_name 10
__EOF__

mkdir -p %{buildroot}%{_sysconfdir}/pam.d
install -m644 %SOURCE1 %{buildroot}%{_sysconfdir}/pam.d/lxdm

install -m644 %SOURCE2 %{buildroot}%{_sysconfdir}/%{upstreamname}/lxdm.conf
install -m755 %SOURCE3 %{buildroot}%{_sysconfdir}/%{upstreamname}/Xsession

%files -f %upstreamname.lang
%doc ChangeLog INSTALL README
%_sysconfdir/%upstreamname
%config(noreplace) %_altdir/lxdm-theme-%theme_name
%config(noreplace) %_sysconfdir/pam.d/%upstreamname
%_sbindir/*
%_libexecdir/lxdm-greeter-gdk
%_libexecdir/lxdm-greeter-gtk
%_libexecdir/lxdm-numlock
%_datadir/%upstreamname

%changelog
