%define status rc3



Name: lyx
Version: 2.0.5.1
Release: alt1.1

Summary: LyX - a WYSIWYM word processor for the Desktop Environment.
License: GPL
Group: Publishing
Epoch: 2
Url: http://www.lyx.org

Packager: Alex Karpov <karpov@altlinux.ru>
Source: %name-%version.tar
Source1: %name.desktop
Source2: %{name}16.xpm
Source3: %{name}32.xpm
Source4: %{name}48.xpm
Source5: lyxcat

#Patch: lyx-qt4.3-from_ascii-lyx2lyx.alt.patch

BuildPreReq: desktop-file-utils kde-common-devel
BuildRequires: gcc-c++ imake libaspell-devel libSM-devel python-devel 
BuildRequires: libaiksaurus-devel boost-signals-devel boost-devel boost-filesystem-devel
BuildRequires: libqt4-devel >= 4.3

Requires: python >= 2.4 
Requires: texlive-latex-recommended

Provides: lyx-common lyx-qt lyx-latex-beamer
Obsoletes: lyx-common lyx-qt lyx-latex-beamer

%description
LyX is a modern approach to writing documents which breaks with the
obsolete "typewriter paradigm" of most other document preparation
systems.

It is designed for people who want professional quality output
with a minimum of time and effort, without becoming specialists in
typesetting.

The major innovation in LyX is WYSIWYM (What You See Is What You Mean).
That is, the author focuses on content, not on the details of
formatting.
This allows for greater productivity, and leaves the final typesetting
to the backends (like LaTeX) that are specifically designed
for the task.

With LyX, the author can concentrate on the contents of his writing,
and let the computer take care of the rest.

%package -n lyx-tex
Summary: Virtual package that install required set of tex packages for LyX.
Group: Publishing
Requires: lyx
Requires: texlive-latex-recommended texlive-extra texlive-lang-cyrillic texlive-fonts-recommended fonts-ttf-latex-xft 
BuildArch: noarch

%description -n lyx-tex
Virtual package that install required set of tex packages for LyX.

%prep
%setup -qn %name-%version

%build
%configure --without-included-boost
%make_build

%install
%make_install DESTDIR=%buildroot install
%find_lang %name

install -d -m 755 %buildroot%_desktopdir
install -m 644 %SOURCE1 %buildroot%_desktopdir/
install -d -m 755 %buildroot%_miconsdir
install -d -m 755 %buildroot%_niconsdir
install -d -m 755 %buildroot%_liconsdir
install -m 644 %SOURCE2 %buildroot%_miconsdir/%name.xpm
install -m 644 %SOURCE3 %buildroot%_niconsdir/%name.xpm
install -m 644 %SOURCE4 %buildroot%_liconsdir/%name.xpm
install -m 755 %SOURCE5 %buildroot%_bindir/

#
# Set up the lyx-specific class files where TeX can see then
#
TEXMF=%_datadir/texmf
mkdir -p %buildroot$TEXMF/tex/latex
cp -ar %buildroot%_datadir/%name/tex %buildroot$TEXMF/tex/latex/%name
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Office:WordProcessor:KDE:Qt \
	--add-category=Office \
	--add-category=WordProcessor \
	--add-category=KDE \
	--add-category=Qt \
	%buildroot%_desktopdir/lyx.desktop

%post
# configure Lyx in new way
cd %_datadir/%name
python configure.py

%files -f %name.lang
%doc ANNOUNCE COPYING INSTALL* README* NEWS UPGRADING RELEASE-NOTES ABOUT-NLS
%_bindir/*
%_man1dir/*
%_datadir/%name
%_datadir/texmf/tex/latex/lyx
%_miconsdir/*
%_niconsdir/*
%_liconsdir/*
%_desktopdir/*.desktop

%files -n lyx-tex

%changelog
