#%%define %_libexecdir %_sbindir
%define snapshot 1

Name: mailfromd

%define baseversion 7.99.94

%if %snapshot
%define snapshotdate 20151112
Version: %baseversion
Release: alt0.%snapshotdate.0.M70P.2
%define srcdir %name-%baseversion-%snapshotdate
%else
Version: %baseversion
Release: alt1
%define srcdir %name-%version
%endif

Packager: Sergey Y. Afonin <asy@altlinux.ru>

Summary: Universal flexible smtp data supervisor for Sendmail, MeTA1 and Postfix

License: %gpl3plus
Group: System/Servers
Requires: makemap m4

Url: http://puszcza.gnu.org.ua/projects/mailfromd/
%if %snapshot
Source0:        %name-%baseversion-%snapshotdate.tar.bz2
%else
Source0:        %name-%version.tar.bz2
%endif

Source10: mailfromd.init
Source11: mailfromd.sysconfig
Source12: mailfromd-Makefile
Source13: mailfromd-cron

Source20: mailfromd.mf
Source21: mailfromd-localconf.mf
Source22: mailfromd-userfunctions.mf
Source23: mailfromd.conf

Source30: mailfromd-whitelist.main
Source31: mailfromd-sendmail.wl
Source32: mailfromd-shared.wl

Source50: mailfromd-clamav_only.mf

# "not_found" placed to the cache when the MX is not responding
# too. SMTP reply 5xx must not be returned at this case. This
# behavior discovered in 7.99.92 (git 2012-03-21).
# This patch is attempt to disable caching mf_timeout status.
Patch1: mailfromd-savsrv.c-not_cache_mf_timeout.diff

#Errata
#Patch100:

BuildRequires(pre): rpm-build-licenses

# Automatically added by buildreq on Mon Oct 07 2013
# optimized out: emacs-X11 emacs-base emacs-cedet-speedbar emacs-common fontconfig libX11-locales libgdk-pixbuf libgpg-error libp11-kit libtinfo-devel mailutils pkg-config
BuildRequires: emacs-X11 flex libdb4-devel libdspam-devel libgcrypt-devel libgdbm-devel libgnutls-devel libldap-devel libncurses-devel libpam-devel libreadline-devel libtokyocabinet-devel

BuildRequires: libmailutils-devel >= 2.99.99
BuildRequires: mailutils
BuildRequires: makeinfo

%description
Milter-filter for Sendmail v8, MeTA1 and Postfix (since 2.3; please
look documentation of Postfix for checking some limitations).

It provide many verifications at different stages of reception of the
messages, including smtp callback checking, gray listing, regexp checking,
ClamAV and SpamAssassin lookup and other. Nominally it is replacement for
verify_sender, milter-regex, clamav-milter, milter-greylist ang other.

%package cfg_full
Summary: Full featured configuration of mailfromd.
Copyright: %gpl3plus
Requires: %name = %version-%release
Provides: %name-config
Group: System/Servers
BuildArch: noarch

%description cfg_full
Full featured configuration of mailfromd (can be used with Sendmail since 8.14)

%package cfg_clamav
Summary: clamav-milter replacement configuration.
Copyright: %gpl3plus
Requires: %name = %version-%release
Provides: %name-config
Group: System/Servers
BuildArch: noarch

%description cfg_clamav
clamav-milter replacement configuration.

%package doc
Summary: Documentation for mailfromd.
Copyright: %fdl
Group: Development/Documentation
BuildArch: noarch

%description doc
Documentation for mailfromd.

%package mfl
Summary: GNU Emacs MFL extention for mailfromd.
Copyright: %gpl3plus
Requires: emacs-base
Group: System/Servers
BuildArch: noarch

%description mfl
MFL sources are usual ASCII files and you may edit them with any editor
you like.  However, the best choice for this job (as well as for many
others) is, without doubt, GNU Emacs.  To ease the work of editing
script files, the `mailfromd' package provides a special Emacs mode,
called "MFL mode".

%package locales
Summary: National Language files for mailfromd
Copyright: %gpl3plus
Group: System/Servers
BuildArch: noarch

%description locales
National Language files for mailfromd (Polish and Ukrainian)

%prep

%setup -q -n %srcdir

%patch1 -p1

#Errata
#patch100 -p1

gzip ChangeLog

%build

#autoreconf
#undefine __libtoolize
#libtoolize --ltdl --copy --force

LIBS="-lresolv" \
%configure \
    --sysconfdir=%_sysconfdir/mailfromd \
    --with-berkeley-db \
    --enable-ipv6 \
#   --enable-syslog-async \
    #

# NO SMP BUILD
%make V=1

%check

%make check

%install

make install DESTDIR=%buildroot
install -d $RPM_BUILD_ROOT%_localstatedir/mailfromd

install -d $RPM_BUILD_ROOT%{_sysconfdir}/{rc.d/init.d,sysconfig,cron.daily}
install -d $RPM_BUILD_ROOT%{_sysconfdir}/mailfromd/{config.d,config.d.shared}

touch $RPM_BUILD_ROOT%_sysconfdir/mailfromd/whitelist
touch $RPM_BUILD_ROOT%_sysconfdir/mailfromd/whitelist.db

sed -e 's|@@CFG_NAME@@|mailfromd|g' < %SOURCE10 > $RPM_BUILD_ROOT%_initdir/mailfromd
chmod 755 $RPM_BUILD_ROOT%_initdir/mailfromd
sed -e 's|@@CFG_NAME@@|mailfromd|g' < %SOURCE11 > $RPM_BUILD_ROOT%_sysconfdir/sysconfig/mailfromd
sed -e 's|@@CFG_NAME@@|mailfromd|g' < %SOURCE13 > $RPM_BUILD_ROOT%_sysconfdir/cron.daily/mailfromd
chmod 744 $RPM_BUILD_ROOT%_sysconfdir/cron.daily/mailfromd

cp -f %SOURCE12 $RPM_BUILD_ROOT%_sysconfdir/mailfromd/Makefile

cp -f %SOURCE20 $RPM_BUILD_ROOT%_sysconfdir/mailfromd/mailfromd.mf
cp -f %SOURCE21 $RPM_BUILD_ROOT%_sysconfdir/mailfromd/localconf.mf
cp -f %SOURCE22 $RPM_BUILD_ROOT%_sysconfdir/mailfromd/userfunctions.mf
cp -f %SOURCE23 $RPM_BUILD_ROOT%_sysconfdir/mailfromd/mailfromd.conf

#rm $RPM_BUILD_ROOT%_libexecdir/mailfromd/postfix-macros.sed
#cp etc/postfix-macros.sed $RPM_BUILD_ROOT%_datadir/mailfromd/postfix-macros.sed

install -m644 %SOURCE30 $RPM_BUILD_ROOT%_sysconfdir/mailfromd/whitelist.main
install -m644 %SOURCE31 $RPM_BUILD_ROOT%_sysconfdir/mailfromd/config.d/sendmail.wl
install -m644 %SOURCE32 $RPM_BUILD_ROOT%_sysconfdir/mailfromd/config.d.shared/shared.wl

%find_lang mailfromd

#
# cfg_clamav
#
install -d $RPM_BUILD_ROOT%_localstatedir/mailfromd-clamav

pushd $RPM_BUILD_ROOT%_sbindir
    ln -s mailfromd mailfromd-clamav
popd

sed -e 's|@@CFG_NAME@@|mailfromd-clamav|g' < %SOURCE10 > $RPM_BUILD_ROOT%_initdir/mailfromd-clamav
chmod 755 $RPM_BUILD_ROOT%_initdir/mailfromd-clamav
sed -e 's|@@CFG_NAME@@|mailfromd-clamav|g' < %SOURCE11 > $RPM_BUILD_ROOT%_sysconfdir/sysconfig/mailfromd-clamav
sed -e 's|@@CFG_NAME@@|mailfromd-clamav|g' < %SOURCE13 > $RPM_BUILD_ROOT%_sysconfdir/cron.daily/mailfromd-clamav
chmod 744 $RPM_BUILD_ROOT%_sysconfdir/cron.daily/mailfromd-clamav

cp -f %SOURCE50 $RPM_BUILD_ROOT%_sysconfdir/mailfromd/mailfromd-clamav.mf

%post

%preun

%post cfg_full
{
    pushd %_sysconfdir/mailfromd
    make
    popd

} &>/dev/null ||:
%post_service mailfromd
rm -f %_localstatedir/mailfromd/*.db &>/dev/null ||:

%preun cfg_full
%preun_service mailfromd

%post cfg_clamav
{
    pushd %_sysconfdir/mailfromd
    make
    popd

} &>/dev/null ||:
%post_service mailfromd-clamav
rm -f %_localstatedir/mailfromd-clamav/*.db &>/dev/null ||:

%preun cfg_clamav
%preun_service mailfromd-clamav

%files
%dir %_sysconfdir/mailfromd
%dir %_sysconfdir/mailfromd/config.d
%dir %_sysconfdir/mailfromd/config.d.shared

%config(noreplace) %_sysconfdir/mailfromd/localconf.mf
%config(noreplace) %_sysconfdir/mailfromd/userfunctions.mf
%config(noreplace) %_sysconfdir/mailfromd/Makefile
%config(noreplace) %_sysconfdir/mailfromd/mailfromd.conf

%config(noreplace) %_sysconfdir/mailfromd/whitelist.main
%config %_sysconfdir/mailfromd/config.d/sendmail.wl
%config(noreplace) %_sysconfdir/mailfromd/config.d.shared/shared.wl

%ghost %_sysconfdir/mailfromd/whitelist
%ghost %_sysconfdir/mailfromd/whitelist.db

%_sbindir/mailfromd
%_sbindir/calloutd
%_bindir/mtasim
%_bindir/mfdbtool

%dir %_datadir/mailfromd
%dir %_datadir/mailfromd/%baseversion
%dir %_datadir/mailfromd/%baseversion/include
%_datadir/mailfromd/%baseversion/include/*
%_datadir/mailfromd/postfix-macros.sed

%attr(3775,root,mail) %dir %_localstatedir/mailfromd

%files cfg_full
%attr(0755,root,root) %_initdir/mailfromd

%config(noreplace) %_sysconfdir/mailfromd/mailfromd.mf
%config(noreplace) %_sysconfdir/sysconfig/mailfromd
%config %_sysconfdir/cron.daily/mailfromd

%attr(3775,root,mail) %dir %_localstatedir/mailfromd

%files cfg_clamav
%_sbindir/mailfromd-clamav
%attr(0755,root,root) %_initdir/mailfromd-clamav

%config(noreplace) %_sysconfdir/mailfromd/mailfromd-clamav.mf
%config(noreplace) %_sysconfdir/sysconfig/mailfromd-clamav
%config %_sysconfdir/cron.daily/mailfromd-clamav

%attr(3775,root,mail) %dir %_localstatedir/mailfromd-clamav

%files doc
%doc COPYING README AUTHORS INSTALL NEWS THANKS ChangeLog.gz
%_infodir/*

%files mfl
%_datadir/emacs/site-lisp/*

%files locales -f mailfromd.lang

%changelog
