# Need to fix
# Bugs:
#	815297 Breaking signatures in message/rfc822 attachement!
Name: mailman
Version: 2.1.12
Release: alt2.1.1
Epoch: 5
Packager: Grigory Batalov <bga@altlinux.ru>

%define mm_user %name
%define mm_group %name

%define contentdir /var/www
%define httpdconfdir %_sysconfdir/httpd/conf/addon-modules.d
%define crontabdir %_sysconfdir/cron.d
%define logrotate %_sysconfdir/logrotate.d

%define _prefix /usr/share/%name
%define _exec_prefix %_libdir/%name
%define _var_prefix %_localstatedir/%name

Summary: Mailing list manager with built in web access
License: GPL
Group: System/Servers
Url: http://www.list.org/

# http://prdownloads.sourceforge.net/%name/%name-%version.tar.tgz
Source: %name-%version.tar
# ALT Linux cummulative patch
Patch:  %name-%version-%release-alt.patch


PreReq: mktemp, setup, shadow-utils, sendmail-common, vixie-cron
Requires: webserver, python
BuildRequires: python-devel

BuildRequires(pre): python
AutoProv: yes, nopython

%add_python_req_skip Defaults Mailman mm_config
%define _python_compile_include %_datadir/%name

%description
Mailman, the GNU Mailing List Management System, is a mailing list
management system written mostly in Python. Features:
- Web based list administration for nearly all tasks.  Web based            
  subscriptions and user configuration management.  A customizable          
  "home page" for each mailing list.                                        
- Privacy features such as moderation, open and closed list                 
  subscription policies, private membership rosters, and                    
  sender-based filters.                                                     
- Automatic web based archiving built-in with support for private           
  and public archives, and hooks for external archivers.                    
- Per-user configuration optional digest delivery for either                
  MIME-compliant or RFC 1153 style "plain text" digests.                    
- Integrated mail/Usenet gateways.                                          
- Integrated auto-replies.                                                  
- Majordomo-style email based commands.                                     
- Integrated bounce detection within an extensible framework.               
- Integrated spam detection, and MIME-based content filtering.              
- An extensible mail delivery pipeline.                                     
- Support for virtual domains.                                              

See the Mailman home site for current status, including new releases
and known problems: %url

%package docs
Group: System/Servers
Summary: Mailing list manager with built in web access


%description docs
Documentation for mailman

%prep
%setup -q
# ALT Linux cummulative patch
%patch -p1

%__install -pD -m644 alt-linux/mm_cfg.py Mailman/mm_cfg.py.dist.in
%__install -pD -m644 alt-linux/README.ALT README.ALT

sed -i -e 's,@LOCKFILE@,%_lockdir/%name/master-qrunner,g' cron/crontab.in.in

# Debian patches
# see http://packages.qa.debian.org/m/mailman.html
for patch in \
07_snooze.patch \
15_mailmanctl_daemonize.patch \
16_update_debian.patch \
20_qmail_to_mailman.debian.patch \
30_pipermail_threads.patch \
52_check_perms_lstat.patch \
53_disable_addons.patch \
59_fix_missing_language_crash.patch \
63_update_default_server_language.patch \
64_correct_html_nesting.patch \
65_handle_templates_directories.patch \
66_donot_let_cache_html_pages.patch \
70_invalid_utf8_dos.patch \
71_date_overflows.patch \
74_admin_non-ascii_emails.patch \
77_header_folding_in_attachments.patch \
79_archiver_slash.patch \
99_js_templates.patch
do
	echo "Patch ($patch):"
	%__patch -s -p1 < debian/patches/$patch
done

touch src/*.c

%build
autoreconf -fisv
%configure \
	--with-var-prefix=%_var_prefix \
	--with-config-dir=%_sysconfdir/%name \
	--with-lock-dir=%_lockdir/%name \
	--with-log-dir=%_logdir/%name \
	--with-pid-dir=%_var/run/%name \
	--with-queue-dir=%_spooldir/%name \
	--with-python=%__python \
	--with-mail-groupfile=%_sysconfdir/%name/mail.groups \
	--with-cgi-groupfile=%_sysconfdir/%name/cgi.groups \
	--with-mailhost=localhost.localdomain \
	--with-urlhost=localhost.localdomain \
	--without-permcheck

# rebuild mailman.pot
%make -C messages potfile

%make_build OPT="$RPM_OPT_FLAGS"

%install
find bin -type f -print0 |
	xargs -r0 %__grep -Zl '%__python$' |
	xargs -r0 %__subst 's|%__python$|%__python -O|g'

%make_install doinstall \
	DESTDIR=$RPM_BUILD_ROOT \
	prefix=%prefix \
	exec_prefix=%_exec_prefix \
	var_prefix=%_var_prefix

chmod -R go-w $RPM_BUILD_ROOT{%prefix,%_exec_prefix}
find $RPM_BUILD_ROOT{%prefix,%_exec_prefix} -type d -print0 |
	xargs -r0 chmod a-s,o-r
chmod a-s,go-r $RPM_BUILD_ROOT%_var_prefix

# Create directories we'll use for log and spool files. Create links
%__install -d -m2771 $RPM_BUILD_ROOT%_logdir/%name
%__install -d -m2770 $RPM_BUILD_ROOT%_spooldir/%name
%__install -d -m2771 $RPM_BUILD_ROOT%_spooldir/%name/{archive,bounces,commands,in,news,out,qfiles,retry,shunt,virgin}

ln -s ../../log/%name $RPM_BUILD_ROOT%_var_prefix/logs
ln -s ../../spool/%name $RPM_BUILD_ROOT%_var_prefix/qfiles

# Copy an icons into the web server's icons directory.
%__mkdir_p $RPM_BUILD_ROOT%contentdir
%__mv $RPM_BUILD_ROOT%prefix/icons $RPM_BUILD_ROOT%contentdir/

# Install a logrotate control file.
%__install -pD -m644 alt-linux/%name.logrotate \
	$RPM_BUILD_ROOT%logrotate/%name

# Install the httpd configuration file.
%__install -pD -m644 /dev/null $RPM_BUILD_ROOT%httpdconfdir/%name.conf
%__sed -e 's|@CODEDIR@|%_exec_prefix|g;s|@DATADIR@|%_var_prefix|g' \
	alt-linux/%name-httpd.conf > $RPM_BUILD_ROOT%httpdconfdir/%name.conf

# Install crontab file
install -pD -m644 cron/crontab.in $RPM_BUILD_ROOT%crontabdir/%name

# Install init script
install -pD -m755 misc/mailman $RPM_BUILD_ROOT%_initdir/%name

# Install config files for postfix
%__install -pD -m644 alt-linux/mm_config.py $RPM_BUILD_ROOT%_sysconfdir/%name/mm_config.py
%__install -pD -m644 /dev/null $RPM_BUILD_ROOT%_sysconfdir/%name/aliases
%__install -pD -m644 /dev/null $RPM_BUILD_ROOT%_sysconfdir/%name/virtual-mailman
%__install -pD -m644 /dev/null $RPM_BUILD_ROOT%_sysconfdir/%name/aliases.db
%__install -pD -m644 /dev/null $RPM_BUILD_ROOT%_sysconfdir/%name/virtual-mailman.db
install -pD -m644 /dev/null $RPM_BUILD_ROOT%_sysconfdir/%name/aliases.cdb
install -pD -m644 /dev/null $RPM_BUILD_ROOT%_sysconfdir/%name/virtual-mailman.cdb

cat <<EOF > $RPM_BUILD_ROOT%_sysconfdir/%name/mail.groups
mail
postman
%mm_group
EOF

cat <<EOF > $RPM_BUILD_ROOT%_sysconfdir/%name/cgi.groups
apache
EOF

# Install man pages
install -m755 -pd $RPM_BUILD_ROOT%_man8dir
install -m644 debian/manpages/*.8 $RPM_BUILD_ROOT%_man8dir/

# Install lockdir and piddir
install -m755 -pd $RPM_BUILD_ROOT%_lockdir/%name
install -m755 -pd $RPM_BUILD_ROOT%_var/run/%name

# Remove unused files
%__rm -f $RPM_BUILD_ROOT%_sysconfdir/%name/sitelist.cfg
%__rm -rf $RPM_BUILD_ROOT%_datadir/%name/tests

%pre
/usr/sbin/groupadd -rf %mm_group ||:
/usr/sbin/useradd -M -r -s /dev/null -c "GNU Mailing List Manager" \
	-d %_var_prefix -g %mm_group %mm_user &>/dev/null ||:

%post
%post_service mailman
# Fix file premissions
if [ -f %_localstatedir/%name/data/last_mailman_version ]; then
	chown %mm_user:%mm_group %_localstatedir/%name/data/last_mailman_version ||:
	chmod 644 %_localstatedir/%name/data/last_mailman_version ||:
	echo "Update mailman's database:"
	%_prefix/bin/update ||:
else
	%_prefix/bin/update &> /dev/null ||:
fi

%preun
%preun_service mailman

%triggerin -- postfix
# Generate aliases
%_prefix/bin/genaliases

%triggerun -- mailman < 5:2.1.9-alt2
if [ $1 != 0 ]; then
# Move old configs and passwords and change group
	for file in aliases virtual-mailman mm_config.py; do
		if [ -f %_localstatedir/%name/etc/$file ]; then
			mv %_localstatedir/%name/etc/$file %_sysconfdir/%name/$file ||:
			chgrp %mm_group %_sysconfdir/%name/$file ||:
		fi
	done
	for file in adm.pw creator.pw; do
		if [ -f %_localstatedir/%name/data/$file ]; then
			mv %_localstatedir/%name/data/$file %_sysconfdir/%name/$file ||:
			chgrp %mm_group %_sysconfdir/%name/$file ||:
		fi
	done
# Change paths in Postfix config
	if [ -f %_sysconfdir/postfix/main.cf ]; then
		sed  -i -e 's,%_localstatedir/%name/etc/aliases,%_sysconfdir/%name/aliases,g' \
			-e 's,%_localstatedir/%name/etc/virtual-mailman,%_sysconfdir/%name/virtual-mailman,g' \
			%_sysconfdir/postfix/main.cf ||:
	fi
# Move lockfiles and pidfile
	for file in %_localstatedir/%name/locks/*; do
		[ -f $file ] && mv $file %_lockdir/%name/ ||:
	done
	[ -f %_localstatedir/%name/data/master-qrunner.pid ] && \
		mv -f %_localstatedir/%name/data/master-qrunner.pid %_var/run/%name/ ||:
fi
# Restart mailman again with configs at the new place
%post_service mailman


%files
%config(noreplace) %logrotate/%name
%config(noreplace) %httpdconfdir/%name.conf
%config(noreplace) %crontabdir/%name
%attr(0755,root,root) %_initdir/%name
%contentdir/icons/*
%dir %prefix
%prefix/bin
%prefix/cron
%prefix/Mailman
%prefix/messages
%prefix/pythonlib
%prefix/scripts
%prefix/templates
%doc ACKNOWLEDGMENTS BUGS FAQ INSTALL NEWS README* STYLEGUIDE.txt TODO UPGRADING
%doc misc/sitelist.cfg tests
%doc %_man8dir/*
%dir %attr(0770,root,%mm_group) %_lockdir/%name
%dir %attr(0770,root,%mm_group) %_var/run/%name

%defattr(-,root,%mm_group,-)
%_exec_prefix
%dir %attr(0751,root,%mm_group) %_var_prefix
%dir %_var_prefix/archives
%dir %_var_prefix/archives/*
%dir %_var_prefix/spam
%dir %_var_prefix/lists
%dir %_var_prefix/data
%dir %attr(2771,root,%mm_group) %_sysconfdir/%name
%config(noreplace) %attr(0664,root,%mm_group) %_sysconfdir/%name/mm_config.*
%config(noreplace) %attr(0664,root,%mm_group) %_sysconfdir/%name/aliases
%config(noreplace) %attr(0664,root,%mm_group) %_sysconfdir/%name/virtual-mailman
%config(noreplace) %attr(0664,root,%mm_group) %_sysconfdir/%name/mail.groups
%config(noreplace) %attr(0664,root,%mm_group) %_sysconfdir/%name/cgi.groups
%ghost %_sysconfdir/%name/aliases.db
%ghost %_sysconfdir/%name/virtual-mailman.db
%ghost %_sysconfdir/%name/aliases.cdb
%ghost %_sysconfdir/%name/virtual-mailman.cdb
%_var_prefix/logs
%_var_prefix/qfiles
%_logdir/%name
%dir %_spooldir/%name
%dir %_spooldir/%name/*

%files docs
%doc doc


%changelog
