# see http://lists.altlinux.org/pipermail/devel/2012-February/193243.html
%def_disable python

# see http://bugzilla.altlinux.org/31466
%def_enable guile

%define snapshot 1

Name: mailutils

%define baseversion 2.99.99

%if %snapshot
%define snapshotdate 20151110
Version: %baseversion
Release: alt0.%snapshotdate.0.M70P.1
%define srcdir %name-%snapshotdate
%else
Version: %baseversion
Release: alt1
%define srcdir %name-%version
%endif

Packager: Sergey Y. Afonin <asy@altlinux.ru>

Summary: GNU Mailutils

License: %gpl3plus

%if %snapshot
Source0:        %name-%version-%snapshotdate.tar.gz
%else
Source0:        %name-%version.tar.gz
%endif

Patch1: mailutils-2.0.90-pkg-config-hack.diff

URL: http://www.gnu.org/software/%{name}/%{name}.html
Group: Networking/Mail

Conflicts: mailx

Provides: /bin/mail

%add_findreq_skiplist */usr/bin/guimb

BuildRequires(pre): rpm-build-licenses

Requires: libmailutils = %{version}-%{release}
Requires: libreadline

# Automatically added by buildreq on Mon Feb 06 2012
# optimized out: emacs-X11 emacs-base emacs-cedet-speedbar emacs-common fontconfig guile18 libX11-locales libgdk-pixbuf libgmp-devel libgpg-error libltdl7-devel libncurses-devel libstdc++-devel libtinfo-devel python-base python-modules
BuildRequires: bzlib-devel emacs-git flex gcc-c++ glibc-devel libdb4-devel libgcrypt-devel libgdbm-devel libgnutls-devel libldap-devel libpam-devel libreadline-devel libtokyocabinet-devel libwrap-devel python-devel zlib-devel

BuildRequires: /dev/pts
BuildRequires: emacs-X11

%description
GNU Mailutils contains a series of useful mail clients, servers, and
libraries. These are the primary mail utilities of the GNU system.
This package provides a replacement for /bin/mail(x) conforming to
the UNIX98 specification for mailx. It provides also a mail delivery
agent maidag, and other tools including guimb, dotlock, movemail, frm.

%package -n libmailutils
Summary: GNU Mailutils: mailbox access library.
License: %lgpl3plus
Group: System/Libraries
Provides: libmailutils-sieve = %{version}
Obsoletes: libmailutils-sieve

%description -n libmailutils
The runtime library libmailbox contains various mailbox access
routines and support for a number of mailbox types, such as mbox,
maildir, mh, POP3, and IMAP4. It also supports MIME message
handling, and sending mail via SMTP and /sbin/sendmail.

%package -n libmailutils-devel
Summary: GNU Mailutils: mailbox access development.
License: %lgpl3plus
Requires: libmailutils, libmailutils-sieve
Group: Development/Other

%description -n libmailutils-devel
GNU Mailutils: mailbox access development.

%package -n libmailutils-devel-static
Summary: GNU Mailutils: mailbox access static library development.
License: %lgpl3plus
Requires: libmailutils-devel
Group: Development/Other

%description -n libmailutils-devel-static
GNU Mailutils: mailbox access static library development.

%package doc
Summary: GNU Mailutils: documentation.
License: %fdl
Group: Development/Documentation
BuildArch: noarch

%description doc
API reference for libmailbox and user documentation for the rest of
the GNU Mailutils.

%package pop3d
Summary: GNU Mailutils: POP3 daemon.
License: %gpl3plus
Requires: libmailutils = %{version}-%{release}
Conflicts: courier-imap
Group: System/Servers

%description pop3d
The GNU POP3 daemon. Uses libmailbox to support different styles of
mailboxes.

%package imap4d
Summary: GNU Mailutils: IMAP4 daemon.
License: %gpl3plus
Requires: libmailutils = %{version}-%{release}
Group: System/Servers

%description imap4d
The GNU IMAP4 daemon. Uses libmailbox to support different styles of
mailboxes.

%package sieve
Summary: GNU Mailutils: mail filtering language Sieve.
License: %lgpl3plus
Requires: libmailutils = %{version}-%{release}, libmailutils-sieve = %{version}-%{release}
Group: Networking/Mail

%description sieve
GNU implementation of the mail filtering language Sieve, described in
RFC 3028 and RFC 3431. This packages contains also the Sieve interpreter
and Sieve to Scheme translator and filter.

%package comsatd
Summary: GNU Mailutils: Comsat daemon.
License: %gpl3plus
Requires: libmailutils = %{version}-%{release}
Group: System/Servers

%description comsatd
GNU Comsatd is the server which receives reports of incoming mail and
notifies users, wishing to get this service. It can be started either
from `inetd.conf' or as a standalone daemon.

%package maidag
Summary: GNU Mailutils: General-purpose Mail Delivery Agent.
License: %gpl3plus
Requires: libmailutils = %{version}-%{release}
Group: System/Servers

%description maidag
The name `maidag' stands for Mail Delivery Agent. It is a
general-purpose MDA offering a rich set of features. It can operate
both in traditional mode, reading the message from its standard input,
and in LMTP mode. Maidag is able to deliver mail to any mailbox
format, supported by GNU Mailutils.

%if_enabled guile
%package guile
Summary: GNU Mailutils: Guile bindings.
License: %gpl3plus
Requires: libmailutils = %{version}-%{release}
Requires: guile >= 1.8
Group: System/Libraries

BuildRequires: guile18-devel

%description guile
Guile bindings for GNU Mailutils.
%endif

%package locales
Summary: National Language files for mailutils
License: %gpl3plus
Group: Networking/Mail
BuildArch: noarch

%description locales
National Language files for mailutils

%package mh
Summary: GNU Mailutils: The Message Handling System.
License: %gpl3plus
Requires: libmailutils = %{version}-%{release}
Requires: emacs-base
Group: Networking/Mail

%description mh
The GNU MH (Message Handling System).

%if_enabled python
%package -n libmailutils-python
Summary: GNU Mailutils: libraries for integration with Python
License: %lgpl3plus
Requires: libmailutils = %{version}-%{release}
Group: System/Libraries

%description -n libmailutils-python
The libraries for integration with Python

%package -n python-module-mailutils
Summary: A Python interface to Mailutils framework
License: %gpl3plus
Group: Networking/Mail
BuildArch: noarch
Requires: python-module-mailutils-api = %version-%release

%description -n python-module-mailutils
This package contains Python bindings for GNU Mailutils.

%package -n python-module-mailutils-api
Summary: A Python interface to Mailutils framework, arch specific part
License: %gpl3plus
Group: Networking/Mail
Requires: libmailutils = %version-%release
Conflicts: python-module-mailutils < %version-%release

%description -n python-module-mailutils-api
This package contains architecture specific part of the
python-module-mailutils.
%endif

%prep
%if %snapshot
%setup -q -n %name-%version-%snapshotdate
%else
%setup -q
%endif

%patch1 -p0

gzip ChangeLog

# some includes for info-documentation are absent in 2.9.91
pushd doc/texinfo
for file in addr http mailcap numaddr sfrom url-parse
do
 [ -f $file.inc ] || touch $file.inc
done
popd

# see http://bugzilla.altlinux.org/31449
sed "s/^@hashchar{}/#/" -i doc/texinfo/programs.texi

%build

#autoreconf -f -i -s

%set_verify_elf_method unresolved=relaxed
#undefine __libtoolize

CFLAGS="-llber" \
%configure \
    --disable-rpath \
    --enable-ipv6 \
    --with-mh-bindir=%_libexecdir/mu-mh \
    %if_enabled guile
    --with-guile-site-dir=%_datadir/guile/site \
    %else
    --without-guile \
    %endif
    %{!?_enable_python: --disable-python} \
    #

# SMP-incompatible build.
%make V=1

%check

%make check

%install

%makeinstall_std

install -d $RPM_BUILD_ROOT/bin
ln -s ..%_bindir/mail "$RPM_BUILD_ROOT/bin/mail"
pushd $RPM_BUILD_ROOT%_bindir
    ln -s mail Mail
    ln -s mail mailx
popd

%if_enabled guile
pushd $RPM_BUILD_ROOT%_libdir
    NAME1=`ls libguile-mailutils*.so`
    NAME2=`find libmu_scm.so.* -type f`
    ln -sf $NAME2 $NAME1
popd
%endif

rm -f $RPM_BUILD_ROOT%python_sitelibdir/mailutils/c_api.a
rm -f $RPM_BUILD_ROOT%python_sitelibdir/mailutils/c_api.la

%find_lang %name

%files -n mailutils
%_bindir/mailutils
%_bindir/dotlock
%_bindir/frm
%_bindir/from
%_bindir/mail
%_bindir/mailx
%_bindir/Mail
/bin/mail
%_bindir/popauth
%_bindir/messages
%_bindir/mimeview
%_bindir/movemail
%_bindir/readmsg
%_mandir/*/mail*

%files -n libmailutils

%dir %_libdir/mailutils
%_libdir/mailutils/moderator.so
%_libdir/mailutils/vacation.so
%_libdir/mailutils/pipe.so
%_libdir/mailutils/list.so
%_libdir/mailutils/numaddr.so
%_libdir/mailutils/spamd.so
%_libdir/mailutils/timestamp.so
%_libdir/mailutils/editheader.so

%_libdir/libmailutils.so.*
%_libdir/libmuaux.so.*

%exclude %_libdir/libmu_*.so
%_libdir/libmu_*.so.*

%if_enabled python
%exclude %_libdir/libmu_py.so.*
%endif

%files -n libmailutils-devel
%_includedir/*
%_bindir/mailutils-config
%_datadir/aclocal/mailutils.m4
%_libdir/libmu_argp.a
%_libdir/libmailutils.so
%_libdir/libmuaux.so
%_libdir/libmu_*.so

%files -n libmailutils-devel-static
%_libdir/libmailutils.*a
%_libdir/mailutils/moderator.*a
%_libdir/mailutils/vacation.*a
%_libdir/mailutils/pipe.*a
%exclude %_libdir/libmu_argp.a
%_libdir/libmu*.*a
%_libdir/mailutils/list.*a
%_libdir/mailutils/numaddr.*a
%_libdir/mailutils/spamd.*a
%_libdir/mailutils/timestamp.*a
%_libdir/mailutils/editheader.*a

%files doc
%doc AUTHORS COPYING* NEWS README README-alpha THANKS TODO ChangeLog.gz
# info documentation absent in 2.9.91
%exclude %_infodir/*

%files pop3d
%_sbindir/pop3d
%_mandir/*/pop*

%files imap4d
%_sbindir/imap4d
%_mandir/*/imap4d*

%files comsatd
%_sbindir/comsatd

%files maidag
%_sbindir/maidag

%files sieve
%_bindir/sieve

%if_enabled guile
%files guile
%dir %_datadir/guile/site/mailutils
%dir %_datadir/guile/site/mailutils/sieve-modules
%_bindir/guimb
%_bindir/sieve2scm
%_datadir/guile/site/mailutils/*.scm
%_datadir/guile/site/mailutils/*.txt
%_datadir/guile/site/mailutils/sieve-modules/*.scm
%_libdir/libguile-mailutils*.so
%endif

%files locales -f %name.lang

%files mh
%dir %_libexecdir/mu-mh
%dir %_datadir/mailutils
%dir %_datadir/mailutils/mh
%_libexecdir/mu-mh/*
%_datadir/mailutils/mh/*
%_datadir/emacs/site-lisp/*

%if_enabled python
%files -n libmailutils-python
%_libdir/libmu_py.so.*

%files -n python-module-mailutils
%dir %python_sitelibdir_noarch/mailutils/
%python_sitelibdir_noarch/mailutils/*.py*

%files -n python-module-mailutils-api
%dir %python_sitelibdir/mailutils/
%python_sitelibdir/mailutils/*.so
%endif

%changelog
