%define ver 3.82
Name: make%ver
Version: 3.82
Release: alt2
Epoch:   2

Summary: A GNU tool which simplifies the build process for users
License: GPLv3
Group: Development/Other
Url: http://www.gnu.org/software/make/
Packager: Alexey Gladkov <legion@altlinux.org>

# ftp://ftp.gnu.org/gnu/make/make-%version.tar.bz2
Source: make-%version.tar
Patch1: make-3.82-err-reporting.patch
Patch2: make-3.82-getcwd.patch
Patch3: make-3.82-j8k.patch
Patch4: make-3.82-jobserver.patch
Patch5: make-3.82-newlines.patch
Patch6: make-3.82-weird-shell.patch
Patch7: make-3.82-bugfixes.patch
Patch8: make-3.82-sort-blank.patch


%description
A GNU tool for controlling the generation of executables and other
non-source files of a program from the program's source files.
Make allows users to build and install packages without any significant
knowledge about the details of the build process.  The details about
how the program should be built are provided for make in the program's
makefile.

%prep
%setup -q -n make-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
bzip2 -9k NEWS ChangeLog
rm doc/*.info*

%build
%autoreconf

# Enable mkstemp explicitly, not rely on configure (Owl).
export ac_cv_func_mkstemp=yes
%configure --program-suffix=-%ver
%make_build

%install
%makeinstall
ln -sf make-%ver %buildroot%_bindir/gmake-%ver

find %buildroot%_infodir -name 'make.info*' |
while read fn; do
	name="${fn##*/}"
	new_fn="${fn%%/*}/make-%ver.${name#make.}"
	mv -f -- "$fn" "$new_fn"
done

find %buildroot%_datadir/locale -name '*.mo' |
while read fn; do
	new_fn="${fn%%/*}/make-%ver.mo"
	mv -f -- "$fn" "$new_fn"
done

%find_lang make-%ver

%check
%make_build -k check

%files -f make-%ver.lang
%_bindir/*
%_mandir/man?/*
%_infodir/*.info*
%doc AUTHORS ChangeLog.bz2 NEWS.bz2 README

%changelog
