# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: man
Version: 1.6g
Release: alt2

Summary: Programs for formating and displaying the manual pages
License: GPL
Group: System/Base
Url: http://primates.ximian.com/~flucifredi/man/
Packager: Alexey Gladkov <legion@altlinux.ru>

Source0: http://primates.ximian.com/~flucifredi/%name/%name-%version.tar.gz
Source3: makewhatis
Source4: whatis.filetrigger

Patch0: man-1.5m2-cvs-fixes.patch
Patch1: man-1.6f-alt-add-less-R.patch
Patch2: man-1.6g-alt-makefile.patch
Patch3: man-alt-bzip2.patch
Patch4: man-alt-usage_fix.patch
Patch5: man-1.5k-alt-conf.patch

Patch7: man-alt-apropos.patch
Patch8: man-alt-man-makewhatis.patch
Patch9: man-1.5k-alt-msgs.patch
Patch10: man-1.5m2-alt-manpath.patch
Patch11: man-alt-recode.patch
Patch12: man-alt-recode2.patch
Patch13: man-alt-unlatin1.patch
Patch15: man-1.5m2-alt-utf8whatis.patch
Patch16: man-1.5m2-alt-my_xsprintf.patch
Patch17: man-1.6f-alt-call-pic-tbl-inside-groff.patch
Patch18: man-1.6f-alt-add-tty-tmac.patch
Patch19: man-1.6g-alt-man-unpack.patch
Patch20: man-1.6g-alt-add-man-show-source.patch
Patch21: man-1.6f-alt-safer-mode.patch
Patch22: man-1.6f-remove-unsafe.patch

# Automatically added by buildreq on Wed Mar 12 2003
BuildRequires: groff-base less su lzma-utils ncompress

PreReq: shadow-utils
Requires: mktemp >= 1:1.3.1
Requires: getopt less iconv lzma-utils

# After fixing bug #9364 file /usr/share/man/$LANG/.charset supplied
# by man package
Conflicts: man-pages-ru <= 0.98-alt11
Conflicts: man-pages-uk <= 20030816-alt1

# Because we use nroff with -D option
Requires: groff-base >= 1.19.3-alt3.20081215
# Because man -t required this
Requires: groff-ps >= 1.19.3-alt3.20081215

Provides: man-base
Obsoletes: man-base < %version-%release

%description
This package contains the man system which is formats and displays
on-line manual pages about commands or functions on your system.

%package whatis
Summary: Tools for finding documentation about Linux system
Group: System/Base
BuildArch: noarch
Requires: %name = %version-%release
Requires: libshell

%description whatis
This package contains parts of the man system which is used for
finding information and/or documentation about your Linux system:
apropos and whatis.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p2
%patch5 -p1

%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1 -b .fix20
%patch21 -p1
%patch22 -p1

%build

# FIXME:
# Don't install messages for Russian, because they in koi8-r charsets
# and not displayed properly in CP1251 and UTF-8 locales.
INSTALL_LANGUAGES=`grep ^LANGUAGES configure | cut -d\" -f2 | sed 's|,ru||'`
./configure -default -confdir /etc +sgid +fsstnd +fhs +lang "$INSTALL_LANGUAGES"
#./configure -default -confdir /etc +sgid +fsstnd +fhs +lang all

# SMP-incompatible build.
%make CC="%__cc %optflags -D_GNU_SOURCE" LDFLAGS=

%install
%makeinstall_std

install -Dp -m755 %SOURCE4 %buildroot%_rpmlibdir/whatis.filetrigger

# Symlinks for manpath
ln -snf %name %buildroot%_bindir/manpath
ln -snf %name.1 %buildroot%_man1dir/manpath.1

mkdir -p %buildroot{%_cachedir/man/{{,{local,perl,X11R6}/}cat{1,2,3,4,5,6,7,8,9,n},tmp},%_lockdir/makewhatis}
for f in %buildroot%_cachedir/man/{,{local,perl,X11R6}/}whatis; do echo >"$f"; done

find %buildroot%_mandir -type f -print0 |
	xargs -r0 chmod 644 --

# See bug ALT#27372 for details
mkdir -p %buildroot%_tmpfilesdir
cat > %buildroot%_tmpfilesdir/man.conf <<EOF
D %_lockdir/makewhatis 0700 root root -
EOF

# See bug ALT#9364 for details
mkdir -p %buildroot%_mandir/{ru,uk}
echo "KOI8-R" > %buildroot%_mandir/ru/.charset
echo "KOI8-U" > %buildroot%_mandir/uk/.charset

# Replace makewhatis with ALT-specific script.
rm %buildroot%_sbindir/makewhatis
install -pD -m754 %SOURCE3 %buildroot%_sbindir/makewhatis

%find_lang %name --with-man

for man in man man.conf apropos whatis makewhatis; do
	%find_lang "$man" \
		--output="%name.lang" \
		--append \
		--with-man \
		--without-mo
done

%pre
/usr/sbin/useradd -r -g man -d %_cachedir/man -s /dev/null -n cacheman >/dev/null 2>&1 ||:

%triggerpostun -- %name < 1.5m2-alt2
echo -n 'Rebuilding whatis database... '
su -l cacheman -s /bin/sh -c '/usr/sbin/makewhatis'
echo done.

%files -f %name.lang
%_mandir/ru/.charset
%_mandir/uk/.charset
%config(noreplace) %_sysconfdir/%name.conf
%_tmpfilesdir/man.conf
%_bindir/*
%_man1dir/manpath.1.*
%_man1dir/man2html.1.*
%_man1dir/man.1.*
%_man5dir/man.conf.5.*

%exclude %_bindir/whatis
%exclude %_bindir/apropos
%exclude %_man1dir/whatis.1.*
%exclude %_man1dir/apropos.1.*
%exclude %_man8dir/makewhatis.8.*

%attr(3775,root,man) %dir %_cachedir/man
%attr(3775,root,man) %dir %_cachedir/man/local
%attr(3775,root,man) %dir %_cachedir/man/perl
%attr(3775,root,man) %dir %_cachedir/man/X11R6

%defattr(644,root,man,2775)
%_cachedir/man/cat*
%_cachedir/man/local/cat*
%_cachedir/man/perl/cat*
%_cachedir/man/X11R6/cat*

%files whatis
%attr(754,root,man) %_sbindir/makewhatis
%_bindir/whatis
%_bindir/apropos
%_man1dir/whatis.1.*
%_man1dir/apropos.1.*
%_man8dir/makewhatis.8.*

%_rpmlibdir/whatis.filetrigger

%attr(700,cacheman,man) %dir %_cachedir/man/tmp
%attr(644,cacheman,man) %ghost %_cachedir/man/whatis
%attr(644,cacheman,man) %ghost %_cachedir/man/local/whatis
%attr(644,cacheman,man) %ghost %_cachedir/man/perl/whatis
%attr(644,cacheman,man) %ghost %_cachedir/man/X11R6/whatis

%changelog
