Name: man-pages
Version: 3.32
Release: alt3

Summary: Man (manual) pages from the Linux Documentation Project
Summary(ru_RU.UTF8): Руководства пользователя Linux Documentation Project
License: distributable
Group: Documentation
Url: http://www.kernel.org/doc/man-pages/
Packager: Slava Semushin <php-coder@altlinux.ru>

# http://www.kernel.org/pub/linux/docs/man-pages/%name-%version.tar.bz2
Source: %name-%version.tar
Source3: netman-cvs.tar
# Where to find it ????
Source4: man9-19971126.tar
#Source5: %name-goodies.tar
Source6: %name-extra.tar

Source100: libtoolize.1
Source101: libtool.1

Patch7: man-pages-1.39-owl-ccldso.patch

Requires: man >= 1.5i2-alt4
BuildArch: noarch
Obsoletes: man9 gnumaniak

# due to major.3/minor.3 (see #19717)
Conflicts: libSDL_sound-devel <= 1.0.3-alt1

# due to resolver.5 (see #19784)
Conflicts: bind-utils <= 9.3.6-alt3

# due to security.2
Conflicts: libcint-devel <= 7.3.00-alt1.svn20090707

%description
A large collection of man pages (reference material) from the Linux
Documentation Project (LDP).  The man pages are organized into the
following sections:
	1:  User commands (intro and pages not maintained by FSF)
	2:  System calls
	3:  Libc calls
	4:  Devices (e.g. hd, sd)
	5:  File formats and protocols (e.g. wtmp, /etc/passwd, nfs)
	6:  Games (intro only)
	7:  Conventions, macro packages, etc.
	8:  System administration (intro only)
	9:  Kernel internal routines

%description -l ru_RU.UTF8
Большая коллекция справочного материала разработанного в рамках Linux
Documentation Project (LDP). Материалы сгруппированы по секциям:
	1:  Команды пользователя (введение)
	2:  Системные вызовы
	3:  Вызовы libc
	4:  Устройства (например, hd, sd)
	5:  Форматы файлов и протоколов (например, wtmp, /etc/passwd, nfs)
	6:  Игры (только введение)
	7:  Соглагшения, макропакеты, и т.д.
	8:  Системное администрирование (только введение)
	9:  Встроенные службы ядра

%package utils
Summary: The scripts for man-pages maintenance tasks.
Summary(ru_RU.UTF8): The scripts for man-pages maintenance tasks.
Group: System/Internationalization

%description utils
The scripts for man-pages maintenance tasks.
They may be useful for downstream man-pages package maintainers or for
man-pages translators.

%description -l ru_RU.UTF8 
The scripts for man-pages maintenance tasks.
They may be useful for downstream man-pages package maintainers or for
man-pages translators.

%prep
%setup -a3 -a4 -a6

%patch7 -p1

mv *.4 man4
for f in `find man -type f |sed -e 's|^man/||g'`; do
	install -D -p -m644 "man/$f" "$f"
done

find man3 -type f -print0 |
	xargs -r0 grep -l '.*\.3 '|
	xargs -r perl -pi -e 's/\.3 /.3/'

find man9 -type f -print0 |
	xargs -r0 grep -l '^\.so:' |
	xargs -r perl -pi -e 's/^\.so:/.so /'

# su.1: moved to su package based on SimplePamApps.
find -type f -name su.1 -print0 |
    xargs -r0 rm -f --

%build
# coreutils
rm -fv man1/{chgrp,chmod,chown,cp,dd,df,dircolors,du,install}.1
rm -fv man1/{ln,ls,mkdir,mkfifo,mknod,mv,rm,rmdir,touch}.1
rm -fv man1/{dir,vdir,hostname}.1

# diffutils
rm -fv man1/diff.1

# quota
rm -f man*/quota*

# console-tools
rm -rf man4/console.4

# fdutils
rm -rf man4/fd.4
# ld.so
#rm -rf man3/{dlclose,dlerror,dlopen,dlsym}.3

#mv man1/README README.GNU-INFOvsMAN

# libattr-devel
rm -rf man2/{fgetxattr,flistxattr,fremovexattr,fsetxattr,getxattr,lgetxattr,listxattr,llistxattr,lremovexattr,lsetxattr,removexattr,setxattr}.2

%install
mkdir -p %buildroot{%_mandir,%_datadir/%name}
cp -a man? %buildroot%_mandir
cp scripts/* %buildroot%_datadir/%name
chmod -R a+rX,go-w %buildroot%_mandir
install %SOURCE100 %buildroot%_man1dir/
install %SOURCE101 %buildroot%_man1dir/

# strip COLOPHON section
find %buildroot%_mandir -type f -print0 | xargs -r0 sh scripts/remove_COLOPHON.sh

%files
%doc README* *.Announce FIXME *.lsm
%_mandir/man?/*

%files utils
%_datadir/%name/

%changelog
