BuildRequires: maven-enforcer-plugin
# BEGIN SourceDeps(oneline):
BuildRequires: unzip
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-compat
Name:       maven-plugin-cobertura
Version:    2.5.1
Release:    alt2_4jpp7
Summary:    Plugin providing the features of Cobertura within Maven

Group:      Development/Java
License:    ASL 2.0 and GPLv2 and GPLv2+
URL:        http://mojo.codehaus.org/cobertura-maven-plugin/
Source0:    http://repo2.maven.org/maven2/org/codehaus/mojo/cobertura-maven-plugin/%{version}/cobertura-maven-plugin-%{version}-source-release.zip
BuildArch:  noarch

BuildRequires:  maven
BuildRequires:  maven-plugin-plugin
BuildRequires:  maven-resources-plugin
BuildRequires:  maven-compiler-plugin
BuildRequires:  maven-jar-plugin
BuildRequires:  maven-install-plugin
BuildRequires:  maven-invoker-plugin
BuildRequires:  maven-javadoc-plugin
BuildRequires:  maven-surefire-plugin
BuildRequires:  maven-surefire-provider-junit4
BuildRequires:  maven-doxia-sitetools
BuildRequires:  maven-plugin-testing-harness
BuildRequires:  maven-plugin-cobertura
BuildRequires:  gnu-getopt >= 0:1.0.13
BuildRequires:  cobertura
BuildRequires:  mojo-parent

Requires:       maven
Requires:       cobertura
Requires:       mojo-parent
Requires(post): jpackage-utils
Requires(postun):  jpackage-utils
Source44: import.info

Provides: mojo-maven2-plugin-cobertura = 18
Obsoletes: mojo-maven2-plugin-cobertura < 18


%description
This plugin provides the features of Cobertura within the Maven 2 environment.
The report generated by this plugin is the result of executing the Cobertura
tool against your compiled classes to help you determine how well the unit
testing efforts have been, and can then be used to identify which parts
of your Java program are lacking test coverage.

%package	javadoc
Summary:    Javadoc for %{name}
Group:      Development/Java
Requires:   jpackage-utils
BuildArch: noarch

%description	javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q -n cobertura-maven-plugin-%{version}

%build
mvn-rpmbuild -Dmaven.test.failure.ignore=true package javadoc:javadoc

%install
# jar
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}
install -p -m 644 target/cobertura-maven-plugin-%{version}.jar \
  $RPM_BUILD_ROOT%{_javadir}/maven-plugin-cobertura.jar

# pom
install -d -m 755 $RPM_BUILD_ROOT%{_mavenpomdir}
install -p -m 644 pom.xml \
  $RPM_BUILD_ROOT/%{_mavenpomdir}/JPP-maven-plugin-cobertura.pom
%add_to_maven_depmap org.codehaus.mojo cobertura-maven-plugin %{version} JPP maven-plugin-cobertura

# javadoc
install -d -m 755 $RPM_BUILD_ROOT%{_javadocdir}/%{name}
cp -rp target/site/apidocs/* $RPM_BUILD_ROOT%{_javadocdir}/%{name}

%files
%{_mavenpomdir}/JPP-%{name}*.pom
%{_mavendepmapfragdir}/%{name}
%{_javadir}/*

%files javadoc
%{_javadocdir}/%{name}

%changelog
