BuildRequires: /proc
BuildRequires: jpackage-compat
%global ver_suffix -alpha-1

Name:           maven-plugin-testing
Version:        2.0
Release:        alt1_4.alpha1jpp7
Summary:        Maven Plugin Testing

Group:          Development/Java
License:        ASL 2.0
URL:            http://maven.apache.org/plugin-testing/

#svn export http://svn.apache.org/repos/asf/maven/plugin-testing/tags/maven-plugin-testing-2.0-alpha-1
#tar caf maven-plugin-testing-2.0-alpha-1.tar.xz maven-plugin-testing-2.0-alpha-1
Source0:        %{name}-%{version}%{ver_suffix}.tar.xz

Patch0:         %{name}-maven3-missing-methods.patch

BuildArch: noarch

BuildRequires: junit
BuildRequires: maven
BuildRequires: maven-install-plugin
BuildRequires: maven-compiler-plugin
BuildRequires: maven-resources-plugin
BuildRequires: maven-jar-plugin
BuildRequires: maven-source-plugin
BuildRequires: maven-site-plugin
BuildRequires: plexus-containers-component-metadata
BuildRequires: maven-javadoc-plugin
BuildRequires: maven-doxia-sitetools
BuildRequires: maven-surefire-plugin
BuildRequires: maven-surefire-provider-junit
BuildRequires: maven-shared-reporting-impl
BuildRequires: maven-test-tools

Requires: maven
Requires: jpackage-utils
Source44: import.info

%description
The Maven Plugin Testing contains the necessary modules
to be able to test Maven Plugins.

%package javadoc
Group:          Development/Java
Summary:        Javadoc for %{name}
Requires:       jpackage-utils
BuildArch: noarch

%description javadoc
API documentation for %{name}.

%package harness
Summary: Maven Plugin Testing Mechanism
Group: Development/Java
Requires: maven-plugin-testing = %{version}-%{release}
Obsoletes: maven-shared-plugin-testing-harness <= 0:1.2
Provides: maven-shared-plugin-testing-harness = 1:%{version}-%{release}

%description harness
The Maven Plugin Testing Harness provides mechanisms to manage tests on Mojo.

%package tools
Summary: Maven Plugin Testing Tools
Group: Development/Java
Requires: maven-plugin-testing = %{version}-%{release}
Obsoletes: maven-shared-plugin-testing-tools <= 0:%{version}-%{release}
Provides: maven-shared-plugin-testing-tools = 1:%{version}-%{release}

%description tools
A set of useful tools to help the Maven Plugin testing.

%package -n maven-test-tools
Summary: Maven Testing Tool
Group: Development/Java
Requires: maven-plugin-testing = %{version}-%{release}
Obsoletes: maven-shared-test-tools <= 0:%{version}-%{release}
Provides: maven-shared-test-tools = 1:%{version}-%{release}

%description -n maven-test-tools
Framework to test Maven Plugins with Easymock objects.

%prep
%setup -q -n %{name}-%{version}%{ver_suffix}

%patch0 -p1

%build
mvn-rpmbuild -Dmaven.test.failure.ignore=true install javadoc:aggregate
#tests are skipped due to some test failures most probably caused by issues with our plexus container

%install
# jars
install -d -m 0755 %{buildroot}%{_javadir}/%{name}
install -m 644 maven-plugin-testing-harness/target/%{name}-harness-%{version}%{ver_suffix}.jar  \
                   %{buildroot}%{_javadir}/%{name}/%{name}-harness.jar
install -m 644 maven-plugin-testing-tools/target/%{name}-tools-%{version}%{ver_suffix}.jar \
                 %{buildroot}%{_javadir}/%{name}/%{name}-tools.jar
install -m 644 maven-test-tools/target/maven-test-tools-%{version}%{ver_suffix}.jar  \
       %{buildroot}%{_javadir}/%{name}/maven-test-tools.jar

# poms
install -d -m 755 %{buildroot}%{_mavenpomdir}
install -pm 644 pom.xml %{buildroot}%{_mavenpomdir}/JPP.%{name}-%{name}.pom
install -pm 644 maven-plugin-testing-harness/pom.xml %{buildroot}%{_mavenpomdir}/JPP.%{name}-%{name}-harness.pom
install -pm 644 maven-plugin-testing-tools/pom.xml %{buildroot}%{_mavenpomdir}/JPP.%{name}-%{name}-tools.pom
install -pm 644 maven-test-tools/pom.xml %{buildroot}%{_mavenpomdir}/JPP.%{name}-maven-test-tools.pom

# javadoc
install -d -m 755 %{buildroot}%{_javadocdir}/%{name}
cp -pr target/site/apidocs/* %{buildroot}%{_javadocdir}/%{name}/

%add_maven_depmap -a "org.apache.maven.shared:%{name}" JPP.%{name}-%{name}.pom
%add_maven_depmap -f harness -a "org.apache.maven.shared:%{name}-harness" JPP.%{name}-%{name}-harness.pom %{name}/%{name}-harness.jar
%add_maven_depmap -f tools -a "org.apache.maven.shared:%{name}-tools" JPP.%{name}-%{name}-tools.pom %{name}/%{name}-tools.jar
%add_maven_depmap -f maven-test-tools -a "org.apache.maven.shared:maven-test-tools" JPP.%{name}-maven-test-tools.pom %{name}/maven-test-tools.jar

%pre javadoc
[ $1 -gt 1 ] && [ -L %{_javadocdir}/%{name} ] && \
rm -rf $(readlink -f %{_javadocdir}/%{name}) %{_javadocdir}/%{name} || :

%files
%{_mavenpomdir}/JPP.%{name}-%{name}.pom
%{_mavendepmapfragdir}/%{name}

%files javadoc
%{_javadocdir}/*

%files harness
%{_javadir}/%{name}/%{name}-harness.jar
%{_mavenpomdir}/JPP.%{name}-%{name}-harness.pom
%{_mavendepmapfragdir}/%{name}-harness

%files tools
%{_javadir}/%{name}/%{name}-tools.jar
%{_mavenpomdir}/JPP.%{name}-%{name}-tools.pom
%{_mavendepmapfragdir}/%{name}-tools

%files -n maven-test-tools
%{_javadir}/%{name}/maven-test-tools.jar
%{_mavenpomdir}/JPP.%{name}-maven-test-tools.pom
%{_mavendepmapfragdir}/%{name}-maven-test-tools

%changelog
