Name: mediatomb
Version: 0.12.1
Release: alt9

Summary: UPnP AV Mediaserver for Linux
Group: System/Servers
License: GPLv2
Url: http://mediatomb.cc/

Source: %name-%version.tar
Patch: %name-%version-%release.patch

Source1: mediatomb.init
Source2: mediatomb.sysconfig
Source3: mediatomb.service

BuildRequires: gcc-c++ id3lib-devel libavformat-devel libcurl-devel libexif-devel libexpat-devel libffmpegthumbnailer-devel
BuildRequires: libjs-devel libmagic-devel libmpeg4ip-devel libmysqlclient-devel libsqlite3-devel libtag-devel

%description
MediaTomb is an open source (GPL) UPnP MediaServer with a nice web user
interface, it allows you to stream your digital media through your home
network and listen to/watch it on a variety of UPnP compatible devices.

MediaTomb implements the UPnP MediaServer V 1.0 specification that can
be found on http://www.upnp.org/.

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--enable-sighup \
	--enable-mrreg-service \
	--enable-protocolinfo-extension \
	--enable-external-transcoding \
	--enable-curl \
	#
%make_build

%install
mkdir -p %buildroot{%_sysconfdir/sysconfig,%_initdir,%_localstatedir/%name}
%make_install DESTDIR=%buildroot install

install -p -m755 %SOURCE1 %buildroot%_initdir/mediatomb
install -p -m644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/mediatomb
install -pD -m0644 %SOURCE3 %buildroot%systemd_unitdir/mediatomb.service

%pre
%_sbindir/groupadd -r -f _mediatomb >/dev/null 2>&1 ||:
%_sbindir/useradd -r -n -g _mediatomb -d %_localstatedir/%name -s /dev/null -c 'MediaTomb UPnP(TM) A/V Media Server' _mediatomb >/dev/null 2>&1 ||:

%post
%post_service mediatomb

%preun
%preun_service mediatomb

%files
%doc README AUTHORS ChangeLog COPYING
%doc doc/scripting.txt doc/scripting_utf8.txt
%config %_initdir/mediatomb
%config(noreplace) %_sysconfdir/sysconfig/mediatomb
%systemd_unitdir/mediatomb.service
%_bindir/mediatomb
%_datadir/%name
%_man1dir/*
%attr(3770,root,_mediatomb) %dir %_localstatedir/%name

%changelog
