# This spec is backported to ALTLinux p7 automatically by rpmbph script. Do not edit it.
#
%define webappdir %webserver_webappsdir/mediawiki
%define major 1.23

Name: mediawiki
Version: %major.11
Release: alt2.M70P.3

Summary: A wiki engine, typical installation (with Apache2 and MySQL support)

License: %gpl2plus
Group: Networking/WWW
Url: http://www.mediawiki.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

BuildArch: noarch

Source0: http://releases.wikimedia.org/mediawiki/%major/%name-%version.tar
Source1: mediawiki-apache2-alt-configs.tar
Source2: README.ALT-ru_RU.UTF-8
Source3: install_php_config.sh
Source4: mediawiki.ini
Source5: README.UPGRADE.ALT-ru_RU.UTF-8
Source6: AdminSettings.sample
Source7: 99-read-user-configs.php

Patch: %name-%major-alt.patch
Patch1: 0001-disable-skin-using-autodiscovery-mechanism-warning.patch

BuildRequires(pre): rpm-macros-apache2
BuildRequires(pre): rpm-build-licenses
BuildRequires(pre): rpm-build-mediawiki >= 0.5
BuildRequires(pre): rpm-build-webserver-common

BuildPreReq: apache2-devel

Requires: %name-common = %version-%release
Requires: %name-apache2 %name-mysql

Requires: php5-dom ImageMagick

%description
MediaWiki is the software used for Wikipedia and the other Wikimedia
Foundation websites. Compared to other wikis, it has an excellent
range of features and support for high-traffic websites using multiple
servers

This package supports wiki farms. Configure it through the web
interface. Remember to secure the config dir after completing the
configuration.

This is a typical %name installation (with Apache2 and MySQL support).
Also, optional dependency will be installed:
ImageMagick.

If you wish pure %name, install only %name-common package.


%package -n %name-common
Summary: Common files for %name
Group: Networking/WWW
PreReq: webserver-common
Requires: php-engine >= 5
Requires: diffutils

# since 1.20
Provides: mediawiki-extensions-ParserFunctions
Obsoletes: mediawiki-extensions-ParserFunctions

Provides: mediawiki-extensions-ConfirmEdit
Obsoletes: mediawiki-extensions-ConfirmEdit

Provides: mediawiki-extensions-SearchSuggest
Obsoletes: mediawiki-extensions-SearchSuggest

# since 1.21
Provides: mediawiki-extensions-Cite
Obsoletes: mediawiki-extensions-Cite

Provides: mediawiki-extensions-ImageMap
Obsoletes: mediawiki-extensions-ImageMap

Provides: mediawiki-extensions-Poem
Obsoletes: mediawiki-extensions-Poem

Conflicts: mediawiki-extensions-FCKEditor

Provides: mediawiki-extensions-TitleBlacklist
Provides: mediawiki-extensions-SpamBlacklist
Provides: mediawiki-extensions-InputBox
Provides: mediawiki-extensions-LocalisationUpdate

# since 1.22
Provides: mediawiki-extensions-SimpleAntiSpam
Provides: mediawiki-extensions-PostEdit
Provides: mediawiki-extensions-Vector

# since 1.23
Provides: mediawiki-extensions-ExpandTemplates
Provides: mediawiki-extensions-AssertEdit

%description -n %name-common
%summary

%package -n %name-apache2
Summary: Apache2's requires and config files for %name
Group: Networking/WWW
Requires: %name-common = %version-%release
Requires: apache2-common >= 2.2.0
Requires: %_initdir/%apache2_dname
Requires: apache2-httpd-prefork
Requires: apache2-mod_php5 >= 5

%description -n %name-apache2
Install this package, if you wish to run %name under apache2 webserver


%package -n %name-mysql
Summary: Virtual package for mysql requires for %name
Group: Networking/WWW
Requires: %name-common = %version-%release
Requires: php5-mysql mysql-server >= 4.1

%description -n %name-mysql
Install this package, if you wish to run %name with MySQL database


%package -n %name-postgresql
Summary: Virtual package for postgresql requires for %name
Group: Networking/WWW
Requires: %name-common = %version-%release
Requires: php5-pgsql postgresql-server >= 8.1

%description -n %name-postgresql
Install this package, if you wish to run %name with PostgreSQL database

%package -n %name-hiphop
Summary: Package with hihop support for %name
Group: Networking/WWW
Requires: %name-common = %version-%release

%description -n %name-hiphop
%summary


%prep
%setup
%patch -p2
%patch1 -p2

%install
mkdir -p %buildroot%_mediawikidir

# Copying to buildroot all files and directories and remove unneeded
cp -r * %buildroot%_mediawikidir/

# Not needed in the package (generate extra dependencies)
rm -rf %buildroot%_mediawikidir/maintenance/dev/
rm -rf %buildroot%_mediawikidir/maintenance/cssjanus/
rm -rf %buildroot%_mediawikidir/maintenance/{Makefile,mwjsduck-gen,jsduck/,resources/update-oojs.sh}
rm -rf %buildroot%_mediawikidir/tests/
rm -rf %buildroot%_mediawikidir/{*.php5,*.phtml}
rm -rf %buildroot%_mediawikidir/{COPYING,CREDITS,FAQ,HISTORY,README*,RELEASE-NOTES-*,UPGRADE}
rm -rf %buildroot%_mediawikidir/resources/lib/oojs-ui/update-oojs-ui.sh
rm -fr %buildroot%_mediawikidir/includes/zhtable

find %buildroot%_mediawikidir/ \
  \( -name .htaccess -or -name \*.cmi \) \
  -print0 \
  | xargs -r0 rm

# packed as docs
rm -rf %buildroot%_mediawikidir/docs/

# do not pack that bundled extension:
rm -rf %buildroot%_mediawikidir/extensions/SyntaxHighlight_GeSHi/

mkdir -p %buildroot%_mediawikidir/config/

sed -i -e "s/__VERSION__/%version/g" %SOURCE2
sed -i -e "s/__VERSION__/%version/g" %SOURCE5
install -m 644 %SOURCE2 ./
install -m 755 %SOURCE3 ./
install -m 644 %SOURCE4 ./
install -m 644 %SOURCE5 ./


# fix permissions
#chmod +x %buildroot%_mediawikidir/bin/*
find %buildroot%_mediawikidir -name \*.pl -print0 | xargs -r0 chmod +x


mkdir -p %buildroot%webappdir/
cd %buildroot%_mediawikidir/
mv cache images %buildroot%webappdir/
ln -sf %webappdir/{cache,images} .

mkdir config/LocalSettings.d/
install -m 644 %SOURCE7 config/LocalSettings.d/
ln -sf %webappdir/config/LocalSettings.php config/

cd %buildroot%webappdir/
mkdir -p config/LocalSettings.d
install -m 600 %SOURCE6 config/
ln -s %_mediawikidir wiki

# Configs for apache2
mkdir -p %buildroot%apache2_confdir
pushd %buildroot%apache2_confdir
tar xvSf %SOURCE1
find -name \*.conf |xargs sed -i "s|WEBAPPDIR|%webappdir|"
popd

# TODO: use macro
# config for enable bundled ParserFunctions
cat > %buildroot%_mediawiki_settings_dir/50-ParserFunctions.php << EOF
<?php

require_once("\$IP/extensions/ParserFunctions/ParserFunctions.php");

# enable StringFunctions (like {{#pos, {{#len) by default
\$wgPFEnableStringFunctions = true;
EOF


%pre -n %name-common
if [ -L %_mediawikidir/config ]; then
	rm -f %_mediawikidir/config
fi
if [ -d %_datadir/%name/images -a ! -L %_datadir/%name/images ]; then
	rmdir %_datadir/%name/images 2>/dev/null || {
		mv %_datadir/%name/images %_datadir/%name/images.rpmsave
		echo "%_datadir/%name/images saved as %_datadir/%name/images.rpmsave"
	}
fi

%post -n %name-common
if [ $1 -eq 2 ] ; then
	cat <<EOF
Running MediaWiki update:
 # php %webappdir/wiki/maintenance/update.php
Check full upgrading manual on https://www.mediawiki.org/wiki/Manual:Upgrading
EOF
php %webappdir/wiki/maintenance/update.php || :
fi

%post -n %name-apache2
%_sbindir/a2chkconfig >/dev/null
%post_service %apache2_dname
exit 0

%postun -n %name-apache2
%_sbindir/a2chkconfig >/dev/null
%post_service %apache2_dname
exit 0


%files

%files -n %name-common
%add_findreq_skiplist %_datadir/%name/config/LocalSettings.php
%_mediawikidir/
%exclude %_datadir/%name/maintenance/hiphop/
%attr(2750,root,%webserver_group) %dir %webappdir/
%attr(2770,root,%webserver_group) %dir %webappdir/config/
%attr(2770,root,%webserver_group) %dir %webappdir/config/LocalSettings.d/
%attr(2775,root,%webserver_group) %dir %webappdir/images/
%attr(2770,root,%webserver_group) %dir %webappdir/cache/
%webappdir/wiki/
%webappdir/images/*
%webappdir/config/AdminSettings.sample

%doc COPYING CREDITS FAQ HISTORY README RELEASE-NOTES-%major UPGRADE StartProfiler.sample
%doc README.ALT-ru_RU.UTF-8 README.UPGRADE.ALT-ru_RU.UTF-8 install_php_config.sh mediawiki.ini
%doc docs

%files -n %name-apache2
%config %apache2_mods_start/*.conf
%config %apache2_extra_available/*.conf
%config %apache2_extra_start/*.conf
%config(noreplace) %apache2_sites_available/*.conf

%files -n %name-mysql

%files -n %name-postgresql

#%files -n %name-hiphop
#%_datadir/%name/maintenance/hiphop/


%changelog
