%define ver_major 1.8

Name: meld
Version: %ver_major.1
Release: alt1

Summary: Meld Diff Viewer

License: %gpl2plus
Group: Text tools
Url: http://meld.sourceforge.net/

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildArch: noarch

%py_package_requires pygtk >= 2.8
%py_requires gtksourceview2 libglade
%add_python_req_skip misc

BuildPreReq: rpm-build-licenses
BuildPreReq: python-devel >= %__python_version
BuildPreReq: intltool scrollkeeper
BuildRequires: python-modules-encodings

%description
Meld is a visual diff and merge tool. It lets you compare two or three
files, and updates the comparisons while you edit them in-place. You
can also compare folders, launching comparisons of individual files as
desired. Last but by no means least, Meld lets you work with your
current changes in a wide variety of version control systems,
including Git, Bazaar, Mercurial, Subversion and CVS.

%prep
%setup

# fix prefix
subst s'|/usr/local|/usr|' INSTALL

# Misuse of localstatedir and the whole Scrollkeeper problem is a matter of
# http://bugzilla.gnome.org/show_bug.cgi?id=446157
%__subst "s:-scrollkeeper:#-scrollkeeper:" help/*/Makefile
%__subst "s:\$(localstatedir)/lib/:\$(localstatedir)/:" help/*/Makefile

%build
%make

%install
%make_install DESTDIR=%buildroot prefix=%_prefix install

%find_lang %name --with-gnome

%files -f %name.lang
%_bindir/%name
%dir %_datadir/%name
%_datadir/%name/*
%dir %_libexecdir/%name
%_libexecdir/%name/*
%_desktopdir/%name.desktop
%_datadir/mime/packages/%name.xml
%_iconsdir/hicolor/*/*/*
%_iconsdir/HighContrast/*/*/*
%_datadir/appdata/%name.appdata.xml
%doc NEWS

%changelog
