Name: memcached
Version: 1.4.13
Release: alt3

Summary: memcached - memory caching daemon
License: BSD
Group: System/Servers
Url: http://www.memcached.org/
# http://memcached.googlecode.com/files/%name-%version.tar.gz
Source: %name-%version.tar

%define pkg_user memcached
%define pkg_group memcached

BuildRequires: libevent-devel perl-devel perl-AnyEvent perl-YAML perl-Term-ReadKey

%description
memcached is a flexible memory object caching daemon designed to  alle-
viate  database  load in dynamic web applications by storing objects in
specifically  optimized  to  avoid swapping and always use non-blocking
I/O.

%package devel
Summary: Files needed for development using memcached protocol
Group: Development/C
BuildArch: noarch
Requires: %name = %version-%release

%description devel
This package contains files needed for development using memcached
protocol.

%package scripts
Summary: memcached auxiliary scripts
Group: Networking/Other
BuildArch: noarch
Requires: %name = %version-%release

%description scripts
This package contains auxiliary scripts for memcached.

%prep
%setup
sed -i 's,`git describe`,"%version-%release",g' version.pl
./autogen.sh

%build
%configure
%make_build

%install
mkdir -p %buildroot%_datadir/%name/scripts
%makeinstall_std
install -pD -m755 %name.init %buildroot%_initdir/%name
install -pD -m640 %name.sysconfig %buildroot/etc/sysconfig/%name
install -pm755 scripts/* %buildroot%_datadir/%name/scripts/
install -pD -m644 %name.service %buildroot/%systemd_unitdir/%name.service

%check
%make test

%pre
%_sbindir/groupadd -r -f %pkg_group
%_sbindir/useradd -r -g %pkg_group -d /dev/null -s /dev/null -n %pkg_user \
	2> /dev/null > /dev/null ||:
if [ $1 -eq 2 ] && [ ! -f /var/run/%name/%name.pid ] && [ -f /var/run/%name.pid ]; then
   mkdir /var/run/%name/
   mv /var/run/%name.pid /var/run/%name/%name.pid
fi

%post
%post_service %name

%preun
%preun_service %name

%files
%config(noreplace) %attr(640,root,adm) /etc/sysconfig/%name
%_bindir/%name
%_man1dir/*
%_initdir/*
%systemd_unitdir/%name.service
%doc AUTHORS doc/CONTRIBUTORS ChangeLog NEWS README doc/*.txt

%files devel
%_includedir/%name/

%files scripts
%_datadir/%name/
%exclude %_datadir/%name/scripts/memcached-init
%exclude %_datadir/%name/scripts/memcached.sysv

%changelog
