Name: memtest86+
Version: 4.20
Release: alt2.M70P.1

Summary: Memory test for x86 architecture
License: GPL
Group: System/Kernel and hardware

Url: http://www.memtest.org
Source: %url/download/%version/%name-%version.tar.gz
Packager: Michael Shigorin <mike@altlinux.org>

Patch0: memtest86p-4.20-suse-gcc4.7_fix.patch

ExclusiveArch: %ix86 x86_64
Requires(post,preun): bootloader-utils >= 0.3
BuildRequires: dev86

%description
Memtest86 is thorough, standalone memory test for x86 systems. It is
a standalone program and can be loaded from either a disk partition via
lilo or a floppy disk. Memtest86 uses a "moving inversions" algorithm
that is proven to be effective in finding memory errors.  The BIOS based
memory test is just a quick check that will often miss many of the
failures that are detected by Memtest86.

%description -l ru_RU.KOI8-R
      x86-,  
        LILO/GRUB,   .

   " ",  
    .    
"" BIOS:     ,    
  ,   memtest86.

      -.

%description -l uk_UA.KOI8-U
  Ԧ  'Ԧ  x86-,   
       LILO/GRUB,   
.

 դ  " Ӧ",  צ 
Φ  Φ Ħ  '.   
 "" BIOS: צ  Φ  ,    
 ϧ  ,   memtest86.

     ϧ
-.

%prep
%setup
%patch0 -p0

%build
%ifarch x86_64
%define stubarch -D__x86_64__ -D__LP64__
%else
%define stubarch %nil
%endif
make CC='gcc -fno-stack-protector -U_FORTIFY_SOURCE %stubarch' memtest.bin

%install
install -pDm644 memtest.bin %buildroot/boot/memtest-%version.bin
mkdir -p %buildroot%_sbindir
ln -s `relative /sbin/installkernel %_sbindir/installmemtest86+` \
	%buildroot%_sbindir/installmemtest86+

%post
%_sbindir/installmemtest86+ %version

%preun
%_sbindir/installmemtest86+ --remove %version

%files
/boot/memtest-%version.bin
%_sbindir/installmemtest86+
%doc README* FAQ

%changelog
