%define allname %name+sendfax
%define allconfdir %_sysconfdir/%allname
%define alllibdir %_libdir/%allname

Name: mgetty
Version: 1.1.37
Release: alt1.1

%define verdate Jun05

Summary: A getty replacement for use with data and fax modems
License: GPL
Group: Communications

Url: http://mgetty.greenie.net/
Source: ftp://mgetty.greenie.net/pub/%name/source/1.1/%name%version-%verdate.tar.gz
Source1: %name.logrotate
Source2: voice.conf-dist.bz2

Patch1: %name-1.1.5-config.patch
Patch2: %name-1.1.5-makekvg.patch
Patch3: %name-1.1.28-paths.patch
Patch4: %name-1.1.14-echo.patch
Patch5: %name-1.1.24-imakefile.patch
Patch6: %name-1.1.24-texinfo.patch
Patch7: %name-1.1.24-contrib.patch
#Patch8: %name-1.1.24-faxprint.patch
Patch9: %name-1.1.21-void.patch
Patch10: %name-1.1.30-paths.patch
Patch11: %name-1.1.26-elsa.patch
Patch12: %name-1.1.21-giftopnm.patch

Patch15: %name-1.1.25-usrvavaev.patch
Patch16: %name-1.1.26-logfile.patch
Patch17: %name-1.1.25-cid.patch.bz2
Patch18: %name-1.1.26-avc_cid.patch
patch19: %name-1.1.30.FAX_OUT_USER.patch
Patch20: %name-1.1.29-helper.patch
Patch21: %name-1.1.30-mktemp.patch
Patch22: %name-1.1.30-unioninit.new.patch
Patch30: %name-1.1.31-share-Makefile.patch
Patch31: %name-1.1.31-helper2.patch
Patch32: %name-1.1.31-no-acroread.patch
Patch33: %name-1.1.31-W-format.patch
Patch34: %name-1.1.31-policy.patch

Patch35: %name-alt-warnings.patch

# from gentoo
Patch40: mgetty-1.1.31-callback.patch
Patch41: mgetty-1.1.35-faxrunq.patch
Patch42: mgetty-1.1.35-strerror.patch

Packager: Fr. Br. George <george@altlinux.ru>

PreReq: /var/lock/serial

# Automatically added by buildreq on Tue Oct 06 2009
BuildRequires: gccmakedep groff-base imake libX11-devel libXext-devel xorg-cf-files
BuildRequires: texlive-base

%package sendfax
Summary: Provides support for sending faxes over a modem
Group: Communications
Requires: %name = %version-%release
Conflicts: efax

%package voice
Summary: A program for using your modem and %name as an answering machine
Group: Communications
Requires: %name = %version-%release

%package viewfax
Summary: An X Window System fax viewer
Group: Communications
Requires: %name = %version-%release

%package doc
Summary: Documentation, samples and contributed stuff that comes with %name
Group: Communications
Requires: %name = %version-%release
Obsoletes: %name-contrib
BuildArch: noarch

%description
The %name package contains a "smart" getty which allows logins over a
serial line (i.e., through a modem).  If you're using a Class 2 or 2.0
modem, %name can receive faxes.  If you also need to send faxes, you'll
need to install the sendfax program.

If you'll be dialing in to your system using a modem, you should install
the %name package.  If you'd like to send faxes using %name and your
modem, you'll need to install the %name-sendfax program.  If you need a
viewer for faxes, you'll also need to install the %name-viewfax package.

%description sendfax
Sendfax is a standalone backend program for sending fax files.  The
%name program (a getty replacement for handling logins over a serial
line) plus sendfax will allow you to send faxes through a Class 2 modem.

If you'd like to send faxes over a Class 2 modem, you'll need to install
the %name-sendfax and the %name packages.

%description voice
The %name-voice package contains the vgetty system, which enables
%name and your modem to support voice capabilities.  In simple terms,
vgetty lets your modem act as an answering machine.  How well the system
will work depends upon your modem, which may or may not be able to handle
this kind of implementation.

Install %name-voice along with %name if you'd like to try having your
modem act as an answering machine.

%description viewfax
Viewfax displays the fax files received using %name in an X11 window.
Viewfax is capable of zooming in and out on the displayed fax.

If you're installing the %name-viewfax package, you'll also need to
install %name.

%description doc
Documentation, samples and contributed stuff that comes with %name.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
#patch6 -p1
%patch7 -p1
#patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
#patch12 -p1

%patch15 -p1
%patch16 -p1
%patch17 -p1
%patch18 -p1
%patch19 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch30 -p1
%patch31 -p1
%patch32 -p1
%patch33 -p1
%patch34 -p1

%patch35 -p2

%patch40 -p1
#patch41 -p1
%patch42 -p1

cp policy.h-dist policy.h

find -type f -name Makefile\* |
	xargs fgrep -l '$(INSTALL)' |
	xargs -r perl -pi -e 's|(\$\(INSTALL\).*) -o [A-Za-z$(){}]*|$1|g;s|(\$\(INSTALL\).*) -g [A-Za-z$(){}]*|$1|g'
find -type f -name Makefile\* |
	xargs fgrep -l 'install' |
	xargs -r perl -pi -e 's|(install.*) -o [A-Za-z$(){}]*|$1|g;s|(install.*) -g [A-Za-z$(){}]*|$1|g'
find -type f |
	xargs fgrep -l /usr/local |
	xargs -r perl -pi -e 's,/usr/local,%prefix,g'
find -type f |
	xargs fgrep -l /perl5 |
	xargs -r perl -pi -e 's,/perl5,/perl,g'

%build
%make
%make -C voice
%make doc-all

pushd frontends/X11/viewfax
xmkmf
%make HELPDIR=%alllibdir CONFDIR=%allconfdir depend
%make CDEBUGFLAGS="%optflags" HELPDIR=%alllibdir CONFDIR=%allconfdir
popd

%install
%define instflags spool=%buildroot%_spooldir CONFDIR=%buildroot%allconfdir LIBDIR=%buildroot%alllibdir HELPDIR=%buildroot%alllibdir MANPATH=%buildroot%_mandir
mkdir -p %buildroot{/sbin,%alllibdir,%_man1dir}
mkdir -p %buildroot%_spooldir/voice/{messages,incoming}
%makeinstall %instflags
mv %buildroot%_sbindir/%name %buildroot/sbin
ln -s ../../sbin/%name %buildroot%_sbindir

# Voice mail extensions
%makeinstall %instflags SBINDIR=%buildroot/sbin -C voice

%makeinstall %instflags MANPATH=%buildroot%_x11mandir BINDIR=%buildroot%_x11bindir -C frontends/X11/viewfax install install.man

install -pDm640 %SOURCE1 %buildroot%_sysconfdir/logrotate.d/%name
install -pm700 callback/callback %buildroot%_sbindir
install -pm755 callback/ct %buildroot%_bindir

# This conflicts with efax
mv %buildroot%_man1dir/fax.1 %buildroot%_man1dir/%{name}_fax.1

bzcat %SOURCE2 >%buildroot%allconfdir/voice.conf
chmod 0600 %buildroot%allconfdir/voice.conf

mkdir -p %buildroot/var/log/%name

# Don't ship documentation that is executable.
find samples -type f |xargs chmod a-x

%files
/sbin/%name
%_sbindir/%name
%_man8dir/%name.8*
%_man8dir/callback.8*
%_man8dir/faxrunqd.8*
#_man8dir/vgetty.8*
%_man4dir/*
%_infodir/*.info*
%dir %allconfdir
%config(noreplace) %allconfdir/login.config
%config(noreplace) %allconfdir/%name.config
%config(noreplace) %allconfdir/dialin.config
%config(noreplace) %_sysconfdir/logrotate.d/%name
%_logdir/%name

%files sendfax
%_spooldir/fax
%_bindir/kvg
%_bindir/newslock
%_bindir/g3cat
%_bindir/sff2g3
%_bindir/g32pbm
#_bindir/g3topbm	# /*G*/ conflicts with netpm
%_bindir/pbm2g3
%_bindir/faxspool
%_bindir/faxrunq
%_bindir/faxq
%_bindir/cutbl
%_bindir/faxrm
%_bindir/ct
%_sbindir/sendfax
%_sbindir/faxrunqd
%_sbindir/callback
%dir %alllibdir
%alllibdir/faxq-helper
%alllibdir/*.pbm
%_man1dir/g32pbm.*
%_man1dir/pbm2g3.*
%_man1dir/sff2g3.*
%_man1dir/g3cat.*
%_man1dir/%{name}_fax.*
%_man1dir/faxspool.*
%_man1dir/faxrunq.*
%_man1dir/faxq.*
%_man1dir/faxrm.*
%_man1dir/coverpg.*
%_man5dir/faxqueue.*
%_man8dir/sendfax.*
%_man8dir/faxq-helper.*
%config(noreplace) %allconfdir/sendfax.config
%config(noreplace) %allconfdir/faxrunq.config
%config(noreplace) %allconfdir/faxheader
%config(noreplace) %allconfdir/faxspool.rules.sample

%files voice
%_spooldir/voice
/sbin/vgetty
%_bindir/vm
%_bindir/pvfamp
%_bindir/pvfcut
%_bindir/pvfecho
%_bindir/pvffile
%_bindir/pvffilter
%_bindir/pvfnoise
%_bindir/pvffft
%_bindir/pvfmix
%_bindir/pvfreverse
%_bindir/pvfsine
%_bindir/pvfspeed
%_bindir/pvftormd
%_bindir/rmdtopvf
%_bindir/rmdfile
%_bindir/pvftovoc
%_bindir/voctopvf
%_bindir/pvftolin
%_bindir/lintopvf
%_bindir/pvftobasic
%_bindir/basictopvf
%_bindir/pvftoau
%_bindir/autopvf
%_bindir/pvftowav
%_bindir/wavtopvf
%_man1dir/zplay.*
%_man1dir/pvf.*
%_man1dir/pvfamp.*
%_man1dir/pvfcut.*
%_man1dir/pvfecho.*
%_man1dir/pvffile.*
%_man1dir/pvffilter.*
%_man1dir/pvffft.*
%_man1dir/pvfmix.*
%_man1dir/pvfnoise.*
%_man1dir/pvfreverse.*
%_man1dir/pvfsine.*
%_man1dir/pvfspeed.*
%_man1dir/pvftormd.*
%_man1dir/rmdtopvf.*
%_man1dir/rmdfile.*
%_man1dir/pvftovoc.*
%_man1dir/voctopvf.*
%_man1dir/pvftolin.*
%_man1dir/lintopvf.*
%_man1dir/pvftobasic.*
%_man1dir/basictopvf.*
%_man1dir/pvftoau.*
%_man1dir/autopvf.*
%_man1dir/pvftowav.*
%_man1dir/wavtopvf.*
%_man8dir/vgetty.*
%config(noreplace) %allconfdir/voice.conf

%files viewfax
%_bindir/viewfax
%_man1dir/viewfax.*
%dir %alllibdir
%alllibdir/viewfax.tif
%doc frontends/X11/viewfax/{ChangeLog,README}

%files doc
%doc BUGS ChangeLog FTP THANKS TODO Recommend README.CID
%doc doc/{modems.db,*.ps,*.txt,fhng-codes}
%doc samples contrib

#
# TODO:
# - Update or remove patches:
#   o mgetty-1.1.24-texinfo.patch
#   o mgetty-1.1.24-faxprint.patch
# - Consider Gentoo patches

%changelog
