Name: mingw32-binutils
Version: 2.19.51.0.14
Release: alt1.1.qa1
Summary: MinGW Windows binutils

License: GPLv2+ and LGPLv2+ and GPLv3+ and LGPLv3+
Group: Development/Other
Url: http://www.gnu.org/software/binutils/
Packager: Boris Savelev <boris@altlinux.org>

Source: http://ftp.gnu.org/gnu/binutils/binutils-%version.tar.bz2

BuildRequires: flex
BuildRequires: bison
BuildRequires: texinfo
BuildRequires: rpm-macros-mingw32

# NB: This must be left in.
Requires: mingw32-filesystem
BuildRequires: perl-podlators

%description
MinGW Windows binutils (utilities like 'strip', 'as', 'ld') which
understand Windows executables and DLLs.

%prep
%setup -q -n binutils-%version

find -type f -name \*.orig -delete

sed -i 's/%%{release}/%release/g' bfd/Makefile{.am,.in}

# Fix build with glibc-devel >= 2.10
sed -i s/getline/get_line/g libiberty/testsuite/test-demangle.c

%build
# without -O0 gnu as doesnt works
%configure \
	CFLAGS="%optflags -O0" \
	--target=%_mingw32_target \
	--verbose --disable-nls \
	--with-included-gettext \
	--disable-win32-registry \
	--disable-werror \
	--with-sysroot=%_mingw32_sysroot \
	--with-bugurl=http://bugzilla.altlinux.org/

%make_build

%install
%makeinstall_std
# These files conflict with ordinary binutils.
rm -rf %buildroot%_infodir
rm -f %buildroot%_libdir/libiberty*
ln -sf ../../..%_bindir/%_mingw32_target-windres \
%buildroot%prefix/%_mingw32_target/bin/windres
ln -sf ../../..%_bindir/%_mingw32_target-dllwrap \
%buildroot%prefix/%_mingw32_target/bin/dllwrap

%files
%_man1dir/*
%_bindir/%_mingw32_target-*
%prefix/%_mingw32_target/bin
%prefix/%_mingw32_target/lib/ldscripts

%changelog
