%global __strip %_mingw32_strip
%global __objdump %_mingw32_objdump

Name: mingw32-glib2
Version: 2.33.1
Release: alt1

Summary: MinGW Windows GLib2 library

License: LGPLv2+
Group: Development/Other
Url: http://www.gtk.org

# first two digits of version
%define release_version %(echo %version | awk -F. '{print $1"."$2}')

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://download.gnome.org/sources/glib/%release_version/glib-%version.tar

BuildArch: noarch

%add_python_req_skip gdb

# Automatically added by buildreq on Mon Jun 25 2012
# optimized out: glib2-devel mingw32-binutils mingw32-cpp mingw32-expat mingw32-gcc mingw32-gettext mingw32-iconv mingw32-libjpeg mingw32-libpng mingw32-libtiff mingw32-pthreads mingw32-runtime mingw32-termcap mingw32-w32api mingw32-zlib pkg-config python-base python-devel python-module-distribute python-module-zope python-modules python-modules-xml xml-utils
BuildRequires: dbus gtk-doc indent libgdk-pixbuf-devel mingw32-dlfcn mingw32-gcc-c++ mingw32-gettext-static mingw32-libffi mingw32-libxml2 mingw32-wxGTK python-module-PyXML python-module-mwlib

BuildRequires: rpm-build-mingw32

BuildRequires: mingw32-filesystem >= 52
BuildRequires: mingw32-gcc
BuildRequires: mingw32-binutils
BuildRequires: mingw32-dlfcn
BuildRequires: mingw32-iconv
BuildRequires: mingw32-gettext
BuildRequires: mingw32-zlib

BuildRequires: pkg-config
# Native version required for msgfmt use in build
BuildRequires: gettext
# Native version required for glib-genmarshal
BuildRequires: glib2-devel

Requires: pkg-config

# As we're using libproxy-intl the libintl-8.dll dependency is a soft one
# To compile applications against glib2 we need to have gettext installed
# for it's headers
Requires: mingw32-gettext

%description
MinGW Windows Glib2 library.

%prep
%setup -n glib-%version

%build
%_mingw32_configure --disable-static
        # HACK
        cp glib/glibconfig.h ../glib
%make_build

%install
%makeinstall_std

# Manually merge the libtool files
#__subst s/"old_library=''"/"old_library='libgio-2.0.a'"/ %buildroot%_mingw32_libdir/libgio-2.0.la
#__subst s/"old_library=''"/"old_library='libglib-2.0.a'"/ %buildroot%_mingw32_libdir/libglib-2.0.la
#__subst s/"old_library=''"/"old_library='libgobject-2.0.a'"/ %buildroot%_mingw32_libdir/libgobject-2.0.la
#__subst s/"old_library=''"/"old_library='libgmodule-2.0.a'"/ %buildroot%_mingw32_libdir/libgmodule-2.0.la
#__subst s/"old_library=''"/"old_library='libgthread-2.0.a'"/ %buildroot%_mingw32_libdir/libgthread-2.0.la

rm -f %buildroot%_mingw32_libdir/charset.alias

# Drop the GDB helper files as we can't use the native Fedora GDB to debug Win32 programs
rm -rf %buildroot%_mingw32_datadir/gdb

# Remove the gtk-doc documentation and manpages which duplicate Fedora native
rm -rf %buildroot%_mingw32_mandir
rm -rf %buildroot%_mingw32_datadir/gtk-doc

# Bash-completion files aren't interesting for mingw32
rm -rf %buildroot%_mingw32_sysconfdir/bash_completion.d

# The .def files are also of no use to other binaries
rm -f %buildroot%_mingw32_libdir/*.def

# The gdbus-codegen pieces are already in the native glib2 package
rm -f %buildroot%_mingw32_bindir/gdbus-codegen
rm -rf %buildroot%_mingw32_libdir/gdbus-2.0

%find_lang glib20

%files -f glib20.lang
%_mingw32_bindir/gdbus.exe
%_mingw32_bindir/glib-compile-schemas.exe
%_mingw32_bindir/glib-compile-resources.exe
%_mingw32_bindir/glib-genmarshal.exe
%_mingw32_bindir/glib-gettextize
%_mingw32_bindir/glib-mkenums
%_mingw32_bindir/gobject-query.exe
%_mingw32_bindir/gio-querymodules.exe
%_mingw32_bindir/gsettings.exe
%_mingw32_bindir/gresource.exe
%_mingw32_bindir/gspawn-win32-helper-console.exe
%_mingw32_bindir/gspawn-win32-helper.exe
%_mingw32_bindir/libgio-2.0-0.dll
%_mingw32_bindir/libglib-2.0-0.dll
%_mingw32_bindir/libgmodule-2.0-0.dll
%_mingw32_bindir/libgobject-2.0-0.dll
%_mingw32_bindir/libgthread-2.0-0.dll
%_mingw32_includedir/glib-2.0/
%_mingw32_includedir/gio-win32-2.0/
%_mingw32_libdir/glib-2.0/
%dir %_mingw32_libdir/gio/
%dir %_mingw32_libdir/gio/modules/
%_mingw32_libdir/libgio-2.0.dll.a
%_mingw32_libdir/libgio-2.0.la
%_mingw32_libdir/libglib-2.0.dll.a
%_mingw32_libdir/libglib-2.0.la
%_mingw32_libdir/libgmodule-2.0.dll.a
%_mingw32_libdir/libgmodule-2.0.la
%_mingw32_libdir/libgobject-2.0.dll.a
%_mingw32_libdir/libgobject-2.0.la
%_mingw32_libdir/libgthread-2.0.dll.a
%_mingw32_libdir/libgthread-2.0.la
%_mingw32_libdir/pkgconfig/gio-2.0.pc
%_mingw32_libdir/pkgconfig/gio-windows-2.0.pc
%_mingw32_libdir/pkgconfig/glib-2.0.pc
%_mingw32_libdir/pkgconfig/gmodule-2.0.pc
%_mingw32_libdir/pkgconfig/gmodule-export-2.0.pc
%_mingw32_libdir/pkgconfig/gmodule-no-export-2.0.pc
%_mingw32_libdir/pkgconfig/gobject-2.0.pc
%_mingw32_libdir/pkgconfig/gthread-2.0.pc
%_mingw32_datadir/aclocal/glib-2.0.m4
%_mingw32_datadir/aclocal/glib-gettext.m4
%_mingw32_datadir/aclocal/gsettings.m4
%_mingw32_datadir/glib-2.0/

%if 0
%files static
%_mingw32_libdir/libgio-2.0.a
%_mingw32_libdir/libglib-2.0.a
%_mingw32_libdir/libgmodule-2.0.a
%_mingw32_libdir/libgobject-2.0.a
%_mingw32_libdir/libgthread-2.0.a
%endif

%changelog
