Name: mingw32-iconv
Version: 1.12
Release: alt2
Summary: GNU libraries and utilities for character set conversion

License: GPLv2+ and LGPLv2+
Group: System/Libraries
Url: http://www.gnu.org/software/libiconv/
Packager: Boris Savelev <boris@altlinux.org>

Source: http://ftp.gnu.org/pub/gnu/libiconv/libiconv-%version.tar.gz
BuildArch: noarch

BuildRequires: rpm-build-mingw32
BuildRequires: mingw32-gcc
BuildRequires: mingw32-binutils

# There's a quasi-circular dependency between mingw32-iconv and
# mingw32-gettext.  If gettext is installed when you build this then
# iconv will create *.mo files.  When this package is added to Fedora
# we can consider adding this circular dep:
BuildRequires: mingw32-gettext

%description
MinGW Windows Iconv library

%package static
Summary: Static version of the MinGW Windows Iconv library
Requires: %name = %version-%release
Group: System/Libraries

%description static
Static version of the MinGW Windows Iconv library.

%prep
%setup -q -n libiconv-%version

%build
%_mingw32_configure --enable-static --enable-shared
%make_build

%install
%makeinstall_std
# Remove documentation which duplicates what is already in
# Fedora native packages.
rm -rf %buildroot%_mingw32_docdir/libiconv/
rm -rf %buildroot%_mingw32_mandir

# If mingw32-gettext was installed during the build, remove the *.mo
# files.  If mingw32-gettext wasn't installed then there won't be any.
rm -rf %buildroot%_mingw32_datadir/locale

%files
%doc COPYING COPYING.LIB
%_mingw32_bindir/iconv
%_mingw32_bindir/libcharset-1.dll
%_mingw32_bindir/libiconv-2.dll
%_mingw32_includedir/iconv.h
%_mingw32_includedir/libcharset.h
%_mingw32_includedir/localcharset.h
%_mingw32_libdir/charset.alias
%_mingw32_libdir/libcharset.dll.a
%_mingw32_libdir/libcharset.la
%_mingw32_libdir/libiconv.dll.a
%_mingw32_libdir/libiconv.la

%files static
%_mingw32_libdir/libcharset.a
%_mingw32_libdir/libiconv.a

%changelog
