# Define this to run tests (requires Wine, and won't work inside mock or Koji).
# Note: As of libtool-1.5.26, libltdl does not contain any tests at all.
%define run_tests 0

Summary: Runtime libraries for GNU Libtool Dynamic Module Loader
Name: mingw32-libltdl
Version: 1.5.26
Release: alt1
Group: System/Libraries
# Even though the source package contains files under
# "GPLv2+ and LGPLv2+ and GFDL", the binary RPM only ships LGPLv2+ code.
License: LGPLv2+
Group: Development/Tools

Packager: Boris Savelev <boris@altlinux.org>

Source: http://ftp.gnu.org/gnu/libtool/libtool-%version.tar.gz
Url: http://www.gnu.org/software/libtool/

# don't  read .la file in current working directory, root might get tricked
# into running a prepared binary in that directory:
Patch2: libtool-1.5.24-relativepath.patch

BuildRequires: rpm-build-mingw32
BuildRequires: mingw32-binutils
BuildRequires: mingw32-gcc

%if %run_tests
BuildRequires: wine
%endif

BuildArch: noarch

%description
The mingw32-libltdl package contains the GNU Libtool Dynamic Module Loader, a
library that provides a consistent, portable interface which simplifies the
process of using dynamic modules, for the mingw32 cross compilation
environment.

These runtime libraries are needed by programs that link directly to the
system-installed ltdl libraries; they are not needed by software built using
the rest of the GNU Autotools (including GNU Autoconf and GNU Automake).

%prep
%setup -n libtool-%version -q
%patch2 -p1

%build
export PATH=%_mingw32_bindir:$PATH

#./bootstrap

cd libltdl
export CXX=false
export F77=false
export CFLAGS="$RPM_OPT_FLAGS -fPIC"
# dumb redhat-rpm-config replaces config.{sub,guess} with ancient ones in %%configure, use ./configure instead:
# %%_mingw32_configure does not make that error :)
%_mingw32_configure --enable-shared
# build not smp safe:
make

%check
%if %run_tests
cd libltdl
make check VERBOSE=yes > make_check.log 2>&1 || (cat make_check.log && false)
%endif

%install
cd libltdl
%makeinstall_std
rm -f %buildroot%_mingw32_libdir/libltdl.a

%files
%doc AUTHORS NEWS THANKS TODO ChangeLog
%doc libltdl/COPYING.LIB libltdl/README
%_mingw32_libdir/libltdl.dll.a
%_mingw32_bindir/libltdl-3.dll
%_mingw32_libdir/libltdl.la
%_mingw32_includedir/ltdl.h

%changelog
