%define oname nspr

Name: mingw32-libnspr

Version: 4.8.7
Release: alt1

Summary: Netscape Portable Runtime (NSPR)

License: MPL/GPL/LGPL
Group: System/Libraries
Url: http://www.mozilla.org/projects/nspr/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: https://ftp.mozilla.org/pub/mozilla.org/nspr/releases/v%version/src/%oname-%version.tar

Patch1: nspr-pkgconfig.patch
Patch2: nspr-threads.patch

BuildArch: noarch

# MinGW-specific build patch.
Patch1000: nspr-4.8.6-build.patch

BuildRequires: rpm-build-mingw32
BuildRequires: mingw32-runtime >= 3.15.1
BuildRequires: mingw32-gcc
BuildRequires: mingw32-gcc-c++
BuildRequires: mingw32-binutils

%description
Netscape Portable Runtime (NSPR) provides a platform-neutral API for system level and libc like functions.
The API is used in the Mozilla client, many of Netscape/AOL/iPlanet's and other software offerings.

%package devel
Summary: NSPR development kit
Group: Development/Other
# do not required
#Requires: %name = %version-%release

%description devel
NSPR development kit

%prep
%setup -n %oname-%version

%patch1 -p1

pushd mozilla/nsprpub
%patch2 -p0 -b .threads
%patch1000 -p0 -b .build
popd

%__subst \
	's@AC_CONFIG_AUX_DIR(\${srcdir}/build/autoconf)@AC_CONFIG_AUX_DIR(build/autoconf)@' \
	mozilla/nsprpub/configure.in

# Hack again incorrect behaviour
%__subst 's|NSINSTALL=nsinstall||g' mozilla/nsprpub/configure*

# _InterlockedIncrement provided only MSVC compiler
%__subst "s|_WIN32|_WIN32_ONLY_WINDOWS|g" mozilla/nsprpub/pr/include/pratom.h

%build
cd mozilla/nsprpub
%add_optflags %optflags_shared
HOST_CFLAGS=-D_WIN32 %_mingw32_configure \
	--includedir=%_mingw32_includedir/%oname \
	--with-mozilla \
%ifarch x86_64
	--enable-64bit \
%endif
	--enable-optimize="%_mingw32_cflags" \
	--enable-win32-target=WINNT \
	--enable-shared --enable-static \
	--enable-debug --disable-strip \
	--enable-64bit=no \
	--enable-mdupdate \
	--with-pthreads \
	--disable-cplus \
	#

# NSPR comes with its own "special" install program called nsinstall.
# This must be built as a native program.
%make -C config CC=gcc CFLAGS="-DXP_UNIX=1"

%make_build

%install
cd mozilla/nsprpub
#makeinstall install export \
#	RANLIB=%_mingw32_ranlib \
#	RC=%_mingw32_windres \
#	includedir=%buildroot/%_includedir/%name

# 'make install' doesn't appear to work, so do it by hand.
mkdir -p %buildroot%_mingw32_bindir
mkdir -p %buildroot%_mingw32_libdir/pkgconfig
install dist/bin/*.dll %buildroot%_mingw32_bindir/
install dist/lib/nspr4_s.a %buildroot%_mingw32_libdir/libnspr4.a
install dist/lib/plc4_s.a %buildroot%_mingw32_libdir/libplc4.a
install dist/lib/plds4_s.a %buildroot%_mingw32_libdir/libplds4.a
install dist/lib/nspr4.dll.a %buildroot%_mingw32_libdir/libnspr4.dll.a
install dist/lib/plc4.dll.a %buildroot%_mingw32_libdir/libplc4.dll.a
install dist/lib/plds4.dll.a %buildroot%_mingw32_libdir/libplds4.dll.a
install config/nspr-config %buildroot%_mingw32_bindir
install -m644 config/nspr.pc %buildroot%_mingw32_libdir/pkgconfig/
#install dist/lib/*.dll.a %buildroot%_mingw32_libdir/

mkdir -p %buildroot%_mingw32_includedir/nspr
cp -rL dist/include/nspr/* %buildroot%_mingw32_includedir/nspr/
# #include "file.h" -> #include <nspr/file.h>
find %buildroot/%_includedir/nspr -type f -name '*.h' -print0 |
    xargs -r0 sed -i -e 's@^\([[:space:]]*#include[[:space:]]\+\)"\([^"]\+\)"@\1<nspr/\2>@g'


%files
%_mingw32_bindir/nspr4.dll
%_mingw32_bindir/plc4.dll
%_mingw32_bindir/plds4.dll

%files devel
%_mingw32_bindir/nspr-config
%_mingw32_libdir/libnspr4.a
%_mingw32_libdir/libplc4.a
%_mingw32_libdir/libplds4.a
%_mingw32_libdir/libnspr4.dll.a
%_mingw32_libdir/libplc4.dll.a
%_mingw32_libdir/libplds4.dll.a
%_mingw32_libdir/pkgconfig/nspr.pc
%_mingw32_includedir/nspr/

#_datadir/%name-%version
#_datadir/aclocal/*

#%files -n lib%name-devel-static
#%_libdir/*.a

%changelog
