Name: mingw32-libxml2
Version: 2.7.6
Release: alt1

Summary: MinGW Windows libxml2 XML processing library

License: MIT
Group: System/Libraries
Url: http://xmlsoft.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: ftp://xmlsoft.org/libxml2/libxml2-%version.tar

# Not required for MinGW.
#Patch:         libxml2-multilib.patch

# MinGW-specific patches.
Patch1000: mingw32-libxml2-2.7.2-with-modules.patch
Patch1001: mingw32-libxml2-static-build-compile-fix.patch
Patch1002: libxml2-gnome-bug-561340-fix.patch

BuildArch: noarch

BuildRequires: rpm-build-mingw32
BuildRequires: mingw32-runtime >= 3.15.1
BuildRequires: mingw32-gcc
BuildRequires: mingw32-gcc-c++
BuildRequires: mingw32-binutils
BuildRequires: mingw32-iconv
BuildRequires: mingw32-termcap >= 1.3.1-3

BuildRequires: mingw32-dlfcn
BuildRequires: mingw32-gettext
BuildRequires: mingw32-iconv
BuildRequires: mingw32-zlib

%description
MinGW Windows libxml2 XML processing library.

%package static
Summary: Static version of the MinGW Windows XML processing library
Requires: %name = %version-%release
Group: Development/C

%description static
Static version of the MinGW Windows XML processing library.

%prep
%setup -n libxml2-%version

%patch1000 -p1
%patch1001 -p0
%patch1002 -p0

# Patched configure.in, so rebuild configure.
#libtoolize --force --copy
#autoreconf

%build
%autoreconf
# LibXML2 can't build static and shared libraries in one go, so we
# build LibXML2 twice here
mkdir build_static
pushd build_static
    LDFLAGS="-no-undefined" \
%_mingw32_configure --without-python --with-modules --enable-static --disable-shared --with-threads=win32 CFLAGS="$CFLAGS -DLIBXML_STATIC_FOR_DLL"
    %make_build
popd

mkdir build_shared
pushd build_shared
    LDFLAGS="-no-undefined" \
%_mingw32_configure --without-python --with-modules --disable-static --enable-shared --with-threads=win32
    %make_build
popd

%install
# First install all the files belonging to the shared build
make -C build_shared DESTDIR=%buildroot install

# Install all the files from the static build in a seperate folder
# and move the static libraries to the right location
make -C build_static DESTDIR=%buildroot/build_static install
mv %buildroot/build_static%_mingw32_libdir/*.a %buildroot%_mingw32_libdir

# Manually merge the libtool files
sed -i s/"old_library=''"/"old_library='libxml2.a'"/ %buildroot%_mingw32_libdir/libxml2.la

# Drop the folder which was temporary used for installing the static bits
rm -rf %buildroot/build_static

# Remove manpages which duplicate Fedora native.
rm -rf %buildroot%_mingw32_mandir

%files
%_mingw32_bindir/libxml2-2.dll
%_mingw32_bindir/xml2-config
%_mingw32_bindir/xmlcatalog.exe
%_mingw32_bindir/xmllint.exe
%_mingw32_libdir/libxml2.dll.a
%_mingw32_libdir/libxml2.la
%_mingw32_libdir/pkgconfig/libxml-2.0.pc
%_mingw32_libdir/xml2Conf.sh
%_mingw32_includedir/libxml2/
%_mingw32_datadir/aclocal/*
%_mingw32_docdir/libxml2-%version/
%_mingw32_datadir/gtk-doc/html/libxml2/

%files static
%_mingw32_libdir/libxml2.a

%changelog
