%define __strip %_mingw32_strip
%define __objdump %_mingw32_objdump

Name: mingw32-zlib
Version: 1.2.3
Release: alt1
Summary: MinGW Windows zlib compression library

License: zlib
Group: System/Libraries
Url: http://www.zlib.net/
Packager: Boris Savelev <boris@altlinux.org>

Source: http://www.zlib.net/zlib-%version.tar.gz
Patch3: zlib-1.2.3-autotools.patch
Patch6: minizip-1.2.3-malloc.patch
BuildArch: noarch

# MinGW-specific patches.
Patch100: zlib-win32.patch

BuildRequires: rpm-build-mingw32
BuildRequires: mingw32-gcc
BuildRequires: mingw32-binutils

%description
MinGW Windows zlib compression library.

%package static
Summary: Static libraries for mingw32-zlib development
Group: System/Libraries
Requires: mingw32-zlib = %version-%release

%description static
The mingw32-zlib-static package contains static library for mingw32-zlib development.

%package -n mingw32-minizip
Summary: Minizip manipulates files from a .zip archive
Group: System/Libraries
Requires: mingw32-zlib = %version-%release

%description -n  mingw32-minizip
MinGW Minizip manipulates files from a .zip archive.

%prep
%setup -q -n zlib-%version
%patch100 -p1
cd ..
cp -a zlib-%version x
mv x zlib-%version
cd zlib-%version
%patch3 -p1 -b .atools
# patch cannot create an empty dir
mkdir m4
%patch6 -p1 -b .mal
iconv -f windows-1252 -t utf-8 <ChangeLog >ChangeLog.tmp
mv ChangeLog.tmp ChangeLog
cp Makefile Makefile.old

%build
pushd x
CC=%_mingw32_cc \
CFLAGS="%_mingw32_cflags" \
RANLIB=%_mingw32_ranlib \
./configure

make -f win32/Makefile.gcc \
  CFLAGS="%_mingw32_cflags" \
  CC=%_mingw32_cc \
  AR=%_mingw32_ar \
  RC=%_mingw32_target-windres \
  DLLWRAP=%_mingw32_target-dllwrap \
  STRIP=%_mingw32_strip \
  all
popd

autoreconf --install;
%_mingw32_configure
%make_build libz.la
perl -i -pe 's,libz-1.dll,zlib1.dll,' libz.la
rm -f libz.dll.a
cp x/libzdll.a libz.dll.a
cp x/zlib1.dll .
rm -f .libs/libz.dll.a
cp x/libzdll.a .libs/libz.dll.a
cp x/zlib1.dll .libs/
%make_build

%install
%makeinstall_std

rm -rf %buildroot%_mingw32_mandir

rm -f %buildroot%_mingw32_bindir/libz-1.dll
install x/zlib1.dll %buildroot%_mingw32_bindir/

%files
%_mingw32_includedir/zconf.h
%_mingw32_includedir/zlib.h
%_mingw32_libdir/libz.dll.a
%_mingw32_bindir/zlib1.dll
%_mingw32_libdir/libz.la

%files static
%_mingw32_libdir/libz.a

%files -n mingw32-minizip
%doc contrib/minizip/ChangeLogUnzip
%_mingw32_libdir/libminizip.dll.a
%_mingw32_libdir/libminizip.la
%_mingw32_bindir/libminizip-1.dll
%dir %_mingw32_includedir/minizip
%_mingw32_includedir/minizip/*.h
%_mingw32_libdir/pkgconfig/minizip.pc

%changelog
