%define my_lockdir /var/lock/serial
%define my_group uucp

Name: minicom
Version: 2.5
Release: alt1.hg.qa1

Group: Communications
Summary: A text-menu-driven modem control and terminal emulation program
License: GPL
Url: http://alioth.debian.org/projects/minicom/

# old cvs:
#  git cvsimport -o upstream -v -d :pserver:anonymous@cvs.alioth.debian.org:/cvsroot/minicom minicom
# new hg repo:
#  hg clone https://alioth.debian.org/anonscm/hg/minicom/minicom
Source: %name-%version.tar
Source1: %name.sh
Source2: %name.csh
Source4: %name.admin
Source5: %name.admin.ru
Source6: %name.xpm
Source7: %name-xstart.sh
Source9: %name.FAQ.ru

# Without this dependency it would be difficult to find the package with file-transfer tools
Requires: lrzsz

# added because autopoint requires it. crap.
BuildRequires: cvs

# I add the specialization of the BuildRequires:
BuildRequires: bison libtinfo-devel

# The access to serial ports should be controlled through '%my_group'
# group. It is provided by the new setup pkg.
# We need it before this package (minicom) is installed in order
# to set right permissions on files.
# Also, we need the place to create lockfiles. It should be
# provided by te new FS pkg.
PreReq: %my_lockdir

%description
Minicom is a simple modem control and terminal emulation program 
that resembles MS-DOS Telix somewhat.  It is driven by text-based menus,
has a dialing directory, full ANSI and VT100 emulation, an (external)
scripting language, and other features.

Minicom should be installed if you need a simple modem control program
or terminal emulator. It can be used for remote access (in a terminal)
and to test and configure your modem.

%prep
%setup

%build
%autoreconf
%configure \
	--enable-lock-dir=%my_lockdir \
	--enable-dfl-port=/dev/modem
%make_build

%install
%makeinstall

dest=%buildroot%_sysconfdir/profile.d
mkdir -p $dest
install -p %SOURCE1 $dest/%name.sh
install -p %SOURCE2 $dest/%name.csh
unset dest

for f in minirc.dfl; do
  mv {doc,%buildroot%_sysconfdir}/$f
done
install -p -m644 %SOURCE4 %name.admin
install -p -m644 %SOURCE5 %name.admin.ru
install -p -m644 %SOURCE9 %name.FAQ.ru

%find_lang %name

# Preparing the docs:
find extras doc -name 'Makefile*' -print0 |
	xargs -r0 rm -f --

# The icon (from Caldera)
install -pD -m644 %SOURCE6 %buildroot%_liconsdir/%name.xpm

# The script to start minicom in an X terminal
install -pD -m755 %SOURCE7 %buildroot%_libdir/%name/xstart

# menu
mkdir -p %buildroot%_desktopdir
cat > %buildroot%_desktopdir/%{name}.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=%name
Comment=Terminal Emulator (for modem/other serial lines)
Icon=%{name}
Exec=/usr/lib/minicom/xstart
Terminal=true
Categories=Network;Dialup;
EOF

%files -f %name.lang
%attr(640,root,%my_group) %config(noreplace) %_sysconfdir/minirc.dfl
%attr(755,root,root) %config %_sysconfdir/profile.d/%name.sh
%attr(755,root,root) %config %_sysconfdir/profile.d/%name.csh
%_bindir/*
%_mandir/man?/*

%_desktopdir/%{name}.desktop
%_liconsdir/*

%dir %_libdir/%name
%attr(755,root,root) %_libdir/%name/xstart

%doc doc extras
%doc %name.admin
%lang(ru) %doc %name.admin.ru
%lang(ru) %doc %name.FAQ.ru

%changelog
