Name: mkimage-profiles
Version: 1.0.6
Release: alt0.M70T.1

Summary: ALT Linux based distribution metaprofile
License: GPLv2+
Group: Development/Other

Url: http://www.altlinux.org/Mkimage/Profiles/m-p
Source: %name-%version.tar
Packager: Michael Shigorin <mike@altlinux.org>

BuildArch: noarch
BuildRequires: rsync asciidoc-a2x xmlgraphics-fop fonts-ttf-dejavu
BuildRequires: /proc

Requires: rsync git-core
Requires: time schedutils sfdisk
Requires: mkimage >= 0.2.12

# Recommends: graphviz qemu-img

%define mpdir %_datadir/%name
%add_findreq_skiplist %mpdir/*.in/*

%define docs $HOME/docs

%package doc
Summary: %name documentation
Group: Development/Documentation

%description
mkimage-profiles is a collection of bits and pieces useful for
distributions construction: it contains package lists, features,
and whole subprofiles (like "rescue" building block) for you
to choose from, and some ready-made image recipes as well.

Make no mistake: constructing distributions isn't just fun, it takes
a lot of passion and knowledge to produce a non-trivial one.  So m-p
(the short nick for mkimage-profiles) is complex too.  If you need
-- or want -- to make just a few tweaks to an existing recipe, it might
be easier to comprehend the generated profile (aka builddir) which
contains only the needed subprofiles, script hooks and package lists
and is way more compact.

Virtual environment template caches (OpenVZ/LXC) can be made either.

In short, setup hasher (http://en.altlinux.org/hasher) and here we go:
  cd %mpdir
  head README
  make syslinux.iso

But if you're into regular distro hacking and are not afraid of make
and modest metaprogramming (some code generation and introspection),
welcome to the metaprofile itself; read the docs and get the git:
%url

%description doc
This package holds developer docs for %name
as a book in HTML and PDF formats.

%prep
%setup

%build
make BUILDDIR=%docs docs

%install
mkdir -p %buildroot%mpdir
cp -a * %buildroot%mpdir

%files
%mpdir/

%files doc
%doc README
%doc QUICKSTART
%doc %docs/*

%changelog
