Name: mkinitrd
Version: 3.0.22
Release: alt1
Epoch: 1
Summary: Creates an initial ramdisk image for preloading modules
License: GPL
Group: System/Kernel and hardware
BuildArch: noarch
Source: %name-%version.tar
PreReq: module-init-tools >= 3.1, mktemp >= 1:1.3.1
PreReq: coreutils findutils gawk getopt sed
PreReq: %name-initramfs = %epoch:%version-%release
PreReq: klibc-utils-initramfs
PreReq: module-init-tools-initramfs
PreReq: udev-initramfs
# lspci is used for device detection in some cases
Requires: pciutils

%description
Mkinitrd creates filesystem images which are suitable for use as Linux
initial ramdisk (initrd) images. Such images are often used for
preloading the block device modules (such as IDE, SCSI or RAID) which
are needed to access the root filesystem. Mkinitrd automatically loads
IDE modules, all scsi_hostadapter entries in /etc/modules.conf, and
raid modules if the system's root partition is on raid, which makes it
simple to build and use kernels using modular device drivers.

In other words, generic kernels can be built without drivers for any
IDE/SCSI/RAID adapters which load appropriate driver as a module. Since
the kernel needs to read those modules, but in this case it isn't able
to address the IDE/SCSI/RAID adapter, an initial ramdisk is used. The
initial ramdisk is loaded by the operating system loader (such as LILO
or GRUB) and is available to the kernel as soon as the ramdisk is
loaded. The ramdisk image loads the proper IDE/SCSI/RAID adapter and
allows the kernel to mount the root filesystem. The %name program
creates such a ramdisk using information found in the /etc/modules.conf
file.


%package initramfs
Summary: Scripts for initramfs images created by mkinitrd
Group: System/Kernel and hardware
AutoReq: no

%description initramfs
This package contains scripts for initramfs images created by mkinitrd.


%prep
%setup


%install
install -d -m 0755 %buildroot/lib/mkinitrd/initramfs-base/{sbin,scripts}
install -pD -m 0755 %name.sh %buildroot/sbin/%name
install -pD -m 0644 %name.8 %buildroot%_man8dir/%name.8
for f in init.sh sbin/*.sh; do
	install -p -m 0755 $f %buildroot/lib/mkinitrd/initramfs-base/${f%%.sh}
done
install -p -m 0644 scripts/* %buildroot/lib/mkinitrd/initramfs-base/scripts/


%files
/sbin/*
%_man8dir/*


%files initramfs
/lib/%name


%changelog
