# Node: _localstatedir has other value (/var) in other distro
Name: mlocate
Version: 0.23.1
Release: alt1.qa1

Summary: An utility for finding files by name

License: GPLv2
Url: https://fedorahosted.org/mlocate/
Group: System/Base

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: https://fedorahosted.org/releases/m/l/mlocate/mlocate-%version.tar
Source1: updatedb.conf
Source2: mlocate.cron

Conflicts: slocate
#Obsoletes: slocate <= 2.7-30

BuildRequires: rpm-build-intro

%description
mlocate is a locate/updatedb implementation.  It keeps a database of
all existing files and allows you to lookup files by name.

The 'm' stands for "merging": updatedb reuses the existing database to avoid
rereading most of the file system, which makes updatedb faster and does not
trash the system caches as much as traditional locate implementations.

%prep
%setup

%build
%configure
%make_build groupname=slocate

%install
%makeinstall_std groupname=slocate

mkdir -p %buildroot{%_sysconfdir,%_sysconfdir/cron.daily}
install -p -m 644 %SOURCE1 %buildroot%_sysconfdir/updatedb.conf
install -p -m 755 %SOURCE2 %buildroot%_sysconfdir/cron.daily/mlocate.cron

# for %%ghost
touch %buildroot%_localstatedir/mlocate/mlocate.db

%find_lang mlocate

%pre
%groupadd slocate

%post
if /bin/grep -q '^[^#]*DAILY_UPDATE' %_sysconfdir/updatedb.conf; then
    /bin/sed -i.rpmsave -e '/DAILY_UPDATE/s/^/#/' %_sysconfdir/updatedb.conf
fi

%files -f mlocate.lang
%doc AUTHORS COPYING NEWS README
%_sysconfdir/cron.daily/mlocate.cron
%config(noreplace) %_sysconfdir/updatedb.conf
%attr(2711,root,slocate) %_bindir/locate
%_bindir/updatedb
%_mandir/man*/*
%dir %attr(0750,root,slocate) %_localstatedir/mlocate
%ghost %_localstatedir/mlocate/mlocate.db

%changelog
