%define set_disable() %{expand:%%force_disable %{1}} %{expand:%%undefine _enable_%{1}}
%define set_enable() %{expand:%%force_enable %{1}} %{expand:%%undefine _disable_%{1}}

%def_disable debug
%def_disable vdpau

%define Name MLT
%define lname lib%name

Name: mlt
Version: 0.9.2
Release: alt1.M70P.1

Summary: Multimedia framework designed for television broadcasting
License: GPLv3
Group: Video
URL: http://sourceforge.net/projects/%name

Packager: Maxim Ivanov <redbaron@altlinux.org>

Source: %name-%version.tar
Source1: mlt++-config.h
Patch1: mlt-0.9.2-alt-configure-mmx.patch
Patch2: mlt-0.9.0-alt-no-version-script.patch
# SuSE
Patch10: libmlt-0.8.2-vdpau.patch

BuildRequires: ImageMagick-tools gcc-c++ jackit-devel ladspa_sdk libSDL-devel
BuildRequires: libSDL_image-devel libX11-devel libavdevice-devel libavformat-devel
BuildRequires: libquicktime-devel libsamplerate-devel libsox-devel libswscale-devel
BuildRequires: libxml2-devel kde4libs-devel libqt4-devel swig python-devel
BuildRequires: frei0r-devel libalsa-devel
%if_enabled vdpau
BuildRequires: libvdpau-devel
%endif

%description
%Name is a multimedia framework designed for television broadcasting.

%package utils
Summary: %name utils
Group: Video
License: GPL

%description utils
%Name utils.

%package -n %lname
Summary: %Name framework library
License: GPL
Group: System/Libraries

%description -n %lname
%Name is a multimedia framework designed for television broadcasting.

%package -n %lname-devel
Summary: Development files for %Name framework
License: GPL
Group: Development/C
Requires: %lname = %version-%release

%description -n %lname-devel
Development files for %Name framework.

%package -n %lname++
Summary: C++ wrapping for the MLT library
Group: System/Libraries

%description -n %lname++
This mlt sub-project provides a C++ wrapping for the MLT library.

%package -n %lname++-devel
Summary: Development files for %lname.
Group: Development/C++
Requires: %lname = %version-%release

%description -n %lname++-devel
Development files for %lname.

%package -n python-module-%name
Summary: Python package to work with MLT
Group: Development/Python

%description -n python-module-%name
This module allows to work with MLT using python..

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch10 -p0

[ -f src/mlt++/config.h ] || \
    install -m 0644 %SOURCE1 src/mlt++/config.h

VDPAU_SONAME=`readelf -a %_libdir/libvdpau.so | grep SONAME| sed 's/.*\[//'| sed 's/\].*//'`
sed -i "s/__VDPAU_SONAME__/${VDPAU_SONAME}/" src/modules/avformat/vdpau.c

%build
export CC=gcc CXX=g++ CFLAGS="%optflags" QTDIR=%_qt4dir
%configure \
	--enable-gpl --enable-gpl3 \
	--target-os=Linux \
%ifarch x86_64
	--target-arch=%_target_cpu \
%endif
	%if_enabled vdpau
	--avformat-vdpau \
	%else
	--avformat-no-vdpau \
	%endif
	%ifnarch %ix86 x86_64
	--disable-mmx \
	--disable-sse \
	--disable-sse2 \
	%endif
	%ifarch i586
	--disable-mmx \
	%endif
	%{subst_enable debug} \
	--without-kde \
	--kde-includedir=%_K4includedir \
        --kde-libdir=%_K4lib \
        --swig-languages=python
#	--luma-compress \

%make_build

%install
%make DESTDIR=%buildroot install
install -d %buildroot%python_sitelibdir
install -pm 0644 src/swig/python/%name.py %buildroot%python_sitelibdir/
install -pm 0755 src/swig/python/_%name.so %buildroot%python_sitelibdir/

%files -n %name-utils
#%doc docs/melt.txt
%_bindir/melt

%files -n %lname
#%doc docs/services.txt docs/westley.txt
%_libdir/%lname.so.*
%_libdir/%name
%_datadir/%name

%files -n %lname-devel
#%doc docs/framework.txt
%_includedir/%name
%_libdir/%lname.so
%_pkgconfigdir/%name-framework.pc

%files -n %lname++
%_libdir/%lname++.so.*

%files -n %lname++-devel
%_includedir/%name++
%_libdir/%lname++.so
%_pkgconfigdir/%name++.pc

%files -n python-module-%name
%python_sitelibdir/*

%changelog
