# handle Sisyphus/ALM2.2 differences
%define dist_tag %nil

%if_with Master
%define dist_tag Master
%endif

%if_with Sisyphus
%define dist_tag Sisyphus
%endif

%if "%dist_tag" == ""
%define dist_tag %(cut -d" " -f3 < /etc/altlinux-release)
%endif

%if "%dist_tag" == "Master"
%define release_tag .M22
%else
%define release_tag %nil
%endif

%define mod_ssl_apache_version 1.3.41

Name: mod_ssl
Version: 2.8.31
Release: alt3.qa1

Summary: An SSL module for the Apache Web server
License: BSD
Group: System/Servers
Url: http://www.modssl.org
Packager: Michael Shigorin <mike@altlinux.org>

# %url/source/mod_ssl-%version-%mod_ssl_apache_version.tar.gz
Source0: mod_ssl-%version-%mod_ssl_apache_version.tar
Source1: mod_ssl.conf

Source4: sxnet.html
Source5: ssl.default-vhost.conf
Source6: stamp.gif

Patch1: mod_ssl-2.8.25-alt-makefile.patch
Patch2: mod_ssl-2.8.31-1.3.41-pld-openssl.patch

Requires: apache >= %apache_version-%apache_release, libssl >= 0.9.6i
Requires: mm >= 1.1.0, perl >= 1:5.6.0

Requires: cert-sh-functions service

BuildRequires(pre): rpm-macros-apache
BuildRequires: libdb1-devel libssl-devel openssl
BuildRequires: libmm-devel >= 1.1.0
BuildRequires: apache-devel >= %mod_ssl_apache_version

%define oldapacheroot /home/httpd
%define re_start_flag %apache_addonconfdir/mod_ssl-upgrade-re-start.flag

Summary(de): SSL-Modul fuer den Apache-Webserver
Summary(fr): Un module SSL pour le serveur Web Apache
Summary(ru_RU.KOI8-R):   SSL  - Apache.
Summary(uk_UA.KOI8-U):  Ц SSL  - Apache.

%description
The mod_ssl project provides strong cryptography for the Apache 1.3 webserver
via the Secure Sockets Layer (SSL v2/v3) and Transport Layer Security (TLS v1)
protocols by the help of the Open Source SSL/TLS toolkit OpenSSL, which is
based on SSLeay from Eric A. Young and Tim J. Hudson.

The mod_ssl package was created in April 1998 by Ralf S. Engelschall and was
originally derived from software developed by Ben Laurie for use in the
Apache-SSL HTTP server project. The mod_ssl package is licensed under a
BSD-style licence, which basically means that you are free to get and use it
for commercial and non-commercial purposes.

%description -l de
Das mod_ssl-Projekt stellt kryptographie fr den Apache 1.3-Webserver ber
Secure Sockets Layer (SSL v2/v3) und Transport Layer Security (TLS
v1)-Protokolle zur Verfgung. Dazu wird das Open Source SSL/TLS-Toolkit
OpenSSL, das auf SSLeay basiert, verwendet.

%description -l fr
Le projet mod_ssl fournit de la forte cryptographie pour le serveur web
Apache 1.3 via les protocoles Secure Sockets Layer (SSL v2/v3) et Transport Layer
Security (TLS v1) avec l'aide du kit d'outils Open Source SSL/TLS, OpenSSL,
base sur SSLeay d'Eric A. Young et Tim J. Hudson.

%description -l ru_RU.KOI8-R
 mod_ssl      
- Apache   Secure Sockets Layer (SSL v2/v3)  Transport
Layer Security (TLS v1),  OpenSSL - open-source  SSL/TLS.

%description -l uk_UA.KOI8-U
 mod_ssl    Ʀ   -
Apache   Secure Sockets Layer (SSL v2/v3)  Transport Layer
Security (TLS v1),  OpenSSL - open-source ¦̦ SSL/TLS.

%package sxnet
Summary: Strong Extranet module for mod_ssl and apache
Summary(fr): Module d'Extranet Fort pour Apache et mod_ssl
Summary(ru_RU.KOI8-R):  Strong Extranet  mod_ssl  Apache
Group: System/Servers
Requires: mod_ssl, openssl, apache

%description sxnet
The Strong Extranet allows you to use digital certificates to authenticate
users on your web server. Typically, your users enroll in your Strong
Extranet, under your control, through the Thawte Personal Cert System.

%description -l fr sxnet
L'Extranet Fort vous permet d'utiliser des certificats numeriques pour
authentifier les usagers sur votre serveur web. Typiquement, vos usagers
s'enrolent dans votre Extranet Fort, sous votre controle, a travers le
Thawte Personal Cert System.

%description -l ru_RU.KOI8-R sxnet
Strong Extranet      
 -.      
Strong Extranet   ,  Thawte Personal Cert System.

%description -l uk_UA.KOI8-U sxnet
Strong Extranet Ѥ  צ Ʀ  Ʀæ
ަ -. ަ  Ť  ۦ ͦ
Strong Extranet Ц  ,  Thawte Personal Cert System.

%if "%dist_tag" == "Sisyphus"
%package doc
Summary: Documentation for mod_ssl
Group: System/Servers
BuildArch: noarch

%description doc
System administrator's manual for mod_ssl package
%endif

%prep
%setup -q -n mod_ssl-%version-%mod_ssl_apache_version
tar -C pkg.contrib -xf pkg.contrib/sxnet.tar
%patch1 -p1
%patch2 -p1
install -m644 %SOURCE4 index.html
install -m644 %SOURCE6 .
# Fix build on multilib platforms.
%if "lib" != "%_lib"
subst 's,/lib\>,/%_lib,g' pkg.sslmod/libssl.module
%endif

%build
PATH="$PATH:`pwd`:%_sbindir"  \
SSL_BASE=SYSTEM CFLAGS="%optflags" \
	./configure \
		--with-apxs=%apache_apxs \
		--force

CFLAGS_SHLIB="-fPIC -DSHARED_MODULE -DSSL_USE_SDBM" make -e

cd pkg.contrib/sxnet
%apache_apxs \
	-I%_includedir/openssl -L%_libdir \
	-lssl -lcrypto -c mod_sxnet.c

%install
mkdir -p %buildroot%_libdir/apache
install -m755 pkg.sslmod/libssl.so %buildroot%_libdir/apache/
install -m755 pkg.contrib/sxnet/mod_sxnet.so %buildroot%_libdir/apache/
mkdir -p %buildroot%_libdir/ssl/mod_ssl
install -m755 pkg.contrib/*.sh %buildroot%_libdir/ssl/mod_ssl/
mkdir -p %buildroot{%apache_confdir/ssl,%apache_addonconfdir}
install -m644 %SOURCE1 %SOURCE5 \
		 %buildroot%apache_addonconfdir/

# needed for correct %%ghost
mkdir -p %buildroot%apache_confdir/ssl
touch %buildroot%apache_confdir/ssl/server.{crt,csr,key}

mkdir -p %buildroot%_sbindir
cat > %buildroot%_sbindir/mod_ssl-generate-ssl-certificate << "__EOF__"
#!/bin/sh
. /etc/init.d/functions
. cert-sh-functions
if [ ! -f "%apache_confdir/ssl/server.key" ]; then
	ssl_generate "server"
	mv -f "$SSL_CERTDIR"/server.cert %apache_confdir/ssl/server.crt ||:
	mv -f "$SSL_CERTDIR"/server.csr %apache_confdir/ssl/ ||:
	mv -f "$SSL_KEYDIR"/server.key %apache_confdir/ssl/ ||:
	chmod 0600 %apache_confdir/ssl/server.{crt,csr,key} ||:
fi
__EOF__

%pre
rm -f %re_start_flag
# handle migration from pre-2.8.16-alt1
if grep -qs "^Include conf/ssl/" \
		%apache_confdir/httpd.conf; then
	echo "Warning: configuration files moved"
	echo "    from %apache_confdir/ssl/"
	echo "      to %apache_addonconfdir/"
	echo "you may want to check the transition"
	for conf in mod_ssl.conf ssl.default-vhost.conf; do
		for suffix in "" .rpmsave; do
			if [ -f %apache_confdir/ssl/$conf$suffix ]; then 
				mv -v %apache_confdir/ssl/$conf$suffix \
					 %apache_addonconfdir/$conf
				continue
			fi
		done
	done
	perl -pi -e "s|^Include conf/ssl/mod_ssl.conf\n||" \
		%apache_confdir/httpd.conf
	perl -pi -e "s|^Include conf/ssl/ssl.default-vhost.conf\n||" \
		%apache_confdir/httpd.conf
# ...and specifically thinko in %%postun of older mod_ssl:
# there should be _not_ inverted condition on $1, since as it is
# mod_ssl gets disabled, httpd restarted (what it then fails to do)
	if [ -e %_var/run/httpd.pid ]; then
		# httpd was running, must restart in trigger
		touch %re_start_flag
		echo "Warning: apache was running before erroneous %%postun"
		echo "         in previous mod_ssl version installed will"
		echo "         bring it down a few lines later; will try to fix."
	fi
fi

%post
if ! grep -qs "^Include conf/addon-modules/mod_ssl.conf" \
		%apache_confdir/httpd.conf; then
	%apache_apxs -e -a -n ssl libssl.so
	echo "Include conf/addon-modules/ssl.default-vhost.conf" \
		>> %apache_confdir/httpd.conf
fi
sed -i "s,%oldapacheroot,%apache_datadir,g" \
	%apache_addonconfdir/ssl.default-vhost.conf
%_sbindir/apachectl update

%if "%dist_tag" == "Sisyphus"
%post doc
%endif
ln -s -f %_docdir/mod_ssl-%version \
	%apache_datadir/html/addon-modules/mod_ssl ||:

%post sxnet
ln -s -f %_docdir/mod_ssl-sxnet-%version \
	%apache_datadir/html/addon-modules/mod_ssl-sxnet ||:

%preun
if [ $1 = 0 ]; then
    %apache_apxs -e -A -n ssl libssl.so
    perl -pi -e "s|^Include conf/addon-modules/mod_ssl.conf\n||" \
	    %apache_confdir/httpd.conf
    perl -pi -e "s|^Include conf/addon-modules/ssl.default-vhost.conf\n||" \
	    %apache_confdir/httpd.conf
    %_sbindir/apachectl update
fi

# WARNING: a hack to coalesce doc subpackage for ALM2.2 build
# not to change packaging

%if "%dist_tag" == "Sisyphus"
%postun doc
%endif
if [ $1 = 0 ]; then
    rm -f %apache_datadir/html/addon-modules/mod_ssl
fi

%postun sxnet
if [ $1 = 0 ]; then
    rm -f %apache_datadir/html/addon-modules/mod_ssl-sxnet
fi

%triggerpostun -- mod_ssl < 2.8.16-alt1
# ...which would erroneously disable mod_ssl after upgrade
echo "Warning, reenabling mod_ssl which was disabled by"
echo "previous version uninstallation process."
echo "If it was disabled intentionally, please recheck."
%_sbindir/apxs -e -a -n ssl libssl.so

if [ -e "%re_start_flag" ]; then
	echo "...additionally trying to re-start apache:"
	%_sbindir/apachectl restart && rm -f %re_start_flag
fi

%files
%config(noreplace) %apache_addonconfdir/mod_ssl.conf
%config(noreplace) %apache_addonconfdir/ssl.default-vhost.conf
%doc ANNOUNCE CHANGES CREDITS LICENSE NEWS README*
%_libdir/apache/libssl.so
%dir %_libdir/ssl/
%dir %_libdir/ssl/mod_ssl/
%_libdir/ssl/mod_ssl/*.sh
%dir %apache_confdir/ssl
# autogenerated cert
%ghost %attr(0600,root,root) %verify(not md5 mtime size) %apache_confdir/ssl/server.crt
%ghost %attr(0600,root,root) %verify(not md5 mtime size) %apache_confdir/ssl/server.csr
%ghost %attr(0600,root,root) %verify(not md5 mtime size) %apache_confdir/ssl/server.key
%attr(0700,root,root) %_sbindir/mod_ssl-generate-ssl-certificate

%if "%dist_tag" == "Sisyphus"
%files doc
%endif
%doc pkg.ssldoc/*

%files sxnet
%_libdir/apache/mod_sxnet.so
%doc index.html stamp.gif

%changelog
