Name: module-init-tools
Version: 3.16
Release: alt11

Summary: Kernel module management utilities
License: GPL
Group: System/Kernel and hardware
URL: http://www.kerneltools.org
ExclusiveOS: Linux
ExclusiveArch: %ix86 x86_64

Source0: %name-%version.tar
Patch0:  mit-klibc-support.patch
Patch1:  mit-ignore-all-commands.patch
Patch2:  mit-compress-xz.patch
Patch3:  mit-ignore-install.patch
Patch4:  mit-depmod-alias-valid.patch

Conflicts: modutils < 2.4.27-alt8
Conflicts: etcnet < 0.8.5
Conflicts: mkinitrd < 1:2.9.11-alt1
Conflicts: lm_sensors < 2.10.2-alt1

%define _unpackaged_files_terminate_build 1
%global __find_requires %_libdir/klibc/klibc-find-requires %__find_requires

BuildRequires: klibc-devel docbook-utils glibc-devel-static zlib-devel liblzma-devel

%description
The module-init-tools package includes various programs needed for
automatic loading and unloading of modules under 2.6.x kernels, as
well as other module management programs.

%package initramfs
Summary: Module management utilities for use in initramfs images
Group: System/Kernel and hardware
PreReq: mkinitrd-initramfs

%description initramfs
This package contains a special version of kernel module management
utilities intended for use in initramfs images generated by mkinitrd.
This version is linked with klibc instead of glibc.

%package compat
Summary: Script for migration from modutils to module-init-tools
Group: System/Kernel and hardware
PreReq: %name = %version-%release

%description compat
This package contains a script which converts configuration files
for old modutils (/etc/modules.conf) to the new format used by
module-init-tools.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

# remove pregenerated man pages - they will be recreated from SGML source
rm -f *.[58]

%build
%define _optlevel s
%add_optflags -fno-asynchronous-unwind-tables
%autoreconf
%configure \
	CC="klcc -shared" \
	CPPFLAGS="-DCONFIG_NO_BACKWARDS_COMPAT -DKLIBC"
%make_build modprobe

%install
install -pD -m 0755 {build,%buildroot/lib/mkinitrd/%name/sbin}/modprobe

%files initramfs
/lib/mkinitrd/%name

%changelog
