BuildRequires: java-1.5.0-devel
BuildRequires: /proc
BuildRequires: jpackage-compat
Name:           mojo-signatures
Version:        1.1
Release:        alt1_0.8.svn11457jpp7
Summary:        Mojo API signatures project

Group:          Development/Java
License:        MIT
URL:            http://mojo.codehaus.org/

# we are using svn because upstream doesn't provide source tarballs
# and we want to have all available signatures together anyway (just
# in case)
# svn export http://svn.codehaus.org/mojo/trunk/signatures -r11457 mojo-signatures-1.1
# tar caf mojo-signatures-1.1.tar.xz mojo-signatures-1.1
Source0:        %{name}-%{version}.tar.xz

Patch0:         0001-pom.xml-files.patch
BuildArch:      noarch


# specific release required for objectweb-asm dependency in pom.xml
BuildRequires:  animal-sniffer >= 1.6-3
BuildRequires:  jpackage-utils
BuildRequires:  maven
BuildRequires:  maven-enforcer-plugin
BuildRequires:  maven-site-plugin
BuildRequires:  maven-install-plugin
BuildRequires:  maven-plugin-cobertura
BuildRequires:  objectweb-asm
BuildRequires:  mojo-parent

# we should probably generate java15 signature with 1.5 jdk, but this
# doesn't work with gcj. The signatures are probably incorrect because
# of this, but at least they exist and noone complained yet :-)


# specific release required for handling "signature" packaging
Requires:       maven
Requires:       mojo-parent

Requires:       jpackage-utils
Requires(post):       jpackage-utils
Requires(postun):     jpackage-utils
Source44: import.info

%description
The API Signatures project contains a number of projects which
generate signatures of various APIs, such as the Java Runtime. These
signatures are generated by and consumed by the Animal Sniffer
project.

%prep
%setup -q
%patch0 -p1

%build
pushd signatures-parent
mvn-rpmbuild install
popd

for sig in java15 java16;do
    pushd $sig
    mvn-rpmbuild install
    popd
done

%install
install -d -m 755 %{buildroot}%{_mavenpomdir}
install -d -m 755 %{buildroot}%{_javadir}/%{name}

install -pm 644 signatures-parent/pom.xml \
    %{buildroot}%{_mavenpomdir}/JPP.%{name}-parent.pom

for sig in java15 java16;do
   pushd $sig
      install -pm 644 pom.xml %{buildroot}%{_mavenpomdir}/JPP.%{name}-$sig.pom
      install -pm 644 target/*signature %{buildroot}%{_javadir}/%{name}/$sig-%{version}.signature
      %add_to_maven_depmap org.codehaus.mojo.signature $sig %{version} JPP/%{name} $sig
   popd
done

(cd $RPM_BUILD_ROOT%{_javadir}/%{name} && for sig in *-%{version}*; do ln -sf ${sig} `echo $sig| sed "s|-%{version}||g"`; done)


%files
%{_mavenpomdir}/*
%{_mavendepmapfragdir}/*
%{_javadir}/%{name}



%changelog
