# vim: set ft=spec: -*- rpm-spec -*-
# TODO: create-native-map - ? 

%def_with gtkhtml
# gecko-sharp don't worked with libxul-1.9(firefox-3)
%def_without gecko
%def_with webkit

Name: mono-tools
Version: 2.10
Release: alt2

Summary: Mono Tools is a collection of utility programs for Mono
License: %gpllgpl2only
Group: Development/Other
Packager: Mono Maintainers Team <mono@packages.altlinux.org>
URL: http://www.mono-project.com/
Source0: http://go-mono.com/sources/%name/%name-%version.tar
Source2: gnunit2.desktop
Source3: monodoc.filetrigger

Patch1: %name-%version-alt-monodoc.patch
Patch2: %name-%version-alt-cecil.patch

Requires: desktop-file-utils
Requires: monodoc-browser

BuildPreReq: rpm-build-mono rpm-build-licenses
BuildPreReq: intltool libtool
BuildPreReq: desktop-file-utils
BuildPreReq: mono-mcs mono-nunit-devel monodoc-devel
BuildPreReq: glib2-devel
BuildPreReq: libgtk-sharp2-devel libgnome-sharp-devel
BuildPreReq: mono-winforms mono-extras mono-data-oracle mono-csharp

%{?_with_gtkhtml:BuildPreReq: libgnome-desktop-sharp-devel}
%{?_with_gecko:BuildPreReq: libgecko-sharp2-devel}
%{?_with_webkit:BuildPreReq: libwebkit-sharp-devel}

BuildRequires: mono-devel >= %version
BuildRequires: /proc

%description
Mono Tools is a collection of development and testing programs and 
utilities for use with Mono.

%package devel
Summary: Mono Tools is a collection of utility programs for Mono
Group: Development/Other
Requires: %name = %version-%release

%description devel
Mono Tools is a collection of development and testing programs and 
utilities for use with Mono.

This package contains development pkg-config files for %name

%package -n monodoc-browser
Summary: MonoDoc GTK+ based viewer
Group: Development/Other
Requires: monodoc-browser-render = %version-%release

%description -n monodoc-browser
This package contains the GTK+ based viewer of the Mono documentation.

%package -n monodoc-browser-gtkhtml
Summary: Gtkhtml render for monodoc-browser
Group: Development/Other
Provides: monodoc-browser-render = %version-%release

%description -n monodoc-browser-gtkhtml
Gtkhtml render for monodoc-browser.

%package -n monodoc-browser-webkit
Summary: Webkit render for monodoc-browser
Group: Development/Other
Provides: monodoc-browser-render = %version-%release

%description -n monodoc-browser-webkit
Webkit render for monodoc-browser.

%package -n monodoc-browser-gecko
Summary: Gecko render for monodoc-browser
Group: Development/Other
Provides: monodoc-browser-render = %version-%release

%description -n monodoc-browser-gecko
Gecko render for monodoc-browser.

%package -n monodoc-browser-monowebbrowser
Summary: MonoWebBrowser render for monodoc-browser
Group: Development/Other
Provides: monodoc-browser-render = %version-%release

%description -n monodoc-browser-monowebbrowser
MonoWebBrowser render for monodoc-browser.

%package -n monodoc-browser-webdoc
Summary: Webdoc for monodoc
Group: Development/Other
BuildArch: noarch
Provides: monodoc-browser-render = %version-%release

%description -n monodoc-browser-webdoc
Web pages for HTTP server(xsp or mod_mono or monodoc server).

%package doc
Summary: Documentation for mono-tools
Group: Documentation
BuildArch: noarch
Requires: monodoc >= 2.2

%description doc
This package contains the documentation for the mono-tools class libraries(Gendarme.Framework and other Gendarme.*)

%prep
%setup -q
%patch1 -p1
%patch2 -p1

subst "s|^pkgconfigdir *= \$(prefix)/lib/pkgconfig|pkgconfigdir = %_pkgconfigdir|" \
	gendarme/framework/Makefile.am \
	create-native-map/lib/pkgconfig/Makefile.am
subst 's|^libdir=@libdir@|libdir=${prefix}/lib|' create-native-map/lib/pkgconfig/create-native-map.pc.in
subst "s|^assemblydir = \$(libdir)/ilcontrast|assemblydir = \$(prefix)/lib/ilcontrast|" ilcontrast/Makefile.am
#subst "s|^programfilesdir = @libdir@/@PACKAGE@|programfilesdir = \$(prefix)/lib/@PACKAGE@|" Mono.Profiler/Makefile.include
subst "s|^pkglib_DATA|programfilesdir = @prefix@/lib/@PACKAGE@\nprogramfiles_DATA |" Mono.Profiler/{profiler-decoder-library,Mono.Profiler.Widgets,heap-snapshot-explorer,heap-snapshot-viewer,mprof-gui,profiler-file-decoder}/Makefile.am

%build
glib-gettextize --force --copy
%autoreconf
%configure --enable-release

%make

%install
%make_install DESTDIR=%buildroot install
%find_lang %name
mkdir asn1view.doc && ln -s ../asn1view/{AUTHORS,ChangeLog,README,TODO} asn1view.doc
mkdir docbrowser.doc && ln -s ../docbrowser/ChangeLog docbrowser.doc
mkdir gnunit.doc && ln -s ../gnunit/{AUTHORS,ChangeLog,README,TODO} gnunit.doc

install -p -m644 %SOURCE2 %buildroot%_desktopdir/

# posttrans filetrigger 
install -pD -m755 %SOURCE3 %buildroot%_rpmlibdir/monodoc.filetrigger
install -pD -m644 /dev/null %buildroot%_datadir/monodoc/monodoc.index

%files -f %name.lang
%doc AUTHORS ChangeLog README asn1view.doc docbrowser.doc
%_bindir/*
%_prefix/lib/mono/*
%_prefix/lib/mono-tools
%_prefix/lib/gendarme
%_prefix/lib/gui-compare
%_prefix/lib/ilcontrast
%_prefix/lib/gsharp
%_prefix/lib/mperfmon
%_prefix/lib/minvoke
%_prefix/lib/create-native-map
%_man1dir/*
%_man5dir/*
%_pixmapsdir/*
%_iconsdir/hicolor/*/apps/*
%_desktopdir/*
%exclude %_bindir/monodoc

%files devel
%_pkgconfigdir/*.pc

%files -n monodoc-browser
%_bindir/monodoc
%_prefix/lib/monodoc/browser.exe
%_rpmlibdir/monodoc.filetrigger
%ghost %_datadir/monodoc/monodoc.index

%if_with gtkhtml
%files -n monodoc-browser-gtkhtml
%_prefix/lib/monodoc/GtkHtmlHtmlRender.dll
%endif

%if_with webkit
%files -n monodoc-browser-webkit
%_prefix/lib/monodoc/WebKitHtmlRender.dll
%endif

%if_with gecko
%files -n monodoc-browser-gecko
%_prefix/lib/monodoc/GeckoHtmlRender.dll
%endif

%files -n monodoc-browser-monowebbrowser
%_prefix/lib/monodoc/MonoWebBrowserHtmlRender.dll

%files -n monodoc-browser-webdoc
%_datadir/monodoc/web

%files doc
%_monodocdir/*

%changelog
