# vim: set ft=spec: -*- rpm-spec -*-

%def_disable tests

Name: monodevelop
Version: 2.8.6.4
Release: alt1

Summary: MonoDevelop is a project to port SharpDevelop to Gtk#
License: LGPLv2.1
Group: Development/Other
Packager: Mono Maintainers Team <mono@packages.altlinux.org>
Url: http://www.monodevelop.org/

Source: %name-%version.tar
Patch0: %name-%version-%release.patch

# FIXME: check everytime
%add_findreq_skiplist %_prefix/lib/%name/AddIns/VersionControl/MonoDevelop.VersionControl.Subversion.dll

Requires: libsubversion
Requires: desktop-file-utils
Requires: firefox
Requires: shared-mime-info

BuildPreReq: rpm-build-mono mono-mcs
BuildPreReq: mono-devel >= 2.8
BuildPreReq: mono-addins-devel >= 0.6
BuildPreReq: libgtk-sharp2-devel >= 2.12.8
BuildPreReq: libgnome-desktop-sharp-devel >= 2.12.8
BuildPreReq: monodoc-devel >= 1.0

# BuildPreReq: libgecko-sharp2-devel >= 0.10

BuildRequires: intltool mono-mcs mono-web-devel mono-winforms
BuildRequires: desktop-file-utils mono-nunit-devel perl-XML-Parser shared-mime-info intltool
BuildRequires: zip
BuildRequires: /proc

BuildRequires: xsp

%description
This is MonoDevelop which is intended to be a full-featured
integrated development environment (IDE) for mono and Gtk#.
It was originally a port of SharpDevelop 0.98.

%prep
%setup -q -n %name-%version
%patch0 -p1

%__subst '/^Encoding=/d;
	s/^Exec=monodevelop$/Exec=monodevelop %%F/;
	s/^Categories=.*$/Categories=Development;IDE;/
	' monodevelop.desktop
%__subst "s|^pkgconfigdir *= \$(prefix)/lib/pkgconfig|pkgconfigdir = %_pkgconfigdir|" \
	Makefile.am

%build
#export PKG_CONFIG_PATH=%_pkgconfigdir MOZILLA_HOME=%_libdir/firefox
%autoreconf
%configure  \
	    --disable-update-mimedb --disable-update-desktopdb \
	    %{subst_enable tests}

mkdir -p build/bin

%make

%install
%make_install DESTDIR=%buildroot install

%find_lang %name

%files -f %name.lang
%doc AUTHORS COPYING ChangeLog INSTALL README
%_bindir/*
%_prefix/lib/%name
%_pkgconfigdir/*.pc
%_desktopdir/%name.desktop
%_iconsdir/hicolor/??x??/apps/%{name}*.png
%_iconsdir/hicolor/scalable/apps/%{name}*.svg
%_datadir/mime/packages/*
%_man1dir/*

%changelog
