# vim: set ft=spec: -*- rpm-spec -*-

# %%branch_switch set %%branch_release use
#%%define branch_switch Mxx

%define packagversion 2.2.9
%define packagedate 20130411
%define packagemoodleversion 2011120509.04
%define moodlebranch 2.2
%define moodlepackagename %moodle_name%moodlebranch

#Name: %moodlepackagename
Name: moodle2.2
Version: %packagversion.%packagedate
Release: %branch_release alt2

Summary: The Course Management System Moodle
License: %gpl3plus
Group: Networking/WWW

Url: http://www.moodle.org
Packager: Aleksey Avdeev <solo@altlinux.ru>
BuildArch: noarch

Source: %name-%version.tar
Source1: distrolib.php
Source10: %moodle_name.httpd.conf
Source20: %moodle_name.httpd2.conf
Source21: %moodle_name.start.extra.conf
Source22: %moodle_name.start.mods.conf
Source23: %moodle_name.httpd2.inc.conf

Patch1: %name-alt-lang_installer.patch

Requires: %name-base = %version-%release
Requires: %name-auth-pam >= 2.2.0.2011112900.0.20130411-alt1
Provides: %moodle_name = %version-%release

BuildRequires(pre): rpm-macros-branch
BuildRequires(pre): rpm-macros-moodle >= 2.4
BuildRequires(pre): rpm-macros-apache2
BuildPreReq: rpm-macros-fonts
BuildPreReq: rpm-build-webserver-common
BuildPreReq: rpm-build-licenses
BuildPreReq: perl-HTML-Parser

%description
Moodle is a course management system (CMS) - a free, Open Source software
package designed using sound pedagogical principles, to help educators create
effective online learning communities.

This package, with dependencies, install all the standard components
of Moodle.

%package base
Summary: Base part for Moodle CMS
Group: Networking/WWW

PreReq: webserver-common
PreReq: %_sbindir/web-condstop-rpm
PreReq: %_sbindir/web-condstart-rpm
PreReq: %_sbindir/mt-getCFG
PreReq: %_sbindir/mt-setCFG
PreReq: %_sbindir/mt-newdatadir
PreReq: %_sbindir/mt-getdef
PreReq: %_sbindir/mt-setdef
Requires: %webserver_webappsdir
Requires: php-engine php5-gd2 php5-openssl php5-xmlrpc php5-curl iconv php5-mbstring php5-ldap
Requires: texlive-base-bin ImageMagick
Requires: php5-soap
Requires: php5-zip
Requires: php5-intl
Requires: php5-dom
Provides: %moodle_name-base = %version-%release
Provides: %{moodle_name}2.0-base = %version-%release
Provides: %moodle_dir
Provides: %moodle_admindir
Provides: %moodle_authdir
Provides: %moodle_blocksdir
Provides: %moodle_calendardir
Provides: %moodle_coursedir
Provides: %moodle_docdir
Provides: %moodle_enroldir
Provides: %moodle_filesdir
Provides: %moodle_filterdir
Provides: %moodle_langdir
Provides: %moodle_libdir
Provides: %moodle_logindir
Provides: %moodle_moddir
Provides: %moodle_pixdir
Provides: %moodle_questiondir
Provides: %moodle_questionformatdir
Provides: %moodle_themedir
Provides: %moodle_datadir
Provides: %moodle_name-version = %packagemoodleversion
Provides: moodle-lang-en_utf8 = %version-%release
Provides: %name-lang-en = %version-%release
Conflicts: moodle-apache2 < 2.2
Conflicts: moodle-apache2 >= 2.3
Conflicts: moodle-local-mysql < 2.2
Conflicts: moodle-local-mysql >= 2.3
Conflicts: moodle-lang < 2.0
Conflicts: moodle-lang-en_utf8 < 2.2
Conflicts: %moodle_name < 2.2
Conflicts: %moodle_name >= 2.3
Conflicts: %moodle_name-appfor < 2.0
# Old moodle-lang-*
Conflicts: moodle-lang-be_utf8 < 1.9.10.20100526
Conflicts: moodle-lang-de_utf8 < 1.9.10.20110705
Conflicts: moodle-lang-es_utf8 < 1.9.10.20101112
Conflicts: moodle-lang-fr_utf8 < 1.9.10.20110718
Conflicts: moodle-lang-hy_utf8 < 1.9.10.20100526
Conflicts: moodle-lang-it_utf8 < 1.9.10.20110319
Conflicts: moodle-lang-ja_utf8 < 1.9.10.20110809
Conflicts: moodle-lang-pt_utf8 < 1.9.10.20100814
Conflicts: moodle-lang-ru_utf8 < 1.9.10.20100617
Conflicts: moodle-lang-uk_utf8 < 1.9.10.20100526
Conflicts: moodle-lang-uz_utf8 < 1.9.10.20100526
Conflicts: moodle-lang-zh_tw_utf8 < 1.9.10.20100526
Conflicts: moodle-lang-zh_cn_utf8 < 1.9.10.20100526

%description base
%summary

Part of the standard components of Moodle, is not included
in this package is moved to subpackages.

#%package apache
#Summary: apache-related config for Moodle CMS
#Group: Networking/WWW
#Requires: %name = %version-%release
#Requires: apache apache-mod_php5
#Provides: %moodle_name-apache = %version-%release

#%description apache
#%summary

%package apache2
Summary: apache2-related config for Moodle CMS
Group: Networking/WWW
Requires: apache2-base > 2.2.17-alt2
Requires: %apache2_extra_available
Requires: %apache2_extra_enabled
Requires: %apache2_extra_start
Requires: %apache2_mods_start
Requires: %apache2_confdir_inc
Requires: %name-base >= 2.2.9.20130411-alt1
Requires: %moodle_dir
Requires: %moodle_datadir
Requires: apache2-mod_php5
Provides: %moodle_name-apache2 = %version-%release
Conflicts: %moodle_name >= 2.3
Conflicts: %moodle_name-base >= 2.3

%description apache2
%summary

%package local-mysql
Summary: installed mysql-server on localhost for Moodle
Group: Networking/WWW
Requires: %name-base >= 2.2.9.20130411-alt1
Requires: MySQL-server
Requires: php5-mysqli
Provides: %moodle_name-local-mysql = %version-%release
Conflicts: %moodle_name >= 2.3
Conflicts: %moodle_name-base >= 2.3

%description local-mysql
%summary

#%package local-pgsql
#Summary: installed postgresql-server on localhost for Moodle
#Group: Networking/WWW
#Requires: %name = %version-%release
#Requires: postgresql8.2-server php5-pgsql
#Provides: %moodle_name-local-pgsql = %version-%release

#%description local-pgsql
#%summary

%define auth_pam_moodlerequires 2011112900
%define auth_pam_packagemoodleversion 2011112900
%define auth_pam_packagemoodlerelease 2.2.0
%package auth-pam
Version: %auth_pam_packagemoodlerelease.%auth_pam_packagemoodleversion.0.%packagedate
Summary: PAM authentication for Moodle
Group: Networking/WWW

Requires: pecl-pam
Requires: %name-base >= 2.2.9.20130411-alt1
Requires: %moodle_authdir
Requires: %moodle_name-version >= %auth_pam_moodlerequires
Provides: %moodle_name-appfor = 2.2
Provides: %moodle_name-auth-pam-version = %auth_pam_packagemoodleversion
Provides: %moodle_name-auth-pam-appfor = %auth_pam_moodlerequires
Conflicts: %moodle_name-auth-pam-version < %auth_pam_packagemoodleversion

%description auth-pam
PAM (Pluggable Authentication Modules) authentication methods for Moodle

%add_perl_lib_path %moodle_filterdir/algebra
%define filter_from_reqprov /^perl(\\(AlgParser\\.pm\\|algebra2tex\\.pl\\))/d
%filter_from_provides %filter_from_reqprov
%filter_from_requires %filter_from_reqprov

%prep
%setup -q
%patch1 -p1

rm -f filter/tex/*mimetex*
#rm -f filter/algebra/*
rm -f lib/default.ttf

%build

%install
# install moodle
mkdir -p %buildroot%moodle_dir/
mkdir -p %buildroot%moodle_datadir/
cp -rp * %buildroot%moodle_dir/

# create config.php
touch %buildroot%moodle_dir/config.php

%define mimetexlinux_filter %moodle_filterdir/tex/mimetex.linux
ln -s -f $(relative %buildroot%webserver_cgibindir/mimetex.cgi \
	%buildroot%mimetexlinux_filter) \
	%buildroot%mimetexlinux_filter

%define default_ttf %moodle_libdir/default.ttf
ln -s -f $(relative %buildroot%_ttffontsdir/freefont/FreeSans.ttf \
	%buildroot%default_ttf) \
	%buildroot%default_ttf

# install distrolib.php
install -pD -m0644 %SOURCE1 %buildroot%moodle_dir/install/distrolib.php

# install apache config
install -pD -m0644 %SOURCE10 %buildroot%_sysconfdir/httpd/conf/addon-modules.d/%name.conf

# install apache2 config
install -pD -m0644 %SOURCE20 %buildroot%apache2_extra_available/%name.conf
install -pD -m0644 %SOURCE21 %buildroot%apache2_extra_start/100-%name.conf
install -pD -m0644 %SOURCE22 %buildroot%apache2_mods_start/100-%name.conf
install -pD -m0644 %SOURCE23 %buildroot%apache2_confdir_inc/Directory_%{moodle_name}_default.conf

mkdir -p %buildroot%apache2_extra_enabled/
touch %buildroot%apache2_extra_enabled/%name.conf

#Disclosure of the macros
find %buildroot%moodle_dir/install/distrolib.php %buildroot%_sysconfdir -type f -print0 \
	| xargs -r0 sed -ri "
s@%%(\{name\}|name([[:space:]/'\"=]))@%name\2@g
s@%%(\{webserver_datadir\}|webserver_datadir([[:space:]/'\"=]))@%webserver_datadir\2@g
s@%%(\{moodle_name\}|moodle_name([[:space:]/'\"=]))@%moodle_name\2@g
s@%%(\{moodle_dir\}|moodle_dir([[:space:]/'\"=]))@%moodle_dir\2@g
s@%%(\{moodle_datadir\}|moodle_datadir([[:space:]/'\"=]))@%moodle_datadir\2@g
"

%triggerun base -- moodle2.1 <= 2.1.1.20110817-alt2.1, moodle2.1-base <= 2.1.4.20120217-alt2, moodle2.0 <= 2.0.4.20110817-alt2.1, moodle2.0-base <= 2.0.7.20120217-alt2, moodle <= 1.9.13.20110817-alt2.1, moodle-base <= 1.9.16.20120217-alt3, moodle-apache <= 1.9.10-alt2.cvs20101110, moodle-apache2 <= 1.9.10-alt2.cvs20101110
if ls -l %moodle_dir/ | egrep -qsm1 '^([^[:space:]]+[[:space:]]+){3}(apache2?|root)[[:space:]]'; then
	echo "Warning: GUD directory %moodle_dir/ changed to %webserver_group."
	chgrp %webserver_group %moodle_dir/
fi
if [ -e "%moodle_dir/install/distrolib.php" ]; then
	old_moodle_def_dataroot="`%_sbindir/mt-getdef --file=%moodle_dir/install/distrolib.php dataroot`"
	if (echo "$old_moodle_def_dataroot" | \
			egrep -q '^[[:space:]]*(%moodle_olddatadir|%moodle_olddatadir2)(/+)?[[:space:]]*$'); then
		echo "Warning: In the file %moodle_dir/install/distrolib.php"
		echo "    path $old_moodle_dataroot replaced by %moodle_datadir."
		echo 'Original file %moodle_dir/install/distrolib.php is saved as %moodle_dir/install/distrolib.php.rpmold.'
		cp -fa --backup=t "%moodle_dir/install/distrolib.php" "%moodle_dir/install/distrolib.php.rpmold"
		%_sbindir/mt-setdef --file=%moodle_dir/install/distrolib.php \
			-m 'rpm update to %name-base-%version-%release' \
			dataroot '%moodle_datadir'
	fi
fi
if [ -e "%moodle_dir/config.php" ]; then
	%_sbindir/web-condstop-rpm

	old_moodle_directorypermissions="`%_sbindir/mt-getCFG --file=%moodle_dir/config.php --format='%%05o' directorypermissions`"
	if [ "$old_moodle_directorypermissions" != "02770" ]; then
		new_moodle_directorypermissions="02770"
		echo "Warning: In the file %moodle_dir/config.php"
		echo "    \$CFG->directorypermissions value varies with the $old_moodle_directorypermissions on the $new_moodle_directorypermissions."
	else
		new_moodle_directorypermissions="$old_moodle_directorypermissions"
	fi

	old_moodle_dataroot="`%_sbindir/mt-getCFG --file=%moodle_dir/config.php dataroot`"
	if (echo "$old_moodle_dataroot" | \
			egrep -q '^[[:space:]]*(%moodle_olddatadir|%moodle_olddatadir2)(/+)?[[:space:]]*$'); then
		new_moodle_dataroot="%moodle_datadir"
		rpmold_moodle_dataroot="`echo "$old_moodle_dataroot" | \
			sed -r 's@^[[:space:]]([^[:space:]]+[^/[:space:]])/*[[:space:]]*$@\1.rpmold@'`"
		echo "Warning: In the file %moodle_dir/config.php"
		echo "    path $old_moodle_dataroot replaced by %moodle_datadir."
	else
		new_moodle_dataroot="$old_moodle_dataroot"
		rpmold_moodle_dataroot=
	fi

	if [ "$old_moodle_dataroot" != "$new_moodle_dataroot" ] \
			|| [ "$old_moodle_directorypermissions" != "$new_moodle_directorypermissions" ]; then
		echo 'Original file %moodle_dir/config.php is saved as %moodle_dir/config.php.rpmold.'
		cp -fa --backup=t "%moodle_dir/config.php" "%moodle_dir/config.php.rpmold"

		if [ "$old_moodle_dataroot" != "$new_moodle_dataroot" ] \
				&& [ -e "$old_moodle_dataroot" ] \
				&& [ -d "$old_moodle_dataroot" ] \
				&& ( \
					( \
						[ -e "$new_moodle_dataroot" ] \
						&& [ -d "$new_moodle_dataroot" ] \
						&& [ "x`find "$new_moodle_dataroot" -mindepth 1 -maxdepth 1`" = "x" ] \
					) \
					|| ( \
						[ ! -e "$new_moodle_dataroot" ] \
					) \
				); then
			echo "Original directory $old_moodle_dataroot is renamed as $rpmold_moodle_dataroot."
			mv "$old_moodle_dataroot" "$rpmold_moodle_dataroot"

			echo "All contents of the directory $old_moodle_dataroot"
			echo "is copied to the $new_moodle_dataroot."
			%_sbindir/mt-newdatadir --file=%moodle_dir/config.php \
				-m 'rpm update to %name-base-%version-%release' \
				"$new_moodle_dataroot"
			pushd "$rpmold_moodle_dataroot"
				find . -mindepth 1 -maxdepth 1 -printf '%%f\0' \
					| xargs -r0 cp -af --target-directory="$new_moodle_dataroot/"
			popd

			chmod $new_moodle_directorypermissions "%moodle_domainsdir"
			chown root:%webserver_group "%moodle_domainsdir"
		fi

		if [ "$old_moodle_directorypermissions" != "$new_moodle_directorypermissions" ]; then
			%_sbindir/mt-setCFG --file=%moodle_dir/config.php --no-quote \
				-m 'rpm update to %name-base-%version-%release' \
				directorypermissions $new_moodle_directorypermissions
		fi
	fi

	if [ -e "$new_moodle_dataroot" ] \
			&& [ -d "$new_moodle_dataroot" ]; then
		if [ "x`find "$new_moodle_dataroot" -mindepth 1 -type d ! -perm $new_moodle_directorypermissions`" != "x" ]; then
			echo "Warning: Change permissions of subdirectories"
			echo "    $new_moodle_dataroot on the $new_moodle_directorypermissions."
			find "$new_moodle_dataroot" -mindepth 1 -type d ! -perm $new_moodle_directorypermissions -print0 \
				| xargs -0 chmod $new_moodle_directorypermissions
		fi

		if [ "x`find "$new_moodle_dataroot" -mindepth 1 ! -group %webserver_group`" != "x" ]; then
			echo "Warning: GUD files and subdirectories"
			echo "    $old_moodle_dataroot changed to %webserver_group."
			find "$new_moodle_dataroot" -mindepth 1 ! -group %webserver_group -print0 \
				| xargs -0 chgrp %webserver_group
		fi
	fi

	%_sbindir/web-condstart-rpm
fi
exit 0

%triggerun apache2 -- moodle-apache2 <= 1.9.10-alt2.cvs20101110
if [ -e %apache2_addonconfdir/A.%name.conf ]; then
	echo "Warning: The configuration file %apache2_addonconfdir/A.%name.conf"
	echo "   outdated and was saved as %apache2_addonconfdir/N.%name.conf.rpmold."
	echo "   Use %apache2_extra_available/%name.conf."
	mv %apache2_addonconfdir/A.%name.conf %apache2_addonconfdir/N.%name.conf.rpmold
fi
exit 0

#%post apache
#chown root:apache %moodle_dir/
#control apache-mod_php5 relaxed
#%_initdir/httpd reload

#%postun apache
#%_initdir/httpd reload

%files

%files base
%dir %attr(2775,root,%webserver_group) %moodle_dir/
%ghost %config(noreplace) %moodle_dir/config.php
%config(noreplace) %moodle_dir/install/distrolib.php
%moodle_dir/*
%exclude %moodle_authdir/pam/
#%exclude %moodle_moddir/journal/
#%exclude %moodle_moddir/hotpot/
#%exclude %moodle_questionformatdir/hotpot/
%dir %attr(2770,root,%webserver_group) %moodle_datadir/

#%files apache
#%config(noreplace) %_sysconfdir/httpd/conf/addon-modules.d/%name.conf

%files apache2
%config(noreplace) %apache2_extra_available/%name.conf
%ghost %apache2_extra_enabled/%name.conf
%config(noreplace) %apache2_confdir_inc/Directory_%{moodle_name}_default.conf
%config(noreplace) %apache2_extra_start/100-%name.conf
%config(noreplace) %apache2_mods_start/100-%name.conf

%files local-mysql

#%files local-pgsql

%files auth-pam
%moodle_authdir/pam/

%changelog
