# -*- rpm-spec -*-

#define svnversion svn20090216

#define branch_point alt1.%%svnversion
%define branch_point alt2
#define revision 1

Name: motion
Version: 3.2.12
Release: %branch_point.6

Summary: %name - Detect motion using a video4linux device

License: GPL
Group: Video
Url: http://www.lavrsen.dk/twiki/bin/view/Motion/WebHome

#Source0: %%name-%%version-%%svnversion.tar.bz2
Source0: %name-%version.tar.gz
Patch: %name-ffmpeg-0.7.1.patch
Patch1: %name-3.2.12-alt-v4l.patch

Packager: Hihin Ruslan <ruslandh@altlinux.ru>

BuildPreReq: libavformat-devel libjpeg-devel postgresql-devel zlib-devel
BuildPreReq: libmjpegtools-devel libsqlite3-devel 
BuildPreReq: libpostproc-devel libswscale-devel libavdevice-devel
BuildPreReq: libavfilter-devel libv4l-devel

# Automatically added by buildreq on Sat Dec 11 2010
BuildRequires: libavformat-devel libjpeg-devel libmysqlclient-devel postgresql-devel zlib-devel

%description
With motion you can use a video4linux device as a motion detector.
It will make snapshots if motion is detected.

%prep
%setup -n %name-%version
%patch0 -p2
%patch1 -p2
%__subst 's|<postgresql[/]libpq-fe.h>|<pgsql/libpq-fe.h>|' %name.h
%__subst 's|\(if [\\(]cnt->conf\.mysql_db && sqltype[\)]\)|//\1|' event.c
%__subst 's|\(put_mysql[\(]&cnt->conf, cnt->database, filename, tm, sqltype[\)]\)|//\1|' event.c
%__subst 's|\(motion\.conf\)\(\*\)|\1.\2|' Makefile.in
%__subst 's|\(^.*c->quality\).*|//\1|' ffmpeg.c
%__subst 's,\@PACKAGE_NAME@,\%name,' Makefile.in
%__subst 's,\-@PACKAGE_VERSION@,\-%version,' Makefile.in

rm -f version.sh

%build
%autoreconf
%configure --sysconfdir=%_sysconfdir/%name \
	--docdir=%_defaultdocdir \
	--without-optimizecpu
%make_build

%install
%makeinstall

install -d -m 755 %buildroot%_sysconfdir/%name
install -m 644 %buildroot%_sysconfdir/%name-dist.conf %buildroot%_sysconfdir/%name/%name.conf
rm -f %buildroot%_sysconfdir/%name-dist.conf
mv %buildroot%_datadir/%name-%version/examples/  %buildroot%_defaultdocdir/%name-%version/examples


%files
%_defaultdocdir/%name-%version/
%docdir %_defaultdocdir/%name-%version/
%dir %_sysconfdir/%name/
%config %_sysconfdir/%name/%name.conf
%_bindir/%name
%_man1dir/*

%changelog
