%def_disable debug
%def_disable prof
%def_disable werror
%def_disable ao
%def_disable shout
%def_enable tcp
%def_enable un
%def_disable curl
%def_disable ipv6
%def_disable fluidsynth
%def_disable wildmidi
%def_disable oss
%def_enable alsa
%def_disable jack
%def_disable pulse
%def_disable fifo
%def_disable mvp
%def_enable vorbis
%def_disable oggflac
%def_disable flac
%def_enable mad
%def_disable vorbisenc
%def_disable lameenc
%def_disable aac
%def_disable audiofile
%def_disable mikmod
%def_disable modplug
%def_disable faad
%def_disable mpc
%def_enable ffmpeg
%def_disable mp4ff
%def_disable wavpack
%def_enable id3
%def_disable lsr
%def_disable mms
%def_disable bzip2
%def_disable zzip
%def_disable iso9660
%def_disable sqlite
%def_disable sidplay
%def_disable httpd_output
%def_disable doc
%def_without tremor
# auto|avahi|bonjour|no
%define zeroconf no
%define mpd_user _mpd
%define mpd_group _mpd
#----------------------------------------------------------------------
%define subst_enable_to() %{expand:%%{?_enable_%{1}:--enable-%{2}}} %{expand:%%{?_disable_%{1}:--disable-%{2}}}
%define set_disable() %{expand:%%force_disable %{1}} %{expand:%%undefine _enable_%{1}}

%if_with tremor
%set_disable shout
%set_disable oggflac
%endif
%{!?zeroconf:%define zeroconf no}

%define Name MPD
%define oname mpd

Name: mpd-mini
Version: 0.16.4
%define prerel %nil
Release: alt1.qa1
Summary: Light version of Music Player Daemon (%Name)
License: GPLv2+
Group: Sound
Url: http://musicpd.org
Source0: %url/uploads/files/%oname-%version%prerel.tar.bz2
Source1: %oname.conf
Source2: %oname.sys.conf.in
Source3: %oname.init.in
Source4: %oname.logrotate
Packager: Slava Semushin <php-coder@altlinux.ru>

Conflicts: %oname
BuildRequires: zlib-devel gcc-c++
BuildRequires: glib2-devel >= 2.12
%{?_enable_curl:BuildRequires: libcurl-devel}
%{?_enable_alsa:BuildRequires: libalsa-devel >= 0.9.0}
%{?_enable_jack:BuildRequires: jackit-devel}
%{?_enable_ao:BuildRequires: libao-devel}
%{?_enable_shout:BuildRequires: libshout2-devel}
%{?_enable_audiofile:BuildRequires: libaudiofile-devel >= 0.1.7}
%{?_enable_mikmod:BuildRequires: libmikmod-devel >= 3.1.7}
%{?_enable_modplug:BuildRequires: libmmodplug-devel}
%{?_enable_faad:BuildRequires: libfaad-devel}
%{?_enable_flac:BuildRequires: libflac-devel >= 1.1.3}
%{?_enable_oggflac:BuildRequires: liboggflac-devel}
%{?_enable_id3:BuildRequires: libid3tag-devel}
%{?_enable_mad:BuildRequires: libmad-devel}
%{?_enable_vorbisenc:BuildRequires: libvorbis-devel}
%{?_enable_lameenc:BuildRequires: liblame-devel}
%{?_enable_mpc:BuildRequires: libmpcdec-devel}
%{?_enable_ffmpeg:BuildRequires: libavformat-devel}
%{?_enable_mp4ff:BuildRequires: libmp4ff-devel}
%{?_enable_wavpack:BuildRequires: libwavpack-devel}
%{?_enable_pulse:BuildRequires: libpulseaudio-devel}
%{?_enable_vorbis:BuildRequires: libvorbis-devel}
%{?_enable_lsr:BuildRequires: libsamplerate-devel}
%{?_enable_mms:BuildRequires: libmms-devel >= 0.4}
%{?_enable_sidplay:BuildRequires: libsidplay2-devel}
%{?_enable_zzip:BuildRequires: zziplib-devel >= 0.13}
%{?_enable_bzip2:BuildRequires: bzlib-devel}
%{?_enable_iso9660:BuildRequires: libcdio-devel}
%{?_enable_sqlite:BuildRequires: libsqlite3-devel}
%{?_enable_fluidsynth:BuildRequires: libfluidsynth-devel}
%{?_enable_doc:BuildRequires: docbook-dtds doxygen xmlto >= 0.0.21-alt2}
%if %zeroconf == avahi
BuildRequires: libavahi-glib-devel
%endif

%description
Music Player Daemon (%Name) allows remote access for playing music
(MP3, Ogg Vorbis, FLAC, AAC and WMA files) and managing
playlists. %Name is designed for integrating a computer into a stereo
system that provides control for music playback over a local network.
It is also makes a great desktop music player, especially if you are a
console junkie, like frontend options, or restart X often.


%if_enabled doc
%package doc
Summary: Music Player Daemon (%Name) documentation
Group: Documentation
BuildArch: noarch
Conflicts: %oname-doc

%description doc
Music Player Daemon (%Name) allows remote access for playing music
(MP3, Ogg Vorbis, FLAC, AAC and WMA files) and managing
playlists. %Name is designed for integrating a computer into a stereo
system that provides control for music playback over a local network.
It is also makes a great desktop music player, especially if you are a
console junkie, like frontend options, or restart X often.
This package contains %Name documentation.


%package doc-api
Summary: Music Player Daemon (%Name) documentation
Group: Development/Documentation
BuildArch: noarch
Conflicts: %oname-doc-api

%description doc-api
Music Player Daemon (%Name) allows remote access for playing music
(MP3, Ogg Vorbis, FLAC, AAC and WMA files) and managing
playlists. %Name is designed for integrating a computer into a stereo
system that provides control for music playback over a local network.
It is also makes a great desktop music player, especially if you are a
console junkie, like frontend options, or restart X often.
This package contains %Name's API documentation.
%endif


%prep
%setup -n %oname-%version%prerel

%if_enabled flac
[ $(rpmvercmp %{get_version libflac-devel} 1.1.3) -lt 0 ] || sed -i 's/AM_PATH_LIBOGGFLAC/AM_PATH_LIBFLAC/' configure.ac
%endif

%if_enabled mad
# libmad.pc describes 'libmad', not 'mad'
sed -i 's/\[mad\]/[libmad]/' configure.ac
%endif


%build
%define _optlevel 3
%autoreconf
%configure \
    %{subst_enable debug} \
    %{subst_enable_to prof gprof} \
    %{subst_enable werror} \
    %{subst_with tremor} \
    %{subst_enable ao} \
    %{subst_enable shout} \
    %{subst_enable tcp} \
    %{subst_enable un} \
    %{subst_enable curl} \
    %{?_enable_curl:--enable-lastfm} \
    %{subst_enable ipv6} \
    %{subst_enable sun} \
    %{subst_enable oss} \
    %{subst_enable alsa} \
    %{subst_enable jack} \
    %{subst_enable pulse} \
    %{subst_enable fifo} \
    %{subst_enable mvp} \
    %{subst_enable vorbis} \
    %{subst_enable flac} \
    %{subst_enable oggflac} \
    %{subst_enable mad} \
    %{subst_enable_to lameenc lame-encoder} \
    %{subst_enable_to vorbisenc: vorbis-encoder} \
    %{subst_enable aac} \
    %{subst_enable audiofile} \
    %{subst_enable mikmod} \
    %{subst_enable modplug} \
    %{subst_enable mpc} \
    %{subst_enable ffmpeg} \
    %{subst_enable mp4ff} \
    %{subst_enable wavpack} \
    %{subst_enable id3} \
    %{subst_enable lsr} \
    %{subst_enable mms} \
    %{subst_enable sidplay} \
    %{subst_enable bzip2} \
    %{subst_enable zzip} \
    %{subst_enable iso9660} \
    %{subst_enable sqlite} \
    %{subst_enable fluidsynth} \
    %{subst_enable wildmidi} \
    %{subst_enable_to httpd_output httpd-output} \
    %{subst_enable_to doc documentation} \
    --with-zeroconf=%zeroconf \
    --docdir=%_docdir/%oname-%version
%make_build --silent --no-print-directory
bzip2 --best --keep --force NEWS


%check
%make_build --silent --no-print-directory check


%install
%makeinstall_std protocoldir=%_docdir/%oname-%version/html
ln -s html %buildroot%_docdir/%oname-%version/protocol
install -d %buildroot{%_localstatedir/%oname/playlists,{/var/run,%_logdir}/%oname,%_sysconfdir,%_initdir}
install -m 0644 %SOURCE1 %buildroot%_sysconfdir/%oname.conf
sed 's/@MPD_USER@/%mpd_user/g' %SOURCE2 > %buildroot%_sysconfdir/%oname.sys.conf
chmod 640 %buildroot%_sysconfdir/%oname.sys.conf
sed 's/@MPD_USER@/%mpd_user/g' %SOURCE3 > %buildroot%_initdir/%oname
chmod 755 %buildroot%_initdir/%oname
install -D -m 0644 %SOURCE4 %buildroot%_sysconfdir/logrotate.d/%oname
bzip2 --best %buildroot%_docdir/%oname-%version/NEWS


%pre
%_sbindir/groupadd -r -f %mpd_group &>/dev/null ||:
%_sbindir/useradd -r -n -M -s /dev/null -d %_localstatedir/%oname -g %mpd_group \
    -c "Music Player Daemon (%Name)" %mpd_user &>/dev/null ||:
%_sbindir/usermod -g %mpd_group -G audio %mpd_user &>/dev/null ||:


%post
%post_service %oname ||:


%preun
%preun_service %oname ||:


%files
%doc %dir %_docdir/%oname-%version
%doc %_docdir/%oname-%version/AUTHORS
%doc %_docdir/%oname-%version/README
%doc %_docdir/%oname-%version/COPYING
%doc %_docdir/%oname-%version/%{oname}conf.example
%if_disabled doc
%doc %_docdir/%oname-%version/NEWS.*
%doc %_docdir/%oname-%version/UPGRADING
%endif
%config(noreplace) %_sysconfdir/%oname.conf
%config(noreplace) %_sysconfdir/%oname.sys.conf
%config(noreplace) %_sysconfdir/logrotate.d/*
%_bindir/*
%_man1dir/*
%_man5dir/*
%_initdir/*
%attr(775,root,%mpd_group) %dir %_localstatedir/%oname
%attr(775,root,%mpd_group) %dir %_localstatedir/%oname/playlists
%attr(775,root,%mpd_group) %dir /var/run/%oname
%attr(775,root,%mpd_group) %dir %_logdir/%oname


%if_enabled doc
%files doc
%doc %dir %_docdir/%oname-%version
%doc %_docdir/%oname-%version/NEWS.*
%doc %_docdir/%oname-%version/UPGRADING
%doc %_docdir/%oname-%version/html
%doc %_docdir/%oname-%version/protocol
%doc %_docdir/%oname-%version/user
%doc %_docdir/%oname-%version/developer


%files doc-api
%doc %dir %_docdir/%oname-%version
%doc %_docdir/%oname-%version/api
%endif


%changelog
