# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: mpdscribble
Version: 0.18.1
Release: alt2.qa1

Summary: Audioscrobbler client for mpd
License: GPLv2+
Group: Sound
Url: http://mpd.wikia.com/wiki/Client:Mpdscribble
Packager: Slava Semushin <php-coder@altlinux.ru>

Source: http://downloads.sourceforge.net/musicpd/%name-%version.tar.bz2
Patch0: mpdscribble-alt-src-no_id3_tags.patch

BuildRequires: glib2-devel libsoup-devel pkg-config

%description
mpdscribble is a music player daemon client which submits information about
tracks being played to audioscrobbler (http://last.fm/).

%prep
%setup

# don't build with -pedantic-errors flag because it lead to errors in
# system headers
sed -i 's| -pedantic-errors||' configure.ac

# don't build with -Wcast-qual due to warnings from libsoup
# (https://bugzilla.gnome.org/show_bug.cgi?id=600315)
sed -i '/-Wcast-qual/d' configure.ac

# don't try to install documenation to non-versioned directory under
# /usr/share/doc
sed -i '/^doc_DATA/d' Makefile.am

# don't try to install config to /etc. We will pack it as example
# manually.
sed -i '/^dist_sysconf_DATA/d' Makefile.am

%patch0 -p2

%build
%autoreconf
%configure --enable-werror
%make_build --silent --no-print-directory

%install
%makeinstall --silent --no-print-directory

%files
%_bindir/%name
%_man1dir/%name.1.*
%doc AUTHORS NEWS README doc/%name.conf

%changelog
