%define svnrev 269

%def_enable nls
%def_enable gpm
%def_enable mp3
%def_enable audiocd
%def_enable ogg
%def_enable alsa
%def_enable disk_writer
%def_enable oss
%def_enable threads

%define Name MPFC
Name: mpfc
%define lname lib%name
Version: 1.3.8
Release: alt0.5.qa2
Summary: %Name is music player for console
License: %gpl2plus
Group: Sound
URL: http://%name.sourceforge.net
%ifdef svnrev
Source: %name-svn-r%svnrev.tar
%else
Source: %name-%version.tar
%endif
Patch: %name-svn-r269-alt.patch
Patch1: %name-1.3.8-alt-DSO.patch
Requires: %lname = %version-%release
Packager: Ilya Mashkin <oddity@altlinux.ru>

BuildRequires(pre): rpm-build-licenses
# Automatically added by buildreq on Wed Sep 24 2008
#BuildRequires: libalsa-devel libgpm-devel libmad-devel libncursesw-devel libvorbis-devel

BuildRequires: cvs libncursesw-devel gettext-tools
%{?_enable_gpm:BuildRequires: libgpm-devel}
%{?_enable_mp3:BuildRequires: libmad-devel}
%{?_enable_ogg:BuildRequires: libvorbis-devel}
%{?_enable_alsa:BuildRequires: libalsa-devel}

%description
%Name is an abbrevation for Music Player For Console.
It is a full-featured curses-based playlist-oriented player.
%Name has vi-style key bindings.


%package -n %lname
Summary: Shared libraries of %Name
Group: System/Libraries

%description -n %lname
%Name is an abbrevation for Music Player For Console.
It is a full-featured curses-based playlist-oriented player.
This package contains shared libraries of %Name.


%package -n %lname-devel
Summary: %Name is music player for console (development files)
Group: Development/C
Requires: %lname = %version-%release
Requires: libncursesw-devel
Obsoletes: %name-devel < %version-%release
Provides: %name-devel = %version-%release

%description -n %lname-devel
%Name is an abbrevation for Music Player For Console.
It is a full-featured curses-based playlist-oriented player.
This package contains files for development with %lname.


%prep
%setup %{?svnrev:-n %name-svn-r%svnrev}
%patch -p1
%patch1 -p2


%build
%set_automake_version 1.10
#set_autoconf_version 2.5

%define _optlevel 3
sh ./autogen.sh
%configure \
    --disable-static \
    --enable-shared \
    %{subst_enable nls} \
%if_enabled threads
    --enable-threads=posix \
%else
    --disable-threads \
%endif
    %{subst_enable gpm} \
    %{subst_enable mp3} \
    %{subst_enable audiocd} \
    %{subst_enable ogg} \
    %{subst_enable alsa} \
    %{subst_enable disk_writer} \
    %{subst_enable oss} \
    --with-pic \
    --with-gnu-ld
%make_build
bzip2 --best --keep --force ChangeLog


%install
%make_install DESTDIR=%buildroot install
install -d -m 0755 %buildroot%_libdir/%name/general
%find_lang %name




%files -f %name.lang
%doc AUTHORS ChangeLog.* NEWS README
%_bindir/*
%config(noreplace) %_sysconfdir/*
%dir %_libdir/%name/general
%dir %_libdir/%name/input
%dir %_libdir/%name/output
%_libdir/%name/input/*.so
%_libdir/%name/output/*.so
%_man1dir/*
%_infodir/*


%files -n %lname
%_libdir/*.so.*


%files -n %lname-devel
%_includedir/%name
%_libdir/*.so
%_pkgconfigdir/*


%changelog
